/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.dstore.processes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dstore.core.model.DataElement;
import org.eclipse.dstore.core.model.DataStore;
import org.eclipse.dstore.core.model.IDataStoreProvider;
import org.eclipse.rse.internal.services.dstore.ServiceResources;
import org.eclipse.rse.internal.services.dstore.processes.DStoreHostProcess;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.dstore.util.DStoreStatusMonitor;
import org.eclipse.rse.services.processes.AbstractProcessService;

public class DStoreProcessService
extends AbstractProcessService {
    protected IDataStoreProvider _provider;
    protected DataElement _minerElement = null;
    protected DStoreStatusMonitor _statusMonitor;
    protected DataElement _procMinerStatus;
    protected String[] _statusTypes;
    protected String _userName;

    public DStoreProcessService(IDataStoreProvider provider) {
        this._provider = provider;
    }

    public String getName() {
        return ServiceResources.DStore_Process_Service_Label;
    }

    public String getDescription() {
        return ServiceResources.DStore_Process_Service_Description;
    }

    public IHostProcess[] listAllProcesses(IHostProcessFilter filter, IProgressMonitor monitor) throws SystemMessageException {
        DataElement universaltemp;
        if (!this.isInitialized()) {
            this.waitForInitialize(monitor);
        }
        IHostProcess[] processes = null;
        DataStore ds = this.getDataStore();
        DataElement deObj = ds.find(universaltemp = this.getMinerElement(), 2, "universal.process.root", 1);
        if (deObj == null) {
            deObj = ds.createObject(universaltemp, "universal.process.filter", "universal.process.root", "", "", false);
        }
        deObj.setAttribute(4, filter.toString());
        DataElement queryCmd = ds.localDescriptorQuery(deObj.getDescriptor(), "C_PROCESS_FILTER_QUERY_ALL");
        if (queryCmd != null) {
            DataElement status = ds.command(queryCmd, deObj, true);
            DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
            try {
                smon.waitForUpdate(status);
            }
            catch (InterruptedException interruptedException) {
                throw new SystemMessageException(this.getMessage("RSEG1067"));
            }
            List nested = deObj.getNestedData();
            if (nested != null) {
                Object[] results = nested.toArray();
                String message = status.getAttribute(3);
                if (!message.equals("SUCCESS")) {
                    throw new SystemMessageException(this.getMessage("RSEPG1301"));
                }
                String userName = this.getRemoteUserName();
                if (userName != null && filter.getUsername().equals("${user.id}")) {
                    filter.setUsername(this.getRemoteUserName());
                }
                processes = this.convertObjsToHostProcesses(filter, results);
            }
        }
        return processes;
    }

    protected IHostProcess[] convertObjsToHostProcesses(IHostProcessFilter processFilter, Object[] objs) {
        if (objs == null) {
            return null;
        }
        ArrayList<DStoreHostProcess> list = new ArrayList<DStoreHostProcess>(objs.length);
        int idx = 0;
        while (idx < objs.length) {
            DataElement de = (DataElement)objs[idx];
            if (!de.isDeleted() && (processFilter == null || processFilter.allows(de.getValue()))) {
                DStoreHostProcess newProcess = new DStoreHostProcess(de);
                list.add(newProcess);
            }
            ++idx;
        }
        IHostProcess[] processes = new IHostProcess[list.size()];
        int idx2 = 0;
        while (idx2 < list.size()) {
            processes[idx2] = (IHostProcess)list.get(idx2);
            ++idx2;
        }
        return processes;
    }

    protected DataStore getDataStore() {
        return this._provider.getDataStore();
    }

    protected DataElement getMinerElement() {
        if (this._minerElement == null || this._minerElement.getDataStore() != this.getDataStore()) {
            this._minerElement = this.getDataStore().findMinerInformation("org.eclipse.rse.dstore.universal.miners.UniversalProcessMiner");
        }
        return this._minerElement;
    }

    public DStoreStatusMonitor getStatusMonitor(DataStore dataStore) {
        if (this._statusMonitor == null || this._statusMonitor.getDataStore() != dataStore) {
            this._statusMonitor = new DStoreStatusMonitor(dataStore);
        }
        return this._statusMonitor;
    }

    public boolean kill(long PID, String signal, IProgressMonitor monitor) throws SystemMessageException {
        block5: {
            String message;
            DStoreHostProcess process;
            block6: {
                DataStore ds;
                block4: {
                    try {
                        ds = this.getDataStore();
                        process = (DStoreHostProcess)this.getProcess(PID, monitor);
                        if (process != null) break block4;
                        return true;
                    }
                    catch (InterruptedException interruptedException) {
                        throw new SystemMessageException(this.getMessage("RSEG1067"));
                    }
                }
                DataElement deObj = (DataElement)process.getObject();
                DataElement killCmd = ds.localDescriptorQuery(deObj.getDescriptor(), "C_PROCESS_KILL");
                deObj.setAttribute(4, signal);
                if (killCmd == null) break block5;
                DataElement status = ds.command(killCmd, deObj, true);
                DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                smon.waitForUpdate(status);
                message = status.getAttribute(3);
                if (!message.equals("SUCCESS")) break block6;
                return true;
            }
            SystemMessage msg = this.getMessage("RSEPG1300");
            msg.makeSubstitution((Object)(String.valueOf(process.getName()) + " (" + process.getPid() + ")"), (Object)message);
            throw new SystemMessageException(msg);
        }
        return false;
    }

    public String[] getSignalTypes() {
        if (this._statusTypes != null) {
            return this._statusTypes;
        }
        this._statusTypes = this.internalGetSignalTypes();
        return this._statusTypes;
    }

    private String[] internalGetSignalTypes() {
        try {
            DataElement sigTypesElement = this.getSignalTypesMinerElement();
            String sigTypesOutput = sigTypesElement.getValue();
            String[] lines = sigTypesOutput.trim().split("\\s+");
            if (lines == null) {
                throw new Exception();
            }
            return lines;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected DataElement getSignalTypesMinerElement() {
        return this.getDataStore().find(this._minerElement, 2, "universal.killinfo");
    }

    public void initService(IProgressMonitor monitor) throws SystemMessageException {
        super.initService(monitor);
        this.initMiner(monitor);
    }

    public void uninitService(IProgressMonitor monitor) {
        this._minerElement = null;
        this._procMinerStatus = null;
        this._minerElement = null;
        this._statusMonitor = null;
        super.uninitService(monitor);
    }

    public boolean isInitialized() {
        if (this._procMinerStatus != null) {
            DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
            return smon.determineStatusDone(this._procMinerStatus);
        }
        return false;
    }

    protected void waitForInitialize(IProgressMonitor monitor) {
        if (this._procMinerStatus != null) {
            block3: {
                DStoreStatusMonitor smon = this.getStatusMonitor(this.getDataStore());
                try {
                    smon.waitForUpdate(this._procMinerStatus, monitor);
                }
                catch (InterruptedException interruptedException) {
                    if (monitor == null || monitor.isCanceled()) break block3;
                    monitor.setCanceled(true);
                }
            }
            this.getMinerElement();
        }
    }

    protected void initMiner(IProgressMonitor monitor) {
        DataElement fsElement = this.getMinerElement();
        if (fsElement == null && this.getServerVersion() >= 8) {
            String minerId = this.getMinerId();
            String message = SystemMessage.sub((String)ServiceResources.DStore_Service_ProgMon_Initializing_Message, (String)"&1", (String)minerId);
            monitor.beginTask(message, -1);
            DataStore ds = this.getDataStore();
            if ((this._minerElement == null || this._minerElement.getDataStore() != ds) && ds != null && this._procMinerStatus == null) {
                this._procMinerStatus = ds.activateMiner(minerId);
            }
        }
        monitor.done();
    }

    public String getRemoteUserName() {
        if (this._userName == null) {
            DataStore ds = this.getDataStore();
            DataElement encodingElement = ds.createObject(null, "universal.process.temp", "");
            DataElement queryCmd = ds.localDescriptorQuery(encodingElement.getDescriptor(), "C_PROCESS_QUERY_USERNAME");
            DStoreStatusMonitor monitor = this.getStatusMonitor(ds);
            DataElement status = ds.command(queryCmd, encodingElement, true);
            try {
                monitor.waitForUpdate(status);
            }
            catch (Exception exception) {}
            this._userName = encodingElement.getValue();
        }
        return this._userName;
    }

    protected String getMinerId() {
        return "org.eclipse.rse.dstore.universal.miners.UniversalProcessMiner";
    }

    public int getServerVersion() {
        return this.getDataStore().getServerVersion();
    }

    public int getServerMinor() {
        return this.getDataStore().getServerMinor();
    }

    protected String getProcessMinerId() {
        return "org.eclipse.rse.dstore.universal.miners.UniversalProcessMiner";
    }
}

