/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.ui.compile;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileCommand;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileProfile;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileRemoteObjectMatcher;
import org.eclipse.rse.internal.useractions.ui.compile.SystemCompileType;
import org.eclipse.rse.ui.view.ISystemRemoteElementAdapter;
import org.eclipse.rse.ui.view.SystemAdapterHelpers;

public class SystemCompileContributor {
    private IConfigurationElement config;
    private SystemCompileRemoteObjectMatcher matcher;

    public SystemCompileContributor(IConfigurationElement element) {
        this.config = element;
        String ssfId = element.getAttribute("subsystemconfigurationid");
        String namefilter = element.getAttribute("namefilter");
        String typefilter = element.getAttribute("typefilter");
        this.matcher = new SystemCompileRemoteObjectMatcher(ssfId, namefilter, typefilter);
    }

    public String getSubSystemFactoryId() {
        return this.matcher.getSubSystemFactoryId();
    }

    public String getNameFilter() {
        return this.matcher.getNameFilter();
    }

    public String getTypeFilter() {
        return this.matcher.getTypeFilter();
    }

    public boolean isApplicableTo(Object element) {
        return this.matcher.appliesTo(element);
    }

    public void contributeCompileCommand(SystemCompileProfile prf, Object element) {
        ISystemRemoteElementAdapter rmtAdapter = SystemAdapterHelpers.getRemoteAdapter((Object)element);
        if (rmtAdapter != null) {
            String srcType = rmtAdapter.getRemoteSourceType(element);
            if (srcType == null) {
                srcType = "null";
            } else if (srcType.equals("")) {
                srcType = "blank";
            }
            String id = this.config.getAttribute("id");
            String label = this.config.getAttribute("label");
            String commandString = this.config.getAttribute("commandstring");
            String labelEditable = this.config.getAttribute("labeleditable");
            String commandStringEditable = this.config.getAttribute("stringeditable");
            boolean isLabelEditable = true;
            boolean isCommandStringEditable = true;
            if (labelEditable != null && labelEditable.equalsIgnoreCase("false")) {
                isLabelEditable = false;
            }
            if (commandStringEditable != null && commandStringEditable.equalsIgnoreCase("false")) {
                isCommandStringEditable = false;
            }
            if (id == null || label == null || commandString == null || id.equals("") || label.equals("") || commandString.equals("")) {
                return;
            }
            SystemCompileType compileType = prf.getCompileType(srcType);
            if (compileType != null) {
                boolean labelExists;
                boolean idExists = compileType.isIdExists(id);
                if (!idExists && !(labelExists = compileType.isLabelExists(label))) {
                    int numOfCommands = compileType.getNumOfCommands();
                    SystemCompileCommand command = new SystemCompileCommand(compileType, id, label, "ISV defined", commandString, commandString, "Both", numOfCommands);
                    command.setLabelEditable(isLabelEditable);
                    command.setCommandStringEditable(isCommandStringEditable);
                    compileType.addCompileCommandInOrder(command);
                    if (numOfCommands == 0) {
                        compileType.setLastUsedCompileCommand(command);
                    }
                }
            } else {
                compileType = new SystemCompileType(prf, srcType);
                SystemCompileCommand command = new SystemCompileCommand(compileType, id, label, "ISV defined", commandString, commandString, "Both", 0);
                command.setLabelEditable(isLabelEditable);
                command.setCommandStringEditable(isCommandStringEditable);
                compileType.addCompileCommandInOrder(command);
                compileType.setLastUsedCompileCommand(command);
                prf.addCompileType(compileType);
            }
        }
    }
}

