/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.terminals.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.subsystems.terminals.core.ITerminalServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.terminals.core.TerminalServiceSubSystem;
import org.eclipse.rse.ui.propertypages.ServicesPropertyPage;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;

public class TerminalServicesPropertyPage
extends ServicesPropertyPage {
    private ITerminalServiceSubSystemConfiguration _currentFactory;

    protected TerminalServiceSubSystem getTerminalServiceSubSystem() {
        return (TerminalServiceSubSystem)this.getElement();
    }

    protected ServiceElement[] getServiceElements() {
        TerminalServiceSubSystem subSystem = this.getTerminalServiceSubSystem();
        IHost host = subSystem.getHost();
        this._currentFactory = subSystem.getParentRemoteTerminalSubSystemConfiguration();
        ITerminalServiceSubSystemConfiguration[] factories = this.getTerminalServiceSubSystemConfigurations(host.getSystemType());
        ServiceElement[] elements = new ServiceElement[factories.length];
        int i = 0;
        while (i < factories.length) {
            ITerminalServiceSubSystemConfiguration factory = factories[i];
            elements[i] = new FactoryServiceElement(host, (ISubSystemConfiguration)factory);
            if (factory == this._currentFactory) {
                elements[i].setSelected(true);
            }
            ++i;
        }
        return elements;
    }

    protected ITerminalServiceSubSystemConfiguration[] getTerminalServiceSubSystemConfigurations(IRSESystemType systemType) {
        ArrayList<ISubSystemConfiguration> results = new ArrayList<ISubSystemConfiguration>();
        ISystemRegistry sr = RSECorePlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType, false, true);
        int i = 0;
        while (i < factories.length) {
            ISubSystemConfiguration factory = factories[i];
            if (factory instanceof ITerminalServiceSubSystemConfiguration) {
                results.add(factory);
            }
            ++i;
        }
        return results.toArray(new ITerminalServiceSubSystemConfiguration[results.size()]);
    }

    protected ISubSystemConfiguration getCurrentSubSystemConfiguration() {
        return this._currentFactory;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
        this._currentFactory = (ITerminalServiceSubSystemConfiguration)factory;
    }
}

