/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.wizards.newconnection;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.wizards.newconnection.IRSENewConnectionWizardDescriptor;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardRegistry;
import org.eclipse.rse.ui.wizards.newconnection.RSENewConnectionWizardSelectionPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class RSEMainNewConnectionWizard
extends Wizard
implements INewWizard,
ISelectionProvider {
    public static final String LAST_SELECTED_SYSTEM_TYPE_ID = "lastSelectedSystemTypeId";
    private ISelection selectedContext;
    private IHost connectionContext;
    private RSENewConnectionWizardRegistry wizardRegistry;
    private IWizard selectedWizard;
    private IRSESystemType selectedSystemType;
    private boolean selectedWizardCanFinishEarly;
    private RSENewConnectionWizardSelectionPage mainPage;
    private final List initializedWizards = new LinkedList();
    private final List selectionChangedListener = new LinkedList();
    private IRSESystemType[] restrictedSystemTypes;
    private boolean onlySystemType;

    public RSEMainNewConnectionWizard() {
        this.setWindowTitle(SystemResources.RESID_NEWCONN_TITLE);
        this.setForcePreviousAndNextButtons(true);
        this.setNeedsProgressMonitor(true);
        IDialogSettings settings = RSEUIPlugin.getDefault().getDialogSettings();
        String sectionName = ((Object)((Object)this)).getClass().getName();
        if (settings.getSection(sectionName) == null) {
            settings.addNewSection(sectionName);
        }
        this.setDialogSettings(settings.getSection(sectionName));
        this.wizardRegistry = new RSENewConnectionWizardRegistry();
        this.selectedContext = null;
        this.selectedWizard = null;
        this.mainPage = new RSENewConnectionWizardSelectionPage(this.wizardRegistry);
        this.initializedWizards.clear();
        this.selectionChangedListener.clear();
    }

    public void dispose() {
        super.dispose();
        this.selectedContext = null;
        this.selectedSystemType = null;
        this.selectedWizardCanFinishEarly = false;
        this.mainPage = null;
        this.initializedWizards.clear();
        this.selectionChangedListener.clear();
        this.restrictedSystemTypes = null;
        this.onlySystemType = false;
    }

    public Image getDefaultPageImage() {
        return RSEUIPlugin.getDefault().getImage("org.eclipse.rse.ui.newconnection_wizBannerIcon");
    }

    public void restrictToSystemType(IRSESystemType systemType) {
        this.restrictToSystemTypes(new IRSESystemType[]{systemType});
    }

    public void restrictToSystemTypes(IRSESystemType[] systemTypes) {
        assert (systemTypes != null);
        this.restrictedSystemTypes = systemTypes;
        this.onlySystemType = this.restrictedSystemTypes.length == 1;
        this.mainPage.restrictToSystemTypes(this.restrictedSystemTypes);
        if (this.onlySystemType && !this.restrictedSystemTypes[0].equals(this.selectedSystemType)) {
            this.selectedSystemType = this.restrictedSystemTypes[0];
        } else if (this.restrictedSystemTypes.length > 0 && !Arrays.asList(this.restrictedSystemTypes).contains(this.selectedSystemType)) {
            this.selectedSystemType = null;
        } else if (this.restrictedSystemTypes.length == 0) {
            this.selectedSystemType = null;
        }
        this.onSelectedSystemTypeChanged();
    }

    public final boolean isRestrictedToSingleSystemType() {
        return this.onlySystemType;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        assert (listener != null);
        if (!this.selectionChangedListener.contains(listener)) {
            this.selectionChangedListener.add(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        assert (listener != null);
        this.selectionChangedListener.remove(listener);
    }

    private void fireSelectionChanged() {
        if (this.getSelection() == null) {
            return;
        }
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionChangedListener) {
            listener.selectionChanged(event);
        }
    }

    public ISelection getSelection() {
        IRSESystemType selected;
        StructuredSelection selection = null;
        IRSESystemType iRSESystemType = selected = this.isRestrictedToSingleSystemType() ? this.restrictedSystemTypes[0] : this.selectedSystemType;
        if (selected != null) {
            ArrayList<Object> selectionElements = new ArrayList<Object>();
            selectionElements.add(selected);
            if (this.selectedContext != null) {
                selectionElements.add(this.selectedContext);
            }
            selection = new StructuredSelection(selectionElements);
        }
        return selection;
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IRSESystemType candidate;
            IStructuredSelection sel = (IStructuredSelection)selection;
            this.selectedSystemType = null;
            if (sel.getFirstElement() instanceof IRSESystemType && (candidate = (IRSESystemType)((IStructuredSelection)selection).getFirstElement()).isEnabled() && (this.restrictedSystemTypes == null || this.restrictedSystemTypes.length == 0 || Arrays.asList(this.restrictedSystemTypes).contains(candidate))) {
                this.selectedSystemType = candidate;
            }
            this.onSelectedSystemTypeChanged();
        }
    }

    public void setSelectedContext(ISelection selectedContext) {
        this.selectedContext = selectedContext;
    }

    public void setConnectionContext(IHost connectionContext) {
        IRSESystemType systemType;
        this.connectionContext = connectionContext;
        if (connectionContext != null && connectionContext.getSystemType() != null && (systemType = connectionContext.getSystemType()) != null) {
            this.setSelection((ISelection)new StructuredSelection((Object)systemType));
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.setSelection((ISelection)selection);
    }

    public IWizard getSelectedWizard() {
        return this.selectedWizard;
    }

    protected void onSelectedSystemTypeChanged() {
        IRSENewConnectionWizardDescriptor descriptor;
        if (this.selectedWizard instanceof ISelectionChangedListener) {
            this.removeSelectionChangedListener((ISelectionChangedListener)this.selectedWizard);
        }
        IRSENewConnectionWizardDescriptor iRSENewConnectionWizardDescriptor = descriptor = this.getSelection() != null ? this.wizardRegistry.getWizardForSelection((IStructuredSelection)this.getSelection()) : null;
        if (descriptor != null) {
            this.selectedWizard = descriptor.getWizard();
            this.selectedWizardCanFinishEarly = descriptor.canFinishEarly();
        } else {
            this.selectedWizard = null;
            this.selectedWizardCanFinishEarly = false;
        }
        if (this.getContainer() != null && this.selectedWizard != null && !this.getContainer().equals(this.selectedWizard.getContainer())) {
            this.selectedWizard.setContainer(this.getContainer());
        }
        if (this.selectedWizard instanceof Wizard && (this.selectedWizard.getWindowTitle() == null || "".equals(this.selectedWizard.getWindowTitle()))) {
            ((Wizard)this.selectedWizard).setWindowTitle(this.getWindowTitle());
        }
        if (this.selectedWizard instanceof RSEDefaultNewConnectionWizard) {
            ((RSEDefaultNewConnectionWizard)this.selectedWizard).setSelectedContext(this.connectionContext);
        }
        if (this.selectedWizard instanceof ISelectionChangedListener) {
            this.addSelectionChangedListener((ISelectionChangedListener)this.selectedWizard);
        }
        if (!(this.onlySystemType && this.mainPage.getPreviousPage() == null || this.selectedWizard == null || this.initializedWizards.contains(this.selectedWizard))) {
            this.selectedWizard.addPages();
            this.initializedWizards.add(this.selectedWizard);
        }
        this.fireSelectionChanged();
        IWizardContainer container = this.getContainer();
        if (container != null && container.getCurrentPage() != null) {
            container.updateWindowTitle();
            container.updateTitleBar();
            container.updateButtons();
        }
    }

    public void addPages() {
        this.addPage((IWizardPage)this.mainPage);
        this.restoreWidgetValues();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        IWizardPage nextPage = null;
        if (page != null && page == this.mainPage) {
            this.saveWidgetValues();
            if (this.getSelectedWizard() != null) {
                nextPage = this.getSelectedWizard().getStartingPage();
            }
        }
        if (nextPage == null) {
            super.getNextPage(page);
        }
        if (nextPage != null) {
            nextPage.setPreviousPage(page);
        }
        return nextPage;
    }

    public boolean canFinish() {
        return this.selectedWizardCanFinishEarly;
    }

    public boolean performFinish() {
        this.saveWidgetValues();
        if (this.mainPage != null) {
            this.mainPage.saveWidgetValues();
        }
        return true;
    }

    protected void saveWidgetValues() {
        IStructuredSelection selection;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && this.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)this.getSelection()).getFirstElement() instanceof IRSESystemType) {
            dialogSettings.put(LAST_SELECTED_SYSTEM_TYPE_ID, ((IRSESystemType)selection.getFirstElement()).getId());
        }
    }

    protected void restoreWidgetValues() {
        IRSESystemType systemType;
        String systemTypeId;
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null && (systemTypeId = dialogSettings.get(LAST_SELECTED_SYSTEM_TYPE_ID)) != null && (systemType = RSECorePlugin.getTheCoreRegistry().getSystemTypeById(systemTypeId)) != null && systemType.isEnabled()) {
            this.setSelection((ISelection)new StructuredSelection((Object)systemType));
        }
    }
}

