/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.internal.terminal.emulator;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.SocketException;
import java.nio.charset.Charset;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.SWTKeySupport;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm.internal.terminal.control.ICommandInputField;
import org.eclipse.tm.internal.terminal.control.ITerminalListener;
import org.eclipse.tm.internal.terminal.control.ITerminalViewControl;
import org.eclipse.tm.internal.terminal.control.impl.ITerminalControlForText;
import org.eclipse.tm.internal.terminal.control.impl.TerminalMessages;
import org.eclipse.tm.internal.terminal.control.impl.TerminalPlugin;
import org.eclipse.tm.internal.terminal.emulator.EditActionAccelerators;
import org.eclipse.tm.internal.terminal.emulator.LoggingOutputStream;
import org.eclipse.tm.internal.terminal.emulator.VT100Emulator;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalConnector;
import org.eclipse.tm.internal.terminal.provisional.api.ITerminalControl;
import org.eclipse.tm.internal.terminal.provisional.api.Logger;
import org.eclipse.tm.internal.terminal.provisional.api.TerminalState;
import org.eclipse.tm.internal.terminal.textcanvas.PipedInputStream;
import org.eclipse.tm.internal.terminal.textcanvas.PollingTextCanvasModel;
import org.eclipse.tm.internal.terminal.textcanvas.TextCanvas;
import org.eclipse.tm.internal.terminal.textcanvas.TextLineRenderer;
import org.eclipse.tm.terminal.model.ITerminalTextData;
import org.eclipse.tm.terminal.model.ITerminalTextDataSnapshot;
import org.eclipse.tm.terminal.model.TerminalTextDataFactory;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.keys.IBindingService;

public class VT100TerminalControl
implements ITerminalControlForText,
ITerminalControl,
ITerminalViewControl {
    protected static final String[] LINE_DELIMITERS = new String[]{"\n"};
    private final VT100Emulator fTerminalText;
    private Display fDisplay;
    private TextCanvas fCtlText;
    private Composite fWndParent;
    private Clipboard fClipboard;
    private KeyListener fKeyHandler;
    private final ITerminalListener fTerminalListener;
    private String fMsg = "";
    private TerminalFocusListener fFocusListener;
    private ITerminalConnector fConnector;
    private final ITerminalConnector[] fConnectors;
    private final boolean fUseCommonPrefs;
    private boolean connectOnEnterIfClosed = true;
    PipedInputStream fInputStream;
    private static final String defaultEncoding = Charset.defaultCharset().name();
    private String fEncoding = defaultEncoding;
    private InputStreamReader fInputStreamReader;
    private ICommandInputField fCommandInputField;
    private volatile TerminalState fState;
    private final ITerminalTextData fTerminalModel;
    private final EditActionAccelerators editActionAccelerators = new EditActionAccelerators();
    private boolean fApplicationCursorKeys;
    private final IPropertyChangeListener fPreferenceListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("TerminalPrefBufferLines") || event.getProperty().equals("TerminalPrefInvertColors")) {
                VT100TerminalControl.this.updatePreferences();
            }
        }
    };
    private final IPropertyChangeListener fFontListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty().equals("terminal.views.view.font.definition")) {
                VT100TerminalControl.this.onTerminalFontChanged();
            }
        }
    };
    private volatile Job fJob;
    private PollingTextCanvasModel fPollingTextCanvasModel;

    public VT100TerminalControl(ITerminalListener target, Composite wndParent, ITerminalConnector[] connectors) {
        this(target, wndParent, connectors, false);
    }

    public VT100TerminalControl(ITerminalListener target, Composite wndParent, ITerminalConnector[] connectors, boolean useCommonPrefs) {
        this.fConnectors = connectors;
        this.fUseCommonPrefs = useCommonPrefs;
        this.fTerminalListener = target;
        this.fTerminalModel = TerminalTextDataFactory.makeTerminalTextData();
        this.fTerminalModel.setMaxHeight(1000);
        this.fInputStream = new PipedInputStream(8192);
        this.fTerminalText = new VT100Emulator(this.fTerminalModel, this, null);
        try {
            this.setEncoding(null);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            this.fEncoding = defaultEncoding;
            this.fInputStreamReader = new InputStreamReader(this.fInputStream);
            this.fTerminalText.setInputStreamReader(this.fInputStreamReader);
        }
        this.setupTerminal(wndParent);
    }

    @Override
    public void setEncoding(String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        this.fInputStreamReader = new InputStreamReader((InputStream)this.fInputStream, encoding);
        this.fEncoding = encoding;
        this.fTerminalText.setInputStreamReader(this.fInputStreamReader);
    }

    @Override
    public String getEncoding() {
        return this.fEncoding;
    }

    @Override
    public ITerminalConnector[] getConnectors() {
        return this.fConnectors;
    }

    @Override
    public void copy() {
        this.copy(1);
    }

    private void copy(int clipboardType) {
        String selection = this.getSelection();
        if (selection.length() > 0) {
            Object[] data = new Object[]{selection};
            Transfer[] types = new Transfer[]{TextTransfer.getInstance()};
            this.fClipboard.setContents(data, types, clipboardType);
        }
    }

    @Override
    public void paste() {
        this.paste(1);
    }

    private void paste(int clipboardType) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        String strText = (String)this.fClipboard.getContents((Transfer)textTransfer, clipboardType);
        this.pasteString(strText);
    }

    @Override
    public boolean pasteString(String strText) {
        if (!this.isConnected()) {
            return false;
        }
        if (strText == null) {
            return false;
        }
        if (!this.fEncoding.equals(defaultEncoding)) {
            this.sendString(strText);
        } else {
            int i = 0;
            while (i < strText.length()) {
                this.sendChar(strText.charAt(i), false);
                ++i;
            }
        }
        return true;
    }

    @Override
    public void selectAll() {
        this.getCtlText().selectAll();
    }

    @Override
    public void sendKey(char character) {
        Event event = new Event();
        event.widget = this.getCtlText();
        event.character = character;
        event.keyCode = 0;
        event.stateMask = 0;
        event.doit = true;
        KeyEvent keyEvent = new KeyEvent(event);
        this.fKeyHandler.keyPressed(keyEvent);
    }

    @Override
    public void clearTerminal() {
        this.getTerminalText().clearTerminal();
    }

    @Override
    public Clipboard getClipboard() {
        return this.fClipboard;
    }

    @Override
    public String getSelection() {
        String txt = this.fCtlText.getSelectionText();
        if (txt == null) {
            txt = "";
        }
        return txt;
    }

    @Override
    public void setFocus() {
        this.getCtlText().setFocus();
    }

    @Override
    public boolean isEmpty() {
        return this.getCtlText().isEmpty();
    }

    @Override
    public boolean isDisposed() {
        return this.getCtlText().isDisposed();
    }

    @Override
    public boolean isConnected() {
        return this.fState == TerminalState.CONNECTED;
    }

    @Override
    public void disposeTerminal() {
        Logger.log("entered.");
        if (this.fUseCommonPrefs) {
            TerminalPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPreferenceListener);
            JFaceResources.getFontRegistry().removeListener(this.fFontListener);
        }
        this.disconnectTerminal();
        this.fClipboard.dispose();
        this.getTerminalText().dispose();
    }

    @Override
    public void connectTerminal() {
        Logger.log("entered.");
        if (this.getTerminalConnector() == null) {
            return;
        }
        this.fTerminalText.resetState();
        this.fApplicationCursorKeys = false;
        if (this.fConnector.getInitializationErrorMessage() != null) {
            this.showErrorMessage(NLS.bind((String)TerminalMessages.CannotConnectTo, (Object)this.fConnector.getName(), (Object)this.fConnector.getInitializationErrorMessage()));
            return;
        }
        this.setMsg("");
        this.getTerminalConnector().connect(this);
        this.waitForConnect();
    }

    @Override
    public ITerminalConnector getTerminalConnector() {
        return this.fConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnectTerminal() {
        Job job;
        Logger.log("entered.");
        if (this.getState() != TerminalState.CLOSED && this.getTerminalConnector() != null) {
            this.getTerminalConnector().disconnect();
        }
        VT100TerminalControl vT100TerminalControl = this;
        synchronized (vT100TerminalControl) {
            job = this.fJob;
            this.fJob = null;
        }
        if (job != null) {
            job.cancel();
            Thread t = job.getThread();
            if (t != null) {
                t.interrupt();
            }
            try {
                job.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.fPollingTextCanvasModel.stopPolling();
    }

    private void waitForConnect() {
        Logger.log("entered.");
        do {
            if (this.fDisplay.readAndDispatch()) continue;
            this.fDisplay.sleep();
        } while (this.getState() == TerminalState.CONNECTING);
        if (this.getCtlText().isDisposed()) {
            this.disconnectTerminal();
            return;
        }
        if (this.getMsg().length() > 0) {
            this.showErrorMessage(this.getMsg());
            this.disconnectTerminal();
            return;
        }
        if (this.getCtlText().isFocusControl() && this.getState() == TerminalState.CONNECTED) {
            this.fFocusListener.captureKeyEvents(true);
        }
        this.fPollingTextCanvasModel.startPolling();
        this.startReaderJob();
    }

    private synchronized void startReaderJob() {
        if (this.fJob == null) {
            this.fJob = new Job("Terminal data reader"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected IStatus run(IProgressMonitor monitor) {
                    IStatus status = Status.OK_STATUS;
                    block12: while (true) {
                        try {
                            while (VT100TerminalControl.this.fInputStream.available() == 0 && !monitor.isCanceled()) {
                                try {
                                    VT100TerminalControl.this.fInputStream.waitForAvailable(500L);
                                    continue block12;
                                }
                                catch (InterruptedException interruptedException) {
                                    Thread.currentThread().interrupt();
                                }
                            }
                            if (monitor.isCanceled()) {
                                status = Status.CANCEL_STATUS;
                                break;
                            }
                            try {
                                VT100TerminalControl.this.fTerminalText.processText();
                            }
                            catch (Exception e) {
                                VT100TerminalControl.this.disconnectTerminal();
                                status = new Status(4, "org.eclipse.tm.terminal.control", e.getLocalizedMessage(), (Throwable)e);
                                break;
                            }
                        }
                        catch (Throwable throwable) {
                            VT100TerminalControl vT100TerminalControl = VT100TerminalControl.this;
                            synchronized (vT100TerminalControl) {
                                if (VT100TerminalControl.this.fJob == this) {
                                    VT100TerminalControl.this.fJob = null;
                                }
                            }
                            throw throwable;
                        }
                    }
                    VT100TerminalControl vT100TerminalControl = VT100TerminalControl.this;
                    synchronized (vT100TerminalControl) {
                        if (VT100TerminalControl.this.fJob == this) {
                            VT100TerminalControl.this.fJob = null;
                        }
                    }
                    return status;
                }
            };
            this.fJob.setSystem(true);
            this.fJob.schedule();
        }
    }

    private void showErrorMessage(String message) {
        String strTitle = TerminalMessages.TerminalError;
        MessageBox mb = new MessageBox(this.getShell(), 33);
        mb.setText(strTitle);
        mb.setMessage(message);
        mb.open();
    }

    protected void sendString(String string) {
        try {
            this.getOutputStream().write(string.getBytes(this.fEncoding));
            this.getOutputStream().flush();
        }
        catch (SocketException socketException) {
            this.displayTextInTerminal(socketException.getMessage());
            String strMsg = String.valueOf(TerminalMessages.SocketError) + "!\n" + socketException.getMessage();
            this.showErrorMessage(strMsg);
            Logger.logException(socketException);
            this.disconnectTerminal();
        }
        catch (IOException ioException) {
            this.showErrorMessage(String.valueOf(TerminalMessages.IOError) + "!\n" + ioException.getMessage());
            Logger.logException(ioException);
            this.disconnectTerminal();
        }
    }

    @Override
    public Shell getShell() {
        return this.getCtlText().getShell();
    }

    protected void sendChar(char chKey, boolean altKeyPressed) {
        try {
            char byteToSend = chKey;
            OutputStream os = this.getOutputStream();
            if (os == null) {
                Logger.log("NOT sending '" + byteToSend + "' because no longer connected");
            } else {
                if (altKeyPressed) {
                    byte[] bytesToSend = String.valueOf(chKey).getBytes(this.fEncoding);
                    StringBuilder b = new StringBuilder("sending ESC");
                    int i = 0;
                    while (i < bytesToSend.length) {
                        if (i != 0) {
                            b.append(" +");
                        }
                        b.append(" '" + bytesToSend[i] + "'");
                        ++i;
                    }
                    Logger.log(b.toString());
                    os.write(27);
                    os.write(bytesToSend);
                } else {
                    byte[] bytesToSend = String.valueOf(chKey).getBytes(this.fEncoding);
                    StringBuilder b = new StringBuilder("sending");
                    int i = 0;
                    while (i < bytesToSend.length) {
                        if (i != 0) {
                            b.append(" +");
                        }
                        b.append(" '" + bytesToSend[i] + "'");
                        ++i;
                    }
                    Logger.log(b.toString());
                    os.write(bytesToSend);
                }
                os.flush();
            }
        }
        catch (SocketException socketException) {
            Logger.logException(socketException);
            this.displayTextInTerminal(socketException.getMessage());
            String strMsg = String.valueOf(TerminalMessages.SocketError) + "!\n" + socketException.getMessage();
            this.showErrorMessage(strMsg);
            Logger.logException(socketException);
            this.disconnectTerminal();
        }
        catch (IOException ioException) {
            Logger.logException(ioException);
            this.displayTextInTerminal(ioException.getMessage());
            String strMsg = String.valueOf(TerminalMessages.IOError) + "!\n" + ioException.getMessage();
            this.showErrorMessage(strMsg);
            Logger.logException(ioException);
            this.disconnectTerminal();
        }
    }

    @Override
    public void setupTerminal(Composite parent) {
        Assert.isNotNull((Object)parent);
        boolean wasDisposed = true;
        TerminalState oldState = this.fState;
        this.fState = TerminalState.CLOSED;
        if (this.fClipboard != null && !this.fClipboard.isDisposed()) {
            wasDisposed = false;
            this.fClipboard.dispose();
            this.fPollingTextCanvasModel.stopPolling();
        }
        if (this.fWndParent != null && !this.fWndParent.isDisposed()) {
            this.fWndParent.dispose();
        }
        this.setupControls(parent);
        this.setCommandInputField(this.fCommandInputField);
        this.setupListeners();
        if (this.fUseCommonPrefs && wasDisposed) {
            this.updatePreferences();
            this.onTerminalFontChanged();
            TerminalPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPreferenceListener);
            JFaceResources.getFontRegistry().addListener(this.fFontListener);
        }
        this.setupHelp(this.fWndParent, "org.eclipse.tm.terminal.control.terminal_view");
        if (!wasDisposed) {
            this.fState = oldState;
        }
    }

    private void updatePreferences() {
        int bufferLineLimit = Platform.getPreferencesService().getInt("org.eclipse.tm.terminal.control", "TerminalPrefBufferLines", 0, null);
        boolean invert = Platform.getPreferencesService().getBoolean("org.eclipse.tm.terminal.control", "TerminalPrefInvertColors", false, null);
        this.setBufferLineLimit(bufferLineLimit);
        this.setInvertedColors(invert);
    }

    private void onTerminalFontChanged() {
        this.setFont("terminal.views.view.font.definition");
    }

    @Override
    public void setFont(String fontName) {
        Font font = JFaceResources.getFont((String)fontName);
        this.getCtlText().setFont(font);
        if (this.fCommandInputField != null) {
            this.fCommandInputField.setFont(font);
        }
        this.fCtlText.updateFont(fontName);
        this.getTerminalText().fontChanged();
    }

    @Override
    @Deprecated
    public void setFont(Font font) {
        this.getCtlText().setFont(font);
        if (this.fCommandInputField != null) {
            this.fCommandInputField.setFont(font);
        }
        this.fCtlText.onFontChange();
        this.getTerminalText().fontChanged();
    }

    @Override
    public Font getFont() {
        return this.getCtlText().getFont();
    }

    @Override
    public Control getControl() {
        return this.fCtlText;
    }

    @Override
    public Control getRootControl() {
        return this.fWndParent;
    }

    protected void setupControls(Composite parent) {
        this.fWndParent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.fWndParent.setLayout((Layout)layout);
        ITerminalTextDataSnapshot snapshot = this.fTerminalModel.makeSnapshot();
        snapshot.updateSnapshot(false);
        this.fPollingTextCanvasModel = new PollingTextCanvasModel(snapshot);
        this.fCtlText = new TextCanvas(this.fWndParent, this.fPollingTextCanvasModel, 0, new TextLineRenderer(this.fCtlText, this.fPollingTextCanvasModel));
        this.fCtlText.setLayoutData(new GridData(4, 4, true, true));
        this.fCtlText.addResizeHandler(new TextCanvas.ResizeListener(){

            @Override
            public void sizeChanged(int lines, int columns) {
                VT100TerminalControl.this.fTerminalText.setDimensions(lines, columns);
            }
        });
        this.fCtlText.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                if (e.button == 1 && VT100TerminalControl.this.getSelection().length() > 0) {
                    VT100TerminalControl.this.copy(2);
                }
            }
        });
        this.fDisplay = this.getCtlText().getDisplay();
        this.fClipboard = new Clipboard(this.fDisplay);
    }

    protected void setupListeners() {
        this.fKeyHandler = new TerminalKeyHandler();
        this.fFocusListener = new TerminalFocusListener();
        this.getCtlText().addKeyListener(this.fKeyHandler);
        this.getCtlText().addFocusListener(this.fFocusListener);
    }

    protected void setupHelp(Composite parent, String id) {
        Control[] children = parent.getChildren();
        int nIndex = 0;
        while (nIndex < children.length) {
            if (children[nIndex] instanceof Composite) {
                this.setupHelp((Composite)children[nIndex], id);
            }
            ++nIndex;
        }
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, id);
    }

    @Override
    public void displayTextInTerminal(String text) {
        this.writeToTerminal("\r\n" + text + "\r\n");
    }

    private void writeToTerminal(String text) {
        try {
            this.getRemoteToTerminalOutputStream().write(text.getBytes(this.fEncoding));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public OutputStream getRemoteToTerminalOutputStream() {
        if (Logger.isLogEnabled()) {
            return new LoggingOutputStream(this.fInputStream.getOutputStream());
        }
        return this.fInputStream.getOutputStream();
    }

    protected boolean isLogCharEnabled() {
        return TerminalPlugin.isOptionEnabled("org.eclipse.tm.terminal.control/debug/log/char");
    }

    @Override
    public OutputStream getOutputStream() {
        if (this.getTerminalConnector() != null) {
            return this.getTerminalConnector().getTerminalToRemoteStream();
        }
        return null;
    }

    @Override
    public void setMsg(String msg) {
        this.fMsg = msg;
    }

    public String getMsg() {
        return this.fMsg;
    }

    protected TextCanvas getCtlText() {
        return this.fCtlText;
    }

    public VT100Emulator getTerminalText() {
        return this.fTerminalText;
    }

    @Override
    public void setTerminalTitle(String title) {
        this.fTerminalListener.setTerminalTitle(title);
    }

    @Override
    public TerminalState getState() {
        return this.fState;
    }

    @Override
    public void setState(TerminalState state) {
        this.fState = state;
        this.fTerminalListener.setState(state);
        this.runAsyncInDisplayThread(new Runnable(){

            @Override
            public void run() {
                if (VT100TerminalControl.this.fCtlText != null && !VT100TerminalControl.this.fCtlText.isDisposed()) {
                    if (VT100TerminalControl.this.isConnected()) {
                        VT100TerminalControl.this.fCtlText.setCursorEnabled(true);
                    } else {
                        VT100TerminalControl.this.fCtlText.setCursorEnabled(false);
                        VT100TerminalControl.this.fFocusListener.captureKeyEvents(false);
                    }
                }
            }
        });
    }

    private void runAsyncInDisplayThread(Runnable runnable) {
        if (Display.findDisplay((Thread)Thread.currentThread()) != null) {
            runnable.run();
        } else if (PlatformUI.isWorkbenchRunning() && PlatformUI.getWorkbench().getDisplay() != null && !PlatformUI.getWorkbench().getDisplay().isDisposed()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
        }
    }

    @Override
    public String getSettingsSummary() {
        if (this.getTerminalConnector() != null) {
            return this.getTerminalConnector().getSettingsSummary();
        }
        return "";
    }

    @Override
    public void setConnector(ITerminalConnector connector) {
        this.fConnector = connector;
    }

    @Override
    public ICommandInputField getCommandInputField() {
        return this.fCommandInputField;
    }

    @Override
    public void setCommandInputField(ICommandInputField inputField) {
        if (this.fCommandInputField != null) {
            this.fCommandInputField.dispose();
        }
        this.fCommandInputField = inputField;
        if (this.fCommandInputField != null) {
            this.fCommandInputField.createControl(this.fWndParent, this);
        }
        if (this.fWndParent.isVisible()) {
            this.fWndParent.layout(true);
        }
    }

    @Override
    public int getBufferLineLimit() {
        return this.fTerminalModel.getMaxHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBufferLineLimit(int bufferLineLimit) {
        if (bufferLineLimit <= 0) {
            return;
        }
        ITerminalTextData iTerminalTextData = this.fTerminalModel;
        synchronized (iTerminalTextData) {
            if (this.fTerminalModel.getHeight() > bufferLineLimit) {
                this.fTerminalModel.setDimensions(bufferLineLimit, this.fTerminalModel.getWidth());
            }
            this.fTerminalModel.setMaxHeight(bufferLineLimit);
        }
    }

    @Override
    public boolean isScrollLock() {
        return this.fCtlText.isScrollLock();
    }

    @Override
    public void setScrollLock(boolean on) {
        this.fCtlText.setScrollLock(on);
    }

    @Override
    public void setInvertedColors(boolean invert) {
        this.fCtlText.setInvertedColors(invert);
    }

    @Override
    public final void setConnectOnEnterIfClosed(boolean on) {
        this.connectOnEnterIfClosed = on;
    }

    @Override
    public final boolean isConnectOnEnterIfClosed() {
        return this.connectOnEnterIfClosed;
    }

    @Override
    public void setVT100LineWrapping(boolean enable) {
        this.getTerminalText().setVT100LineWrapping(enable);
    }

    @Override
    public boolean isVT100LineWrapping() {
        return this.getTerminalText().isVT100LineWrapping();
    }

    @Override
    public void enableApplicationCursorKeys(boolean enable) {
        this.fApplicationCursorKeys = enable;
    }

    protected class TerminalFocusListener
    implements FocusListener {
        private IContextActivation terminalContextActivation = null;
        private IContextActivation editContextActivation = null;

        protected TerminalFocusListener() {
        }

        public void focusGained(FocusEvent event) {
            if (VT100TerminalControl.this.getState() == TerminalState.CONNECTED) {
                this.captureKeyEvents(true);
            }
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
            this.editContextActivation = contextService.activateContext("org.eclipse.tm.terminal.EditContext");
        }

        public void focusLost(FocusEvent event) {
            this.captureKeyEvents(false);
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
            contextService.deactivateContext(this.editContextActivation);
        }

        protected void captureKeyEvents(boolean capture) {
            boolean enableKeyFilter;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            IContextService contextService = (IContextService)PlatformUI.getWorkbench().getAdapter(IContextService.class);
            boolean bl = enableKeyFilter = !capture;
            if (bindingService.isKeyFilterEnabled() != enableKeyFilter) {
                bindingService.setKeyFilterEnabled(enableKeyFilter);
            }
            if (capture && this.terminalContextActivation == null) {
                this.terminalContextActivation = contextService.activateContext("org.eclipse.tm.terminal.TerminalContext");
            } else if (!capture && this.terminalContextActivation != null) {
                contextService.deactivateContext(this.terminalContextActivation);
                this.terminalContextActivation = null;
            }
        }
    }

    protected class TerminalKeyHandler
    extends KeyAdapter {
        protected TerminalKeyHandler() {
        }

        public void keyPressed(KeyEvent event) {
            boolean altKeyPressed;
            if (VT100TerminalControl.this.getState() == TerminalState.CONNECTING) {
                return;
            }
            int accelerator = SWTKeySupport.convertEventToUnmodifiedAccelerator((KeyEvent)event);
            if (VT100TerminalControl.this.editActionAccelerators.isCopyAction(accelerator)) {
                VT100TerminalControl.this.copy();
                return;
            }
            if (VT100TerminalControl.this.editActionAccelerators.isPasteAction(accelerator)) {
                VT100TerminalControl.this.paste();
                return;
            }
            event.doit = false;
            char character = event.character;
            int modifierKeys = event.stateMask & SWT.MODIFIER_MASK;
            boolean ctrlKeyPressed = (event.stateMask & 0x40000) != 0;
            boolean onlyCtrlKeyPressed = modifierKeys == 262144;
            boolean macCmdKeyPressed = (event.stateMask & 0x400000) != 0;
            boolean bl = altKeyPressed = (event.stateMask & 0x10000) != 0 && !ctrlKeyPressed;
            if (VT100TerminalControl.this.fState == TerminalState.CLOSED) {
                if (character == '\r' && VT100TerminalControl.this.isConnectOnEnterIfClosed()) {
                    VT100TerminalControl.this.connectTerminal();
                    return;
                }
                event.doit = true;
                return;
            }
            if (event.keyCode == 127) {
                VT100TerminalControl.this.sendString("\u001b[3~");
                return;
            }
            if (macCmdKeyPressed || character == '\u0000' && event.keyCode != 50) {
                String escSeq = null;
                boolean anyModifierPressed = modifierKeys != 0;
                boolean onlyMacCmdKeyPressed = modifierKeys == 0x400000;
                switch (event.keyCode) {
                    case 0x1000001: {
                        if (anyModifierPressed) break;
                        escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOA" : "\u001b[A";
                        break;
                    }
                    case 0x1000002: {
                        if (anyModifierPressed) break;
                        escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOB" : "\u001b[B";
                        break;
                    }
                    case 0x1000003: {
                        if (onlyCtrlKeyPressed) {
                            escSeq = "\u001b[1;5D";
                            break;
                        }
                        if (!anyModifierPressed) {
                            escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOD" : "\u001b[D";
                            break;
                        }
                        if (!onlyMacCmdKeyPressed) break;
                        escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOH" : "\u001b[H";
                        break;
                    }
                    case 0x1000004: {
                        if (onlyCtrlKeyPressed) {
                            escSeq = "\u001b[1;5C";
                            break;
                        }
                        if (!anyModifierPressed) {
                            escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOC" : "\u001b[C";
                            break;
                        }
                        if (!onlyMacCmdKeyPressed) break;
                        escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOF" : "\u001b[F";
                        break;
                    }
                    case 0x1000005: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[5~";
                        break;
                    }
                    case 0x1000006: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[6~";
                        break;
                    }
                    case 0x1000007: {
                        if (anyModifierPressed) break;
                        escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOH" : "\u001b[H";
                        break;
                    }
                    case 0x1000008: {
                        if (anyModifierPressed) break;
                        escSeq = VT100TerminalControl.this.fApplicationCursorKeys ? "\u001bOF" : "\u001b[F";
                        break;
                    }
                    case 0x1000009: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[2~";
                        break;
                    }
                    case 0x100000A: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001bOP";
                        break;
                    }
                    case 0x100000B: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001bOQ";
                        break;
                    }
                    case 0x100000C: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001bOR";
                        break;
                    }
                    case 0x100000D: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001bOS";
                        break;
                    }
                    case 0x100000E: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[15~";
                        break;
                    }
                    case 0x100000F: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[17~";
                        break;
                    }
                    case 0x1000010: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[18~";
                        break;
                    }
                    case 0x1000011: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[19~";
                        break;
                    }
                    case 0x1000012: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[20~";
                        break;
                    }
                    case 0x1000013: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[21~";
                        break;
                    }
                    case 0x1000014: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[23~";
                        break;
                    }
                    case 0x1000015: {
                        if (anyModifierPressed) break;
                        escSeq = "\u001b[24~";
                        break;
                    }
                }
                if (escSeq == null) {
                    event.doit = true;
                    this.processKeyBinding(event, accelerator);
                } else {
                    VT100TerminalControl.this.sendString(escSeq);
                }
                return;
            }
            Logger.log("stateMask = " + event.stateMask);
            if (onlyCtrlKeyPressed) {
                switch (character) {
                    case ' ': {
                        character = '\u0000';
                        break;
                    }
                    case '/': {
                        character = '\u001f';
                    }
                }
            }
            VT100TerminalControl.this.sendChar(character, altKeyPressed);
            if (character == '\r' && VT100TerminalControl.this.getTerminalConnector() != null && VT100TerminalControl.this.isConnected() && VT100TerminalControl.this.getTerminalConnector().isLocalEcho()) {
                VT100TerminalControl.this.sendChar('\n', false);
            }
            if (VT100TerminalControl.this.getTerminalConnector() == null || !VT100TerminalControl.this.getTerminalConnector().isLocalEcho() || altKeyPressed || character >= '\u0001' && character < '\t' || character > '\t' && character < '\r' || character > '\r' && character <= '\u001f' || character == '\u007f') {
                return;
            }
            StringBuffer charBuffer = new StringBuffer();
            charBuffer.append(character);
            if (character == '\r') {
                charBuffer.append('\n');
            }
            VT100TerminalControl.this.writeToTerminal(charBuffer.toString());
        }

        private void processKeyBinding(KeyEvent event, int accelerator) {
            ParameterizedCommand cmd;
            KeyStroke keyStroke;
            IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getAdapter(IBindingService.class);
            Binding binding = bindingService.getPerfectMatch((TriggerSequence)KeySequence.getInstance((KeyStroke)(keyStroke = SWTKeySupport.convertAcceleratorToKeyStroke((int)accelerator))));
            if (binding != null && (cmd = binding.getParameterizedCommand()) != null) {
                IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getAdapter(IHandlerService.class);
                Event cmdEvent = new Event();
                cmdEvent.type = 1;
                cmdEvent.display = event.display;
                cmdEvent.widget = event.widget;
                cmdEvent.character = event.character;
                cmdEvent.keyCode = event.keyCode;
                try {
                    Field f1 = event.getClass().getField("keyLocation");
                    Field f2 = cmdEvent.getClass().getField("keyLocation");
                    f2.set(cmdEvent, f1.get(event));
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                cmdEvent.stateMask = event.stateMask;
                event.doit = false;
                try {
                    handlerService.executeCommand(cmd, cmdEvent);
                }
                catch (ExecutionException e) {
                    TerminalPlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.tm.terminal.control", e.getLocalizedMessage(), (Throwable)e));
                }
                catch (Exception exception) {}
            }
        }
    }
}

