/**
 * Copyright (c) 2021, 2024 Contributors to the Eclipse Foundation
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 */

/*
 * generated by Xtext 2.22.0
 */
package org.eclipse.trace4cps.tl.ide.contentassist.antlr;

import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.trace4cps.tl.ide.contentassist.antlr.internal.InternalEtlParser;
import org.eclipse.trace4cps.tl.services.EtlGrammarAccess;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.AbstractContentAssistParser;

public class EtlParser extends AbstractContentAssistParser {

	@Singleton
	public static final class NameMappings {
		
		private final Map<AbstractElement, String> mappings;
		
		@Inject
		public NameMappings(EtlGrammarAccess grammarAccess) {
			ImmutableMap.Builder<AbstractElement, String> builder = ImmutableMap.builder();
			init(builder, grammarAccess);
			this.mappings = builder.build();
		}
		
		public String getRuleName(AbstractElement element) {
			return mappings.get(element);
		}
		
		private static void init(ImmutableMap.Builder<AbstractElement, String> builder, EtlGrammarAccess grammarAccess) {
			builder.put(grammarAccess.getTopLevelModelElementAccess().getAlternatives(), "rule__TopLevelModelElement__Alternatives");
			builder.put(grammarAccess.getSignalAccess().getAlternatives(), "rule__Signal__Alternatives");
			builder.put(grammarAccess.getSignalAccess().getAlternatives_1_3(), "rule__Signal__Alternatives_1_3");
			builder.put(grammarAccess.getFormulaAccess().getAlternatives(), "rule__Formula__Alternatives");
			builder.put(grammarAccess.getStlApAccess().getAlternatives_0(), "rule__StlAp__Alternatives_0");
			builder.put(grammarAccess.getMtlApAccess().getAlternatives_0(), "rule__MtlAp__Alternatives_0");
			builder.put(grammarAccess.getIdStringAccess().getAlternatives(), "rule__IdString__Alternatives");
			builder.put(grammarAccess.getIntervalAccess().getAlternatives_0(), "rule__Interval__Alternatives_0");
			builder.put(grammarAccess.getIntervalSSAccess().getAlternatives_3(), "rule__IntervalSS__Alternatives_3");
			builder.put(grammarAccess.getIntervalNSAccess().getAlternatives_3(), "rule__IntervalNS__Alternatives_3");
			builder.put(grammarAccess.getTimeUnitEnumAccess().getAlternatives(), "rule__TimeUnitEnum__Alternatives");
			builder.put(grammarAccess.getAndOrAccess().getAlternatives(), "rule__AndOr__Alternatives");
			builder.put(grammarAccess.getCompOpAccess().getAlternatives(), "rule__CompOp__Alternatives");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getGroup_0(), "rule__TopLevelModelElement__Group_0__0");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getGroup_1(), "rule__TopLevelModelElement__Group_1__0");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getGroup_1_3(), "rule__TopLevelModelElement__Group_1_3__0");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getGroup_2(), "rule__TopLevelModelElement__Group_2__0");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getGroup_2_4(), "rule__TopLevelModelElement__Group_2_4__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_0(), "rule__Signal__Group_0__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_1(), "rule__Signal__Group_1__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_1_4(), "rule__Signal__Group_1_4__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_2(), "rule__Signal__Group_2__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_2_4(), "rule__Signal__Group_2_4__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_3(), "rule__Signal__Group_3__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_4(), "rule__Signal__Group_4__0");
			builder.put(grammarAccess.getSignalAccess().getGroup_5(), "rule__Signal__Group_5__0");
			builder.put(grammarAccess.getConvSpecAccess().getGroup(), "rule__ConvSpec__Group__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_0(), "rule__Formula__Group_0__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_0_2(), "rule__Formula__Group_0_2__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_0_2_2(), "rule__Formula__Group_0_2_2__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_1(), "rule__Formula__Group_1__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_2(), "rule__Formula__Group_2__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_3(), "rule__Formula__Group_3__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_4(), "rule__Formula__Group_4__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_5(), "rule__Formula__Group_5__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_6(), "rule__Formula__Group_6__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_7(), "rule__Formula__Group_7__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_8(), "rule__Formula__Group_8__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_9(), "rule__Formula__Group_9__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_10(), "rule__Formula__Group_10__0");
			builder.put(grammarAccess.getFormulaAccess().getGroup_11(), "rule__Formula__Group_11__0");
			builder.put(grammarAccess.getStlApAccess().getGroup(), "rule__StlAp__Group__0");
			builder.put(grammarAccess.getStlApAccess().getGroup_0_1(), "rule__StlAp__Group_0_1__0");
			builder.put(grammarAccess.getMtlApAccess().getGroup(), "rule__MtlAp__Group__0");
			builder.put(grammarAccess.getMtlApAccess().getGroup_0_0(), "rule__MtlAp__Group_0_0__0");
			builder.put(grammarAccess.getMtlApAccess().getGroup_0_1(), "rule__MtlAp__Group_0_1__0");
			builder.put(grammarAccess.getAttributeFilterAccess().getGroup(), "rule__AttributeFilter__Group__0");
			builder.put(grammarAccess.getAttributeFilterAccess().getGroup_2(), "rule__AttributeFilter__Group_2__0");
			builder.put(grammarAccess.getKeyValAccess().getGroup(), "rule__KeyVal__Group__0");
			builder.put(grammarAccess.getIdStringAccess().getGroup_2(), "rule__IdString__Group_2__0");
			builder.put(grammarAccess.getIdStringAccess().getGroup_3(), "rule__IdString__Group_3__0");
			builder.put(grammarAccess.getIdStringAccess().getGroup_4(), "rule__IdString__Group_4__0");
			builder.put(grammarAccess.getIntervalAccess().getGroup(), "rule__Interval__Group__0");
			builder.put(grammarAccess.getIntervalSSAccess().getGroup(), "rule__IntervalSS__Group__0");
			builder.put(grammarAccess.getIntervalSNAccess().getGroup(), "rule__IntervalSN__Group__0");
			builder.put(grammarAccess.getIntervalNSAccess().getGroup(), "rule__IntervalNS__Group__0");
			builder.put(grammarAccess.getIntervalNNAccess().getGroup(), "rule__IntervalNN__Group__0");
			builder.put(grammarAccess.getEtlModelAccess().getElementsAssignment(), "rule__EtlModel__ElementsAssignment");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_0_2(), "rule__TopLevelModelElement__NameAssignment_0_2");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getSignalAssignment_0_4(), "rule__TopLevelModelElement__SignalAssignment_0_4");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_1_2(), "rule__TopLevelModelElement__NameAssignment_1_2");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getParamAssignment_1_3_1(), "rule__TopLevelModelElement__ParamAssignment_1_3_1");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getFormulaAssignment_1_5(), "rule__TopLevelModelElement__FormulaAssignment_1_5");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getNameAssignment_2_2(), "rule__TopLevelModelElement__NameAssignment_2_2");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getVarAssignment_2_4_2(), "rule__TopLevelModelElement__VarAssignment_2_4_2");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getLbAssignment_2_4_4(), "rule__TopLevelModelElement__LbAssignment_2_4_4");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getUbAssignment_2_4_6(), "rule__TopLevelModelElement__UbAssignment_2_4_6");
			builder.put(grammarAccess.getTopLevelModelElementAccess().getFormulaAssignment_2_5(), "rule__TopLevelModelElement__FormulaAssignment_2_5");
			builder.put(grammarAccess.getSignalAccess().getFilterAssignment_0_1(), "rule__Signal__FilterAssignment_0_1");
			builder.put(grammarAccess.getSignalAccess().getIdAttAssignment_1_3_0(), "rule__Signal__IdAttAssignment_1_3_0");
			builder.put(grammarAccess.getSignalAccess().getApAssignment_1_3_1(), "rule__Signal__ApAssignment_1_3_1");
			builder.put(grammarAccess.getSignalAccess().getScaleAssignment_1_4_1(), "rule__Signal__ScaleAssignment_1_4_1");
			builder.put(grammarAccess.getSignalAccess().getConvSpecAssignment_1_5(), "rule__Signal__ConvSpecAssignment_1_5");
			builder.put(grammarAccess.getSignalAccess().getIdAttAssignment_2_3(), "rule__Signal__IdAttAssignment_2_3");
			builder.put(grammarAccess.getSignalAccess().getScaleAssignment_2_4_1(), "rule__Signal__ScaleAssignment_2_4_1");
			builder.put(grammarAccess.getSignalAccess().getConvSpecAssignment_2_5(), "rule__Signal__ConvSpecAssignment_2_5");
			builder.put(grammarAccess.getSignalAccess().getIdAttAssignment_3_3(), "rule__Signal__IdAttAssignment_3_3");
			builder.put(grammarAccess.getSignalAccess().getConvSpecAssignment_3_4(), "rule__Signal__ConvSpecAssignment_3_4");
			builder.put(grammarAccess.getSignalAccess().getFilterAssignment_4_2(), "rule__Signal__FilterAssignment_4_2");
			builder.put(grammarAccess.getSignalAccess().getConvSpecAssignment_4_3(), "rule__Signal__ConvSpecAssignment_4_3");
			builder.put(grammarAccess.getSignalAccess().getFilterAssignment_5_2(), "rule__Signal__FilterAssignment_5_2");
			builder.put(grammarAccess.getSignalAccess().getConvSpecAssignment_5_3(), "rule__Signal__ConvSpecAssignment_5_3");
			builder.put(grammarAccess.getConvSpecAccess().getWindowWidthAssignment_1(), "rule__ConvSpec__WindowWidthAssignment_1");
			builder.put(grammarAccess.getConvSpecAccess().getWindowUnitAssignment_2(), "rule__ConvSpec__WindowUnitAssignment_2");
			builder.put(grammarAccess.getFormulaAccess().getDefAssignment_0_1(), "rule__Formula__DefAssignment_0_1");
			builder.put(grammarAccess.getFormulaAccess().getParamAssignment_0_2_1(), "rule__Formula__ParamAssignment_0_2_1");
			builder.put(grammarAccess.getFormulaAccess().getValAssignment_0_2_2_1(), "rule__Formula__ValAssignment_0_2_2_1");
			builder.put(grammarAccess.getFormulaAccess().getMtlAPAssignment_1_1(), "rule__Formula__MtlAPAssignment_1_1");
			builder.put(grammarAccess.getFormulaAccess().getStlAPAssignment_2_1(), "rule__Formula__StlAPAssignment_2_1");
			builder.put(grammarAccess.getFormulaAccess().getFormulaAssignment_3_2(), "rule__Formula__FormulaAssignment_3_2");
			builder.put(grammarAccess.getFormulaAccess().getLeftAssignment_4_2(), "rule__Formula__LeftAssignment_4_2");
			builder.put(grammarAccess.getFormulaAccess().getOpAssignment_4_3(), "rule__Formula__OpAssignment_4_3");
			builder.put(grammarAccess.getFormulaAccess().getRightAssignment_4_4(), "rule__Formula__RightAssignment_4_4");
			builder.put(grammarAccess.getFormulaAccess().getLeftAssignment_5_2(), "rule__Formula__LeftAssignment_5_2");
			builder.put(grammarAccess.getFormulaAccess().getRightAssignment_5_4(), "rule__Formula__RightAssignment_5_4");
			builder.put(grammarAccess.getFormulaAccess().getFormulaAssignment_6_2(), "rule__Formula__FormulaAssignment_6_2");
			builder.put(grammarAccess.getFormulaAccess().getIntervalAssignment_7_2(), "rule__Formula__IntervalAssignment_7_2");
			builder.put(grammarAccess.getFormulaAccess().getFormulaAssignment_7_3(), "rule__Formula__FormulaAssignment_7_3");
			builder.put(grammarAccess.getFormulaAccess().getFormulaAssignment_8_2(), "rule__Formula__FormulaAssignment_8_2");
			builder.put(grammarAccess.getFormulaAccess().getIntervalAssignment_9_2(), "rule__Formula__IntervalAssignment_9_2");
			builder.put(grammarAccess.getFormulaAccess().getFormulaAssignment_9_3(), "rule__Formula__FormulaAssignment_9_3");
			builder.put(grammarAccess.getFormulaAccess().getRightAssignment_10_2(), "rule__Formula__RightAssignment_10_2");
			builder.put(grammarAccess.getFormulaAccess().getLeftAssignment_10_6(), "rule__Formula__LeftAssignment_10_6");
			builder.put(grammarAccess.getFormulaAccess().getIntervalAssignment_11_2(), "rule__Formula__IntervalAssignment_11_2");
			builder.put(grammarAccess.getFormulaAccess().getRightAssignment_11_3(), "rule__Formula__RightAssignment_11_3");
			builder.put(grammarAccess.getFormulaAccess().getLeftAssignment_11_7(), "rule__Formula__LeftAssignment_11_7");
			builder.put(grammarAccess.getStlApAccess().getRefAssignment_0_0(), "rule__StlAp__RefAssignment_0_0");
			builder.put(grammarAccess.getStlApAccess().getRefAssignment_0_1_2(), "rule__StlAp__RefAssignment_0_1_2");
			builder.put(grammarAccess.getStlApAccess().getCompOpAssignment_1(), "rule__StlAp__CompOpAssignment_1");
			builder.put(grammarAccess.getStlApAccess().getValAssignment_2(), "rule__StlAp__ValAssignment_2");
			builder.put(grammarAccess.getMtlApAccess().getFilterAssignment_1(), "rule__MtlAp__FilterAssignment_1");
			builder.put(grammarAccess.getAttributeFilterAccess().getKeyValsAssignment_1(), "rule__AttributeFilter__KeyValsAssignment_1");
			builder.put(grammarAccess.getAttributeFilterAccess().getKeyValsAssignment_2_1(), "rule__AttributeFilter__KeyValsAssignment_2_1");
			builder.put(grammarAccess.getKeyValAccess().getAttAssignment_0(), "rule__KeyVal__AttAssignment_0");
			builder.put(grammarAccess.getKeyValAccess().getValAssignment_2(), "rule__KeyVal__ValAssignment_2");
			builder.put(grammarAccess.getIdStringAccess().getLeftAssignment_0(), "rule__IdString__LeftAssignment_0");
			builder.put(grammarAccess.getIdStringAccess().getIdAssignment_1(), "rule__IdString__IdAssignment_1");
			builder.put(grammarAccess.getIdStringAccess().getLeftAssignment_2_0(), "rule__IdString__LeftAssignment_2_0");
			builder.put(grammarAccess.getIdStringAccess().getIdAssignment_2_2(), "rule__IdString__IdAssignment_2_2");
			builder.put(grammarAccess.getIdStringAccess().getIdAssignment_3_0(), "rule__IdString__IdAssignment_3_0");
			builder.put(grammarAccess.getIdStringAccess().getRightAssignment_3_2(), "rule__IdString__RightAssignment_3_2");
			builder.put(grammarAccess.getIdStringAccess().getLeftAssignment_4_0(), "rule__IdString__LeftAssignment_4_0");
			builder.put(grammarAccess.getIdStringAccess().getIdAssignment_4_2(), "rule__IdString__IdAssignment_4_2");
			builder.put(grammarAccess.getIdStringAccess().getRightAssignment_4_4(), "rule__IdString__RightAssignment_4_4");
			builder.put(grammarAccess.getIntervalAccess().getIssAssignment_0_0(), "rule__Interval__IssAssignment_0_0");
			builder.put(grammarAccess.getIntervalAccess().getIsnAssignment_0_1(), "rule__Interval__IsnAssignment_0_1");
			builder.put(grammarAccess.getIntervalAccess().getInsAssignment_0_2(), "rule__Interval__InsAssignment_0_2");
			builder.put(grammarAccess.getIntervalAccess().getInnAssignment_0_3(), "rule__Interval__InnAssignment_0_3");
			builder.put(grammarAccess.getIntervalAccess().getTimeUnitAssignment_1(), "rule__Interval__TimeUnitAssignment_1");
			builder.put(grammarAccess.getIntervalSSAccess().getLbAssignment_1(), "rule__IntervalSS__LbAssignment_1");
			builder.put(grammarAccess.getIntervalSSAccess().getUbAssignment_3_0(), "rule__IntervalSS__UbAssignment_3_0");
			builder.put(grammarAccess.getIntervalSSAccess().getInftyAssignment_3_1(), "rule__IntervalSS__InftyAssignment_3_1");
			builder.put(grammarAccess.getIntervalSNAccess().getLbAssignment_1(), "rule__IntervalSN__LbAssignment_1");
			builder.put(grammarAccess.getIntervalSNAccess().getUbAssignment_3(), "rule__IntervalSN__UbAssignment_3");
			builder.put(grammarAccess.getIntervalNSAccess().getLbAssignment_1(), "rule__IntervalNS__LbAssignment_1");
			builder.put(grammarAccess.getIntervalNSAccess().getUbAssignment_3_0(), "rule__IntervalNS__UbAssignment_3_0");
			builder.put(grammarAccess.getIntervalNSAccess().getInftyAssignment_3_1(), "rule__IntervalNS__InftyAssignment_3_1");
			builder.put(grammarAccess.getIntervalNNAccess().getLbAssignment_1(), "rule__IntervalNN__LbAssignment_1");
			builder.put(grammarAccess.getIntervalNNAccess().getUbAssignment_3(), "rule__IntervalNN__UbAssignment_3");
		}
	}
	
	@Inject
	private NameMappings nameMappings;

	@Inject
	private EtlGrammarAccess grammarAccess;

	@Override
	protected InternalEtlParser createParser() {
		InternalEtlParser result = new InternalEtlParser(null);
		result.setGrammarAccess(grammarAccess);
		return result;
	}

	@Override
	protected String getRuleName(AbstractElement element) {
		return nameMappings.getRuleName(element);
	}

	@Override
	protected String[] getInitialHiddenTokens() {
		return new String[] { "RULE_WS", "RULE_ML_COMMENT", "RULE_SL_COMMENT" };
	}

	public EtlGrammarAccess getGrammarAccess() {
		return this.grammarAccess;
	}

	public void setGrammarAccess(EtlGrammarAccess grammarAccess) {
		this.grammarAccess = grammarAccess;
	}
	
	public NameMappings getNameMappings() {
		return nameMappings;
	}
	
	public void setNameMappings(NameMappings nameMappings) {
		this.nameMappings = nameMappings;
	}
}
