/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.trace4cps.ui.dialog;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.trace4cps.core.TraceException;
import org.eclipse.trace4cps.core.TracePart;
import org.eclipse.trace4cps.ui.dialog.AbstractListSelectionWizardPage;
import org.eclipse.trace4cps.ui.view.TraceView;

public class DependencyAnalysisWizard
extends Wizard {
    private final TraceView traceView;
    private ModelTraceSelectionPage page1;
    private WeightAttributeSelectionPage page2;
    private int modelTraceIdx;
    private int systemTraceIdx;
    private String weightAttribute;

    public DependencyAnalysisWizard(TraceView view) {
        this.traceView = view;
        this.setWindowTitle("Dependency analysis settings");
        this.setNeedsProgressMonitor(false);
        TrayDialog.setDialogHelpAvailable((boolean)false);
    }

    public void addPages() {
        this.page1 = new ModelTraceSelectionPage(this);
        this.addPage((IWizardPage)this.page1);
        this.page2 = new WeightAttributeSelectionPage(this, this.traceView.getAttributeNames(TracePart.DEPENDENCY));
        this.addPage((IWizardPage)this.page2);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page instanceof ModelTraceSelectionPage) {
            List<String> modelTrace = this.page1.getSelection();
            if (modelTrace.isEmpty()) {
                return null;
            }
            return this.page2;
        }
        return null;
    }

    public boolean performFinish() {
        this.modelTraceIdx = this.page1.getModelTraceIdx();
        this.systemTraceIdx = this.page1.getSystemTraceIdx();
        this.weightAttribute = this.page2.getWeightAttribute();
        return true;
    }

    public int getModelTraceIdx() throws TraceException {
        if (this.modelTraceIdx < 0) {
            throw new TraceException("No model trace specified");
        }
        return this.modelTraceIdx;
    }

    public int getSystemTraceIdx() throws TraceException {
        if (this.systemTraceIdx < 0) {
            throw new TraceException("No system trace found");
        }
        return this.systemTraceIdx;
    }

    public String getWeightAttribute() {
        return this.weightAttribute;
    }

    private static final class ModelTraceSelectionPage
    extends AbstractListSelectionWizardPage {
        private final Map<String, Integer> fileNameToIndex = new HashMap<String, Integer>();
        private final List<String> fileNames = new ArrayList<String>();

        public ModelTraceSelectionPage(DependencyAnalysisWizard wizard) {
            super("ModelTraceSelectionPage", wizard, AbstractListSelectionWizardPage.SelectionMode.EXACTLY_ONE);
            int i = 0;
            while (i < wizard.traceView.getNumTraces()) {
                File file = wizard.traceView.getTraceFile(i);
                this.fileNames.add(file.getName());
                this.fileNameToIndex.put(file.getName(), i);
                ++i;
            }
            Collections.sort(this.fileNames);
        }

        @Override
        protected String getPageTitle() {
            return "Model trace";
        }

        @Override
        protected String getPageMessage() {
            return "Select the model trace (exactly one)";
        }

        @Override
        protected Collection<String> getInput() {
            return this.fileNames;
        }

        public int getModelTraceIdx() {
            List<String> selection = this.getSelection();
            if (selection == null || selection.isEmpty()) {
                return -1;
            }
            return this.fileNameToIndex.get(selection.get(0));
        }

        public int getSystemTraceIdx() {
            List<String> selection = this.getSelection();
            if (selection == null || selection.isEmpty()) {
                return -1;
            }
            String modelTraceName = selection.get(0);
            for (Map.Entry<String, Integer> e : this.fileNameToIndex.entrySet()) {
                if (modelTraceName.equals(e.getKey())) continue;
                return e.getValue();
            }
            return -1;
        }
    }

    private static final class WeightAttributeSelectionPage
    extends AbstractListSelectionWizardPage {
        private final List<String> depAttributes = new ArrayList<String>();

        public WeightAttributeSelectionPage(DependencyAnalysisWizard wizard, Set<String> attributeNames) {
            super("WeightAttributeSelectionPage", wizard, AbstractListSelectionWizardPage.SelectionMode.ALWAYS);
            this.depAttributes.addAll(attributeNames);
            Collections.sort(this.depAttributes);
        }

        @Override
        protected String getPageTitle() {
            return "Weight attribute";
        }

        @Override
        protected String getPageMessage() {
            return "Select the attribute to interpret as a minimal distance for the dependencies";
        }

        @Override
        protected Collection<String> getInput() {
            return this.depAttributes;
        }

        public String getWeightAttribute() {
            List<String> selection = this.getSelection();
            if (selection == null || selection.isEmpty()) {
                return null;
            }
            return selection.get(0);
        }
    }
}

