/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.trace;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.regex.Matcher;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelTrace;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceAspects;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.IGenericFtraceConstants;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.layout.GenericFtraceEventLayout;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfTraceException;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfContext;
import org.eclipse.tracecompass.tmf.core.trace.TmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.location.ITmfLocation;
import org.eclipse.tracecompass.tmf.core.trace.location.TmfLongLocation;

public abstract class GenericFtrace
extends TmfTrace
implements IKernelTrace {
    protected static final byte[] TRACE_CMD_DAT_MAGIC = new byte[]{23, 8, 68, 116, 114, 97, 99, 105, 110, 103};
    private static final int ESTIMATED_EVENT_SIZE = 90;
    private static final TmfLongLocation NULL_LOCATION = new TmfLongLocation(-1L);
    private static final TmfContext INVALID_CONTEXT = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
    private File fFile;
    private RandomAccessFile fFileInput;

    protected @Nullable GenericFtraceField parseLine(String line) {
        if (line != null) {
            return GenericFtraceField.parseLine(line);
        }
        return null;
    }

    public void initTrace(IResource resource, String path, Class<? extends ITmfEvent> type) throws TmfTraceException {
        super.initTrace(resource, path, type);
        try {
            this.fFile = new File(path);
            this.fFileInput = new BufferedRandomAccessFile(this.fFile, "r");
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }

    public synchronized void dispose() {
        this.setFileInput(null);
        super.dispose();
    }

    public double getLocationRatio(ITmfLocation location) {
        return ((Long)this.getCurrentLocation().getLocationInfo()).doubleValue() / (double)this.getFile().length();
    }

    public ITmfContext seekEvent(ITmfLocation location) {
        if (this.getFile() == null) {
            return INVALID_CONTEXT;
        }
        TmfContext context = new TmfContext((ITmfLocation)NULL_LOCATION, -1L);
        if (NULL_LOCATION.equals((Object)location)) {
            return context;
        }
        try {
            RandomAccessFile fileInput = this.getFileInput();
            return this.seek(fileInput, location, context);
        }
        catch (FileNotFoundException e) {
            Activator.getInstance().logError("Error seeking event. File not found: " + this.getPath(), (Throwable)e);
            return context;
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error seeking event. File: " + this.getPath(), (Throwable)e);
            return context;
        }
    }

    protected ITmfContext seek(RandomAccessFile fileInput, ITmfLocation location, TmfContext context) throws IOException {
        if (location == null) {
            fileInput.seek(0L);
            long lineStartOffset = fileInput.getFilePointer();
            String line = fileInput.readLine();
            if (line == null) {
                return context;
            }
            Matcher matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
            while (!matcher.matches()) {
                lineStartOffset = fileInput.getFilePointer();
                line = fileInput.readLine();
                if (line == null) break;
                matcher = IGenericFtraceConstants.FTRACE_PATTERN.matcher(line);
            }
            fileInput.seek(lineStartOffset);
        } else if (location.getLocationInfo() instanceof Long) {
            fileInput.seek((Long)location.getLocationInfo());
        }
        context.setLocation((ITmfLocation)new TmfLongLocation(fileInput.getFilePointer()));
        context.setRank(0L);
        return context;
    }

    public ITmfEvent parseEvent(ITmfContext context) {
        ITmfLocation location = context.getLocation();
        long rank = context.getRank();
        if (location instanceof TmfLongLocation) {
            TmfLongLocation tmfLongLocation = (TmfLongLocation)location;
            return this.parseEvent(this.getFileInput(), tmfLongLocation, rank);
        }
        return null;
    }

    protected ITmfEvent parseEvent(RandomAccessFile fileInput, TmfLongLocation tmfLongLocation, long rank) {
        Long locationInfo = tmfLongLocation.getLocationInfo();
        if (tmfLongLocation.equals((Object)NULL_LOCATION)) {
            locationInfo = 0L;
        }
        if (locationInfo != null) {
            try {
                String nextLine;
                if (!locationInfo.equals(fileInput.getFilePointer())) {
                    fileInput.seek(locationInfo);
                }
                while ((nextLine = fileInput.readLine()) != null && nextLine.startsWith("#")) {
                }
                GenericFtraceField field = this.parseLine(nextLine);
                if (field != null) {
                    return new GenericFtraceEvent((ITmfTrace)this, rank, field);
                }
            }
            catch (IOException e) {
                Activator.getInstance().logError("Error parsing event", (Throwable)e);
            }
        }
        return null;
    }

    public ITmfLocation getCurrentLocation() {
        long temp = -1L;
        try {
            temp = this.getFileInput().getFilePointer();
        }
        catch (IOException e) {
            Activator.getInstance().logError(e.getMessage(), (Throwable)e);
        }
        return new TmfLongLocation(temp);
    }

    public ITmfContext seekEvent(double ratio) {
        File file = this.getFile();
        if (file == null) {
            return INVALID_CONTEXT;
        }
        long filePos = (long)((double)file.length() * ratio);
        long estimatedRank = filePos / 90L;
        return this.seekEvent((ITmfLocation)new TmfLongLocation(estimatedRank));
    }

    public Iterable<ITmfEventAspect<?>> getEventAspects() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.addAll(GenericFtraceAspects.getAspects());
        return builder.build();
    }

    public IKernelAnalysisEventLayout getKernelEventLayout() {
        return GenericFtraceEventLayout.getInstance();
    }

    protected RandomAccessFile getFileInput() {
        return this.fFileInput;
    }

    private void setFileInput(RandomAccessFile newFileInput) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                RandomAccessFile fileInput = this.getFileInput();
                if (fileInput != null) {
                    fileInput.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getInstance().logError("Error disposing trace. File: " + this.getPath(), (Throwable)e);
        }
        this.fFileInput = newFileInput;
    }

    protected File getFile() {
        return this.fFile;
    }

    protected void setFile(File file) throws TmfTraceException {
        this.fFile = file;
        try {
            this.setFileInput((RandomAccessFile)new BufferedRandomAccessFile(file, "r"));
        }
        catch (IOException e) {
            throw new TmfTraceException(e.getMessage(), (Throwable)e);
        }
    }
}

