/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.qemukvm;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelAnalysisModule;
import org.eclipse.tracecompass.analysis.os.linux.core.kernel.KernelThreadInformationProvider;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualMachineModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.TmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperimentUtils;

public class QemuKvmVmModel
implements IVirtualMachineModel {
    private static final String KVM = "kvm_";
    private static final Map<TmfExperiment, QemuKvmVmModel> MODELS = new HashMap<TmfExperiment, QemuKvmVmModel>();
    private final Map<HostThread, VirtualCPU> fTidToVcpu = new HashMap<HostThread, VirtualCPU>();
    private final Map<HostThread, VirtualMachine> fTidToVm = new HashMap<HostThread, VirtualMachine>();
    private final Map<String, VirtualMachine> fKnownMachines = new HashMap<String, VirtualMachine>();
    private final Table<VirtualMachine, VirtualCPU, Long> fVirtualToPhysicalCpu = (Table)NonNullUtils.checkNotNull((Object)HashBasedTable.create());
    private final TmfExperiment fExperiment;
    private Map<IKernelAnalysisEventLayout, Set<String>> fRequiredEvents = new HashMap<IKernelAnalysisEventLayout, Set<String>>();
    private static final ImmutableSet<String> VMSYNC_EVENTS = ImmutableSet.of((Object)"vmsync_gh_guest", (Object)"vmsync_gh_host", (Object)"vmsync_hg_guest", (Object)"vmsync_hg_host");

    public static synchronized QemuKvmVmModel get(TmfExperiment exp) {
        QemuKvmVmModel model = MODELS.get(exp);
        if (model == null) {
            model = new QemuKvmVmModel(exp);
            MODELS.put(exp, model);
        }
        return model;
    }

    private QemuKvmVmModel(TmfExperiment exp) {
        this.fExperiment = exp;
        if (exp.getTraces().size() == 1) {
            ITmfTrace trace = (ITmfTrace)exp.getTraces().get(0);
            this.addKnownMachine(VirtualMachine.newHostMachine(trace.getHostId(), String.valueOf(trace.getName())));
        }
    }

    @Override
    public @Nullable VirtualMachine getCurrentMachine(ITmfEvent event) {
        TmfEventField field;
        ITmfEventField data;
        String hostId = event.getTrace().getHostId();
        VirtualMachine machine = this.fKnownMachines.get(hostId);
        String eventName = event.getName();
        if (eventName.startsWith(KVM)) {
            if (machine != null) {
                machine.setHost();
                return machine;
            }
            machine = VirtualMachine.newHostMachine(hostId, String.valueOf(event.getTrace().getName()));
        } else if ((eventName.equals("vmsync_gh_guest") || eventName.equals("vmsync_hg_guest")) && (data = (field = (TmfEventField)event.getContent()).getField(new String[]{"vm_uid"})) != null) {
            Long uid = (Long)data.getValue();
            if (machine != null) {
                machine.setGuest(uid);
                return machine;
            }
            machine = VirtualMachine.newGuestMachine(uid, hostId, String.valueOf(event.getTrace().getName()));
        }
        if (machine != null) {
            this.fKnownMachines.put(hostId, machine);
        }
        return machine;
    }

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        Set<String> events = this.fRequiredEvents.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.addAll(layout.eventsKVMEntry());
            events.addAll(layout.eventsKVMExit());
            events.addAll((Collection<String>)VMSYNC_EVENTS);
            this.fRequiredEvents.put(layout, events);
        }
        return events;
    }

    private @Nullable VirtualMachine findVmFromParent(ITmfEvent event, HostThread ht) {
        KernelAnalysisModule module = this.getLttngKernelModuleFor(ht.getHost());
        if (module == null) {
            return null;
        }
        Integer ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)ht.getTid(), (long)event.getTimestamp().getValue());
        if (ppid == null) {
            return null;
        }
        HostThread parentHt = new HostThread(ht.getHost(), ppid);
        VirtualMachine vm = this.fTidToVm.get(parentHt);
        if (vm == null) {
            return null;
        }
        this.fTidToVm.put(ht, vm);
        return vm;
    }

    @Override
    public @Nullable VirtualCPU getVCpuExitingHypervisorMode(ITmfEvent event, HostThread ht, IKernelAnalysisEventLayout layout) {
        String eventName = event.getName();
        if (!layout.eventsKVMEntry().contains(eventName)) {
            return null;
        }
        VirtualCPU vcpu = this.fTidToVcpu.get(ht);
        if (vcpu != null) {
            return vcpu;
        }
        VirtualMachine vm = this.fTidToVm.get(ht);
        if (vm == null && (vm = this.findVmFromParent(event, ht)) == null) {
            return null;
        }
        ITmfEventField content = event.getContent();
        long vcpu_id = (Long)content.getField(new String[]{"vcpu_id"}).getValue();
        VirtualCPU virtualCPU = VirtualCPU.getVirtualCPU(vm, vcpu_id);
        this.fTidToVcpu.put(ht, virtualCPU);
        return virtualCPU;
    }

    @Override
    public @Nullable VirtualCPU getVCpuEnteringHypervisorMode(ITmfEvent event, HostThread ht, IKernelAnalysisEventLayout layout) {
        String eventName = event.getName();
        if (!layout.eventsKVMExit().contains(eventName)) {
            return null;
        }
        return this.getVirtualCpu(ht);
    }

    @Override
    public @Nullable VirtualCPU getVirtualCpu(HostThread ht) {
        return this.fTidToVcpu.get(ht);
    }

    @Override
    public @Nullable HostThread getVirtualCpuTid(VirtualCPU vcpu) {
        for (Map.Entry<HostThread, VirtualCPU> entry : this.fTidToVcpu.entrySet()) {
            if (!entry.getValue().equals(vcpu)) continue;
            return entry.getKey();
        }
        return null;
    }

    @Override
    public void handleEvent(ITmfEvent event, IKernelAnalysisEventLayout layout) {
        String eventName = event.getName();
        VirtualMachine host = this.fKnownMachines.get(event.getTrace().getHostId());
        block5 : switch (eventName) {
            case "vmsync_gh_host": {
                ITmfEventField content = event.getContent();
                long ts = event.getTimestamp().toNanos();
                String hostId = event.getTrace().getHostId();
                Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                if (cpu == null) {
                    return;
                }
                IHostModel model = ModelManager.getModelFor((String)hostId);
                int tid = model.getThreadOnCpu(cpu.intValue(), ts, true);
                if (tid == -1) {
                    return;
                }
                HostThread ht = new HostThread(hostId, Integer.valueOf(tid));
                VirtualMachine vm = this.fTidToVm.get(ht);
                if (vm != null) {
                    return;
                }
                ITmfEventField data = content.getField(new String[]{"vm_uid"});
                if (data == null) {
                    return;
                }
                long vmUid = (Long)data.getValue();
                for (VirtualMachine machine : this.fKnownMachines.values()) {
                    if (machine.getVmUid() != vmUid) continue;
                    if (host != null) {
                        host.addChild(machine);
                    }
                    this.fTidToVm.put(ht, machine);
                    KernelAnalysisModule module = this.getLttngKernelModuleFor(hostId);
                    if (module == null) break block5;
                    Integer ppid = KernelThreadInformationProvider.getParentPid((KernelAnalysisModule)module, (Integer)tid, (long)ts);
                    if (ppid == null) continue;
                    HostThread parentHt = new HostThread(hostId, ppid);
                    this.fTidToVm.put(parentHt, machine);
                }
                break;
            }
            case "kvm_entry": 
            case "kvm_x86_entry": {
                Integer tid;
                String hostId = event.getTrace().getHostId();
                long ts = event.getTimestamp().getValue();
                Integer cpu = TmfTraceUtils.resolveIntEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
                if (cpu == null) {
                    return;
                }
                KernelAnalysisModule module = this.getLttngKernelModuleFor(hostId);
                if (module == null || (tid = KernelThreadInformationProvider.getThreadOnCpu((KernelAnalysisModule)module, (long)cpu.intValue(), (long)ts)) == null) break;
                HostThread ht = new HostThread(hostId, tid);
                VirtualCPU vcpu = this.getVCpuExitingHypervisorMode(event, ht, layout);
                VirtualMachine virtualMachine = this.fTidToVm.get(ht);
                if (virtualMachine == null || vcpu == null) {
                    return;
                }
                this.fVirtualToPhysicalCpu.put((Object)virtualMachine, (Object)vcpu, (Object)cpu.longValue());
            }
        }
    }

    private @Nullable KernelAnalysisModule getLttngKernelModuleFor(String hostId) {
        return (KernelAnalysisModule)TmfExperimentUtils.getAnalysisModuleOfClassForHost((TmfExperiment)this.fExperiment, (String)hostId, KernelAnalysisModule.class);
    }

    public @Nullable HostThread getHostThreadFromVm(VirtualMachine virtualMachine) {
        for (Map.Entry<HostThread, VirtualMachine> entry : this.fTidToVm.entrySet()) {
            if (virtualMachine.getVmUid() != Objects.requireNonNull(entry.getValue()).getVmUid()) continue;
            return entry.getKey();
        }
        return null;
    }

    public @Nullable HostThread getHostThreadFromVCpu(VirtualCPU virtualCPU) {
        for (Map.Entry<HostThread, VirtualCPU> entry : this.fTidToVcpu.entrySet()) {
            VirtualCPU vcpu = Objects.requireNonNull(entry.getValue());
            if (!vcpu.getVm().getHostId().equals(virtualCPU.getVm().getHostId()) || vcpu.getCpuId() != virtualCPU.getCpuId()) continue;
            return entry.getKey();
        }
        return null;
    }

    public @Nullable Long getPhysicalCpuFromVcpu(VirtualMachine virtualMachine, VirtualCPU vcpu) {
        Long pcpu = (Long)this.fVirtualToPhysicalCpu.get((Object)virtualMachine, (Object)vcpu);
        if (pcpu == null) {
            return null;
        }
        VirtualMachine parent = virtualMachine.getParent();
        if (parent != null && parent.isGuest()) {
            pcpu = (Long)this.fVirtualToPhysicalCpu.get((Object)parent, (Object)VirtualCPU.getVirtualCPU(parent, pcpu));
        }
        return pcpu;
    }

    public @Nullable VirtualMachine getVmFromHostThread(HostThread ht) {
        return this.fTidToVm.get(ht);
    }

    public void addKnownMachine(VirtualMachine v) {
        this.fKnownMachines.put(v.getHostId(), v);
    }

    public int numberOfKnownMachines() {
        return this.fKnownMachines.size();
    }

    public Map<String, VirtualMachine> getKnownMachines() {
        return this.fKnownMachines;
    }
}

