/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.handlers;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.model.HostThread;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.incubator.analysis.core.model.IHostModel;
import org.eclipse.tracecompass.incubator.analysis.core.model.ModelManager;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.IVirtualMachineEventHandler;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.IVirtualEnvironmentModel;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualCPU;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.model.VirtualMachine;
import org.eclipse.tracecompass.incubator.internal.virtual.machine.analysis.core.overhead.VmOverheadStateProvider;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfCpuAspect;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class SchedSwitchEventHandler
implements IVirtualMachineEventHandler {
    private Map<IKernelAnalysisEventLayout, Set<String>> fRequiredEvents = new HashMap<IKernelAnalysisEventLayout, Set<String>>();
    private final Map<HostThread, OverheadStatus> fPrevStatus = new HashMap<HostThread, OverheadStatus>();
    private final VmOverheadStateProvider fProvider;

    public SchedSwitchEventHandler(VmOverheadStateProvider provider) {
        this.fProvider = provider;
    }

    @Override
    public Set<String> getRequiredEvents(IKernelAnalysisEventLayout layout) {
        Set<String> events = this.fRequiredEvents.get(layout);
        if (events == null) {
            events = new HashSet<String>();
            events.add(layout.eventSchedSwitch());
            this.fRequiredEvents.put(layout, events);
        }
        return events;
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event, IVirtualEnvironmentModel virtEnv, IKernelAnalysisEventLayout eventLayout) {
        VirtualMachine currentMachine = virtEnv.getCurrentMachine(event);
        if (currentMachine.isHost()) {
            this.handleHostSchedSwitch(ss, event, virtEnv, eventLayout);
        }
        if (currentMachine.isGuest()) {
            this.handleGuestSchedSwitch(ss, event, virtEnv, eventLayout, currentMachine);
        }
    }

    private void handleHostSchedSwitch(ITmfStateSystemBuilder ss, ITmfEvent event, IVirtualEnvironmentModel virtEnv, IKernelAnalysisEventLayout eventLayout) {
        int statusQuark;
        int preemptQuark;
        int tidQuark;
        int quark;
        VirtualMachine vm;
        IHostModel model;
        int guestTid;
        VirtualCPU vcpu;
        ITmfEventField content = event.getContent();
        String hostId = event.getTrace().getHostId();
        long ts = event.getTimestamp().getValue();
        int prevTid = ((Long)content.getField(new String[]{eventLayout.fieldPrevTid()}).getValue()).intValue();
        int nextTid = ((Long)content.getField(new String[]{eventLayout.fieldNextTid()}).getValue()).intValue();
        Long prevState = (Long)content.getFieldValue(Long.class, new String[]{eventLayout.fieldPrevState()});
        VirtualCPU virtualCPU = vcpu = prevTid == 0 ? null : virtEnv.getVirtualCpu(event, new HostThread(hostId, Integer.valueOf(prevTid)));
        if (vcpu != null && (guestTid = (model = ModelManager.getModelFor((String)(vm = vcpu.getVm()).getHostId())).getThreadOnCpu(vcpu.getCpuId().intValue(), ts)) != -1) {
            quark = ss.getQuarkAbsoluteAndAdd(new String[]{"Traces", vm.getTraceName(), "Threads", VmOverheadStateProvider.buildThreadAttributeName(guestTid, vcpu.getCpuId().intValue()), "CallStack"});
            tidQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"1"});
            if (ss.queryOngoing(tidQuark) == null) {
                HostThread hostThread = new HostThread(event.getTrace().getHostId(), Integer.valueOf(guestTid));
                this.fProvider.createGuestThreadStatus(ss, hostThread, ts, tidQuark);
            }
            preemptQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"2"});
            statusQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"3"});
            this.fPrevStatus.put(new HostThread(vm.getHostId(), Integer.valueOf(guestTid)), new OverheadStatus(ss.queryOngoing(preemptQuark), ss.queryOngoing(statusQuark)));
            ss.modifyAttribute(ts, (Object)"VCPU Preempted", preemptQuark);
            if (prevState != null) {
                ss.modifyAttribute(ts, (Object)String.valueOf(prevState), statusQuark);
            }
        }
        VirtualCPU virtualCPU2 = vcpu = nextTid == 0 ? null : virtEnv.getVirtualCpu(event, new HostThread(hostId, Integer.valueOf(nextTid)));
        if (vcpu != null && (guestTid = (model = ModelManager.getModelFor((String)(vm = vcpu.getVm()).getHostId())).getThreadOnCpu(vcpu.getCpuId().intValue(), ts)) != -1) {
            quark = ss.getQuarkAbsoluteAndAdd(new String[]{"Traces", vm.getTraceName(), "Threads", VmOverheadStateProvider.buildThreadAttributeName(guestTid, vcpu.getCpuId().intValue()), "CallStack"});
            tidQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"1"});
            if (ss.queryOngoing(tidQuark) == null) {
                ss.modifyAttribute(ts, (Object)"Running", tidQuark);
            }
            preemptQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"2"});
            statusQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"3"});
            OverheadStatus overheadStatus = this.fPrevStatus.remove(new HostThread(vm.getHostId(), Integer.valueOf(guestTid)));
            if (overheadStatus == null) {
                ss.removeAttribute(ts, preemptQuark);
                ss.removeAttribute(ts, statusQuark);
            } else {
                ss.modifyAttribute(ts, overheadStatus.fLevel2, preemptQuark);
                ss.modifyAttribute(ts, overheadStatus.fLevel3, statusQuark);
            }
        }
    }

    private void handleGuestSchedSwitch(ITmfStateSystemBuilder ss, ITmfEvent event, IVirtualEnvironmentModel virtEnv, IKernelAnalysisEventLayout eventLayout, VirtualMachine host) {
        VirtualCPU virtualCPU;
        HostThread vcpuTid;
        ITmfEventField content = event.getContent();
        long ts = event.getTimestamp().getValue();
        int prevTid = ((Long)content.getField(new String[]{eventLayout.fieldPrevTid()}).getValue()).intValue();
        int nextTid = ((Long)content.getField(new String[]{eventLayout.fieldNextTid()}).getValue()).intValue();
        Object cpuObj = TmfTraceUtils.resolveEventAspectOfClassForEvent((ITmfTrace)event.getTrace(), TmfCpuAspect.class, (ITmfEvent)event);
        int cpu = cpuObj == null ? -1 : (Integer)cpuObj;
        int baseQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Traces", event.getTrace().getName(), "Threads", VmOverheadStateProvider.buildThreadAttributeName(prevTid, cpu)});
        int quark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{"hostTid"});
        ss.removeAttribute(ts, quark);
        quark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{"CallStack"});
        int tidQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"1"});
        ss.removeAttribute(ts, tidQuark);
        int preemptQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"2"});
        ss.removeAttribute(ts, preemptQuark);
        int statusQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"3"});
        ss.removeAttribute(ts, statusQuark);
        this.fProvider.removeGuestThreadStatus(new HostThread(event.getTrace().getHostId(), Integer.valueOf(prevTid)));
        baseQuark = ss.getQuarkAbsoluteAndAdd(new String[]{"Traces", event.getTrace().getName(), "Threads", VmOverheadStateProvider.buildThreadAttributeName(nextTid, cpu)});
        if (cpu >= 0 && (vcpuTid = virtEnv.getVirtualCpuTid(virtualCPU = VirtualCPU.getVirtualCPU(host, Long.valueOf(cpu)))) != null) {
            quark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{"hostTid"});
            ss.modifyAttribute(ts, (Object)vcpuTid.getTid(), quark);
        }
        if (ss.queryOngoing(tidQuark = ss.getQuarkRelativeAndAdd(quark = ss.getQuarkRelativeAndAdd(baseQuark, new String[]{"CallStack"}), new String[]{"1"})) == null) {
            ss.modifyAttribute(ts, (Object)"Running", tidQuark);
        }
        preemptQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"2"});
        ss.removeAttribute(ts, preemptQuark);
        statusQuark = ss.getQuarkRelativeAndAdd(quark, new String[]{"3"});
        ss.removeAttribute(ts, statusQuark);
        HostThread hostThread = new HostThread(event.getTrace().getHostId(), Integer.valueOf(nextTid));
        this.fProvider.createGuestThreadStatus(ss, hostThread, ts, tidQuark);
    }

    private class OverheadStatus {
        private final @Nullable Object fLevel2;
        private final @Nullable Object fLevel3;

        public OverheadStatus(@Nullable Object level2, Object level3) {
            this.fLevel2 = level2;
            this.fLevel3 = level3;
        }
    }
}

