/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.annotations;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.annotations.Messages;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.statistics.TmfStatisticsModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class LostEventsOutputAnnotationProvider
implements IOutputAnnotationProvider {
    private static final String LOST_EVENTS = (String)NonNullUtils.checkNotNull((Object)Messages.LostEventsOutputAnnotationProvider_LostEventsCategory);
    private static final TmfModelResponse<AnnotationModel> NO_DATA = new TmfModelResponse<AnnotationModel>(new AnnotationModel(Collections.emptyMap()), ITmfResponse.Status.COMPLETED, "");
    private final ITmfTrace fTrace;
    private List<Long> fLastRequest = Collections.emptyList();
    private @Nullable AnnotationModel fLastAnnotationModel;
    private static final String COLOR = "#FF0032";
    private static final float OPACITY = 0.19607843f;

    public LostEventsOutputAnnotationProvider(ITmfTrace trace) {
        this.fTrace = trace;
    }

    @Override
    public TmfModelResponse<AnnotationCategoriesModel> fetchAnnotationCategories(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        AnnotationCategoriesModel model = new AnnotationCategoriesModel(Collections.emptyList());
        ITmfStateSystem ss = this.getStateSystem();
        if (ss != null && LostEventsOutputAnnotationProvider.getLostEventsQuark(ss) != -1) {
            model = new AnnotationCategoriesModel(Arrays.asList(LOST_EVENTS));
        }
        return new TmfModelResponse<AnnotationCategoriesModel>(model, ITmfResponse.Status.COMPLETED, "");
    }

    @Override
    public TmfModelResponse<AnnotationModel> fetchAnnotations(Map<String, Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        ITmfStateSystem ss;
        IProgressMonitor progressMonitor = monitor;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        if ((ss = this.getStateSystem()) == null) {
            return NO_DATA;
        }
        int lostEventsQuark = LostEventsOutputAnnotationProvider.getLostEventsQuark(ss);
        if (lostEventsQuark == -1) {
            return NO_DATA;
        }
        List<Long> timeRequested = DataProviderParameterUtils.extractTimeRequested(fetchParameters);
        @Nullable Set<@NonNull String> categories = DataProviderParameterUtils.extractSelectedCategories(fetchParameters);
        if (timeRequested == null || timeRequested.size() < 2 || categories != null && !categories.contains(LOST_EVENTS)) {
            return NO_DATA;
        }
        if (timeRequested.equals(this.fLastRequest)) {
            return new TmfModelResponse<AnnotationModel>(this.fLastAnnotationModel, ITmfResponse.Status.COMPLETED, "");
        }
        this.fLastRequest = new ArrayList<Long>(timeRequested);
        TreeMultimap markers = TreeMultimap.create(Comparator.naturalOrder(), Comparator.comparing(IAnnotation::getStartTime));
        try {
            long start = Math.max(timeRequested.get(0), ss.getStartTime());
            long end = Math.min(timeRequested.get(timeRequested.size() - 1), ss.getCurrentEndTime());
            if (start <= end) {
                ArrayList<Long> times = new ArrayList<Long>(LostEventsOutputAnnotationProvider.getTimes(ss, timeRequested));
                start = Math.max(start - 1L, ss.getStartTime());
                long nextStartTime = ss.querySingleState(end, lostEventsQuark).getEndTime() + 1L;
                end = Math.min(nextStartTime, ss.getCurrentEndTime());
                times.set(0, start);
                times.set(times.size() - 1, end);
                for (ITmfStateInterval interval : ss.query2D((Collection)ImmutableList.of((Object)lostEventsQuark), times)) {
                    if (progressMonitor.isCanceled()) {
                        this.fLastRequest = Collections.emptyList();
                        this.fLastAnnotationModel = new AnnotationModel(Collections.emptyMap());
                        return new TmfModelResponse<AnnotationModel>(this.fLastAnnotationModel, ITmfResponse.Status.CANCELLED, "");
                    }
                    if (interval.getStateValue().isNull()) continue;
                    long lostEventsStartTime = interval.getStartTime();
                    long lostEventsEndTime = interval.getStateValue().unboxLong();
                    long duration = lostEventsEndTime - lostEventsStartTime;
                    HashMap<String, Object> style = new HashMap<String, Object>();
                    style.put("color", COLOR);
                    style.put("opacity", Float.valueOf(0.19607843f));
                    markers.put((Object)LOST_EVENTS, (Object)new Annotation(lostEventsStartTime, duration, -1L, IAnnotation.AnnotationType.CHART, null, new OutputElementStyle(LOST_EVENTS, style)));
                }
            }
        }
        catch (StateSystemDisposedException stateSystemDisposedException) {}
        this.fLastAnnotationModel = new AnnotationModel(markers.asMap());
        return new TmfModelResponse<AnnotationModel>(this.fLastAnnotationModel, ITmfResponse.Status.COMPLETED, "");
    }

    private @Nullable ITmfStateSystem getStateSystem() {
        TmfStatisticsModule module = TmfTraceUtils.getAnalysisModuleOfClass(this.fTrace, TmfStatisticsModule.class, "org.eclipse.linuxtools.tmf.core.statistics.analysis");
        if (module == null) {
            return null;
        }
        return module.getStateSystem("org.eclipse.linuxtools.tmf.statistics.types");
    }

    private static int getLostEventsQuark(ITmfStateSystem ss) {
        try {
            return ss.getQuarkAbsolute(new String[]{"lost_events"});
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            return -1;
        }
    }

    private static Collection<@NonNull Long> getTimes(ITmfStateSystem ss, List<Long> timeRequested) {
        long start = ss.getStartTime();
        long end = ss.getCurrentEndTime();
        LinkedHashSet<@NonNull Long> times = new LinkedHashSet<Long>();
        for (long t : timeRequested) {
            if (t < start || t > end) continue;
            times.add(t);
        }
        return times;
    }
}

