/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.IContext;
import org.eclipse.help.IContextProvider;
import org.eclipse.help.IHelpResource;
import org.eclipse.help.browser.IBrowser;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.ui.internal.ContextHelpDialog;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.util.ErrorUtil;
import org.eclipse.help.ui.internal.util.FontUtils;
import org.eclipse.help.ui.internal.views.ContextHelpPart;
import org.eclipse.help.ui.internal.views.HelpTray;
import org.eclipse.help.ui.internal.views.HelpView;
import org.eclipse.help.ui.internal.views.ReusableHelpPart;
import org.eclipse.jface.dialogs.DialogTray;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.help.AbstractHelpUI;
import org.eclipse.ui.intro.IIntroManager;
import org.eclipse.ui.intro.IIntroPart;

public class DefaultHelpUI
extends AbstractHelpUI {
    private ContextHelpDialog f1Dialog = null;
    private static DefaultHelpUI instance;
    private static boolean openingHelpView;
    private static final String HELP_VIEW_ID = "org.eclipse.help.ui.HelpView";

    static {
        openingHelpView = false;
    }

    public DefaultHelpUI() {
        instance = this;
        BaseHelpSystem.getInstance().setBrowserInstance((IBrowser)new ExternalWorkbenchBrowser());
    }

    public static DefaultHelpUI getInstance() {
        return instance;
    }

    public void displayHelp() {
        BaseHelpSystem.getHelpDisplay().displayHelp(this.useExternalBrowser(null));
    }

    public void displaySearch() {
        this.search(null);
    }

    public void displayDynamicHelp() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window)) {
            DefaultHelpUI.setIntroStandby();
            IWorkbenchPage page = window.getActivePage();
            Control c = activeShell.getDisplay().getFocusControl();
            if (page != null) {
                IWorkbenchPart activePart = page.getActivePart();
                try {
                    IViewPart part = page.showView(HELP_VIEW_ID, null, 1);
                    if (part != null) {
                        HelpView view = (HelpView)part;
                        view.showDynamicHelp(activePart, c);
                    }
                }
                catch (PartInitException partInitException) {}
            } else {
                Object data = activeShell.getData();
                if (data instanceof TrayDialog) {
                    IContext context = ContextHelpPart.findHelpContext(c);
                    this.displayContextAsHelpTray(activeShell, context);
                    return;
                }
                this.warnNoOpenPerspective(window);
            }
        }
    }

    public void search(String expression) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window)) {
            DefaultHelpUI.setIntroStandby();
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                boolean searchFromBrowser = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "search_from_browser", false, null);
                if (searchFromBrowser) {
                    String parameters = "tab=search";
                    if (expression != null) {
                        try {
                            parameters = String.valueOf(parameters) + "&searchWord=" + URLEncoder.encode(expression, "UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    BaseHelpSystem.getHelpDisplay().displayHelpResource(parameters, false);
                } else {
                    try {
                        IViewPart part = page.showView(HELP_VIEW_ID);
                        if (part != null) {
                            HelpView view = (HelpView)part;
                            view.startSearch(expression);
                        }
                    }
                    catch (PartInitException partInitException) {}
                }
            } else {
                if (activeShell != null) {
                    Object data = activeShell.getData();
                    if (data instanceof TrayDialog) {
                        this.displayContextAsHelpTray(activeShell, null);
                        return;
                    }
                    return;
                }
                this.warnNoOpenPerspective(window);
            }
        }
    }

    public static void showIndex() {
        HelpView helpView = DefaultHelpUI.getHelpView();
        if (helpView != null) {
            helpView.showIndex();
        }
    }

    private static HelpView getHelpView() {
        HelpView view = null;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window)) {
            DefaultHelpUI.setIntroStandby();
            IWorkbenchPage page = window.getActivePage();
            if (page != null) {
                try {
                    IViewPart part = page.showView(HELP_VIEW_ID);
                    if (part != null) {
                        view = (HelpView)part;
                    }
                }
                catch (PartInitException partInitException) {}
            }
        }
        return view;
    }

    private static void setIntroStandby() {
        IIntroManager introMng = PlatformUI.getWorkbench().getIntroManager();
        IIntroPart intro = introMng.getIntro();
        if (intro != null && !introMng.isIntroStandby(intro)) {
            introMng.setIntroStandby(intro, true);
        }
    }

    private void warnNoOpenPerspective(IWorkbenchWindow window) {
        MessageDialog.openInformation((Shell)window.getShell(), (String)Messages.DefaultHelpUI_wtitle, (String)Messages.DefaultHelpUI_noPerspMessage);
    }

    public void displayHelpResource(String href) {
        BaseHelpSystem.getHelpDisplay().displayHelpResource(href, this.useExternalBrowser(href));
    }

    public void displayContext(IContext context, int x, int y) {
        this.displayContext(context, x, y, false);
    }

    void displayContext(IContext context, int x, int y, boolean noInfopop) {
        IWorkbenchPage page;
        if (context == null) {
            return;
        }
        boolean winfopop = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "window_infopop", false, null);
        boolean dinfopop = Platform.getPreferencesService().getBoolean("org.eclipse.help.base", "dialog_infopop", false, null) || FontUtils.isFontTooLargeForTray();
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Shell activeShell = DefaultHelpUI.getActiveShell();
        if (window != null && DefaultHelpUI.isActiveShell(activeShell, window) && (page = window.getActivePage()) != null) {
            if (!noInfopop && winfopop) {
                Control c = window.getShell().getDisplay().getFocusControl();
                this.displayContextAsInfopop(context, x, y, c);
                return;
            }
            try {
                IWorkbenchPart activePart = page.getActivePart();
                Control c = window.getShell().getDisplay().getFocusControl();
                IContextProvider adapter = (IContextProvider)activePart.getAdapter(IContextProvider.class);
                if (adapter != null) {
                    context = adapter.getContext((Object)c);
                }
                String contextText = context.getText();
                IHelpResource[] topics = context.getRelatedTopics();
                boolean isSingleChoiceWithoutDescription = contextText == null && topics.length == 1;
                String openMode = Platform.getPreferencesService().getString("org.eclipse.help.base", "help_view_open_mode", "in_place", null);
                if (isSingleChoiceWithoutDescription && "in editor".equals(openMode)) {
                    DefaultHelpUI.showInWorkbenchBrowser(topics[0].getHref(), true);
                } else if (isSingleChoiceWithoutDescription && "in browser".equals(openMode)) {
                    BaseHelpSystem.getHelpDisplay().displayHelpResource(topics[0].getHref(), true);
                } else {
                    openingHelpView = true;
                    IViewPart part = page.showView(HELP_VIEW_ID);
                    openingHelpView = false;
                    if (part != null) {
                        HelpView view = (HelpView)part;
                        if (isSingleChoiceWithoutDescription) {
                            view.showHelp(topics[0].getHref());
                        } else {
                            view.displayContext(context, activePart, c);
                        }
                    }
                }
                return;
            }
            catch (PartInitException partInitException) {}
        }
        if (HelpTray.isAppropriateFor(activeShell) && (!dinfopop || noInfopop)) {
            this.displayContextAsHelpTray(activeShell, context);
            return;
        }
        this.displayContextAsInfopop(context, x, y, null);
    }

    public URL resolve(String href, boolean documentOnly) {
        return BaseHelpSystem.resolve((String)href, (boolean)documentOnly);
    }

    public String unresolve(URL url) {
        return BaseHelpSystem.unresolve((URL)url);
    }

    private static Shell getActiveShell() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        return display.getActiveShell();
    }

    static boolean isActiveShell(Shell activeShell, IWorkbenchWindow window) {
        return activeShell != null && activeShell.equals(window.getShell());
    }

    private void displayContextAsInfopop(IContext context, int x, int y, Control c) {
        if (this.f1Dialog != null) {
            this.f1Dialog.close();
        }
        if (context != null) {
            IHelpResource[] topics = context.getRelatedTopics();
            if (context.getText() == null && topics.length == 1) {
                try {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(topics[0].getHref());
                }
                catch (Exception exception) {}
            } else {
                this.f1Dialog = new ContextHelpDialog(context, x, y);
                this.f1Dialog.open();
            }
        }
    }

    private void displayContextAsHelpTray(Shell activeShell, IContext context) {
        Control controlInFocus = activeShell.getDisplay().getFocusControl();
        TrayDialog dialog = (TrayDialog)activeShell.getData();
        DialogTray tray = dialog.getTray();
        if (tray == null) {
            tray = new HelpTray();
            dialog.openTray(tray);
        }
        if (tray instanceof HelpTray) {
            ReusableHelpPart helpPart = ((HelpTray)tray).getHelpPart();
            if (context != null) {
                IHelpResource[] topics = context.getRelatedTopics();
                if (context.getText() == null && topics.length == 1) {
                    helpPart.showURL(topics[0].getHref());
                } else {
                    helpPart.showPage("context-help-page");
                    helpPart.update(null, context, null, controlInFocus, true);
                }
            } else {
                helpPart.showPage("fsearch-page", true);
            }
            helpPart.setFocus();
        }
    }

    public boolean isContextHelpDisplayed() {
        if (this.f1Dialog == null) {
            return false;
        }
        return this.f1Dialog.isShowing();
    }

    private boolean useExternalBrowser(String url) {
        Display display;
        if (!"win32".equalsIgnoreCase(Platform.getOS()) && (display = Display.getCurrent()) != null && this.insideModalParent(display)) {
            return true;
        }
        return url != null && (url.indexOf("?noframes=true") > 0 || url.indexOf("&noframes=true") > 0);
    }

    private boolean insideModalParent(Display display) {
        return DefaultHelpUI.isDisplayModal(display.getActiveShell());
    }

    public static boolean isDisplayModal(Shell activeShell) {
        while (activeShell != null) {
            if ((activeShell.getStyle() & 0x38000) > 0) {
                return true;
            }
            activeShell = (Shell)activeShell.getParent();
        }
        return false;
    }

    public static boolean showInWorkbenchBrowser(String url, boolean onlyInternal) {
        IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
        if (!onlyInternal || support.isInternalWebBrowserAvailable()) {
            try {
                IWebBrowser browser = support.createBrowser(44, "org.eclipse.help.ui", Messages.ReusableHelpPart_internalBrowserTitle, url);
                browser.openURL(BaseHelpSystem.resolve((String)url, (String)"/help/nftopic"));
                return true;
            }
            catch (PartInitException e) {
                Platform.getLog(DefaultHelpUI.class).error(Messages.ReusableHelpPart_internalWebBrowserError, (Throwable)e);
            }
        }
        return false;
    }

    public static boolean isOpeningHelpView() {
        return openingHelpView;
    }

    class ExternalWorkbenchBrowser
    implements IBrowser {
        private IWebBrowser getExternalBrowser() throws PartInitException {
            IWorkbenchBrowserSupport support = PlatformUI.getWorkbench().getBrowserSupport();
            return support.getExternalBrowser();
        }

        public void close() {
        }

        public boolean isCloseSupported() {
            return false;
        }

        public void displayURL(String url) throws Exception {
            try {
                IWebBrowser browser = this.getExternalBrowser();
                if (browser != null) {
                    browser.openURL(new URL(url));
                }
            }
            catch (PartInitException pie) {
                ErrorUtil.displayErrorDialog(pie.getLocalizedMessage());
            }
        }

        public boolean isSetLocationSupported() {
            return false;
        }

        public boolean isSetSizeSupported() {
            return false;
        }

        public void setLocation(int x, int y) {
        }

        public void setSize(int width, int height) {
        }
    }
}

