/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.segmentstore.core;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.segmentstore.core.ISegment;

public interface ISegmentStore<E extends ISegment>
extends Collection<E> {
    default public Iterable<E> iterator(Comparator<ISegment> order) {
        return this.getIntersectingElements(0L, Long.MAX_VALUE, order);
    }

    default public Iterable<E> getIntersectingElements(long position) {
        return this.getIntersectingElements(position, position);
    }

    default public Iterable<E> getIntersectingElements(long position, Comparator<ISegment> order) {
        return this.getIntersectingElements(position, position, order);
    }

    public Iterable<E> getIntersectingElements(long var1, long var3);

    default public Iterable<E> getIntersectingElements(long start, long end, Comparator<ISegment> order) {
        Iterable<E> ret = this.getIntersectingElements(start, end);
        List list = ret instanceof ArrayList ? (List)ret : Lists.newArrayList(ret);
        list.sort(order);
        return list;
    }

    default public List<E> getIntersectingElements(long start, long end, Comparator<ISegment> order, Predicate<ISegment> filter) {
        List ret;
        long startTime = start;
        long endTime = end;
        if (start > end) {
            long tmp = endTime;
            endTime = startTime;
            startTime = tmp;
        }
        Iterable<E> segments = this.getIntersectingElements(startTime, endTime, order);
        long i = 0L;
        for (ISegment segment : segments) {
            if (filter.test(segment)) break;
            ++i;
        }
        if (segments instanceof ArrayList) {
            ret = ((ArrayList)segments).subList((int)i, ((ArrayList)segments).size());
        } else {
            ArrayList tmp = Lists.newArrayList(segments);
            ret = tmp.subList((int)i, tmp.size());
        }
        return ret;
    }

    public void dispose();

    default public void close(boolean deleteFiles) {
    }

    @Override
    default public boolean remove(@Nullable Object o) {
        throw new UnsupportedOperationException("Segment stores does not support \"remove\"");
    }

    @Override
    default public boolean removeAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException("Segment stores does not support \"removeAll\"");
    }

    @Override
    default public boolean retainAll(@Nullable Collection<?> c) {
        throw new UnsupportedOperationException("Segment stores does not support \"retainAll\"");
    }
}

