/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.analysis.core.weighted.tree.IWeightedTreeProvider;
import org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.FlameGraphDataProvider;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TmfTimeGraphCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;

public class FlameGraphDataProviderFactory
implements IDataProviderFactory {
    private static Map<String, FlameGraphDataProvider<?, ?, ?>> INSTANCES = new HashMap();

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace) {
        return null;
    }

    public @Nullable ITmfTreeDataProvider<? extends ITmfTreeDataModel> createProvider(ITmfTrace trace, String secondaryId) {
        Collection traces = TmfTraceManager.getTraceSetWithExperiment((ITmfTrace)trace);
        ArrayList providers = new ArrayList();
        for (ITmfTrace child : traces) {
            FlameGraphDataProvider<?, ?, ?> childProvider = FlameGraphDataProviderFactory.create(child, secondaryId);
            if (childProvider == null) continue;
            providers.add(childProvider);
        }
        if (providers.isEmpty()) {
            return null;
        }
        if (providers.size() == 1) {
            return (ITmfTreeDataProvider)providers.get(0);
        }
        return new TmfTimeGraphCompositeDataProvider(providers, "org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.provider:" + secondaryId);
    }

    private static @Nullable FlameGraphDataProvider<?, ?, ?> create(ITmfTrace trace, String secondaryId) {
        FlameGraphDataProvider<?, ?, ?> dataProvider = INSTANCES.get(secondaryId);
        if (dataProvider != null) {
            return dataProvider;
        }
        IAnalysisModule analysisModule = trace.getAnalysisModule(secondaryId);
        if (!(analysisModule instanceof IWeightedTreeProvider)) {
            return null;
        }
        analysisModule.schedule();
        return new FlameGraphDataProvider(trace, (IWeightedTreeProvider)analysisModule, "org.eclipse.tracecompass.incubator.internal.callstack.core.flamegraph.provider:" + secondaryId);
    }

    @VisibleForTesting
    public static void registerDataProviderWithId(String id, @Nullable FlameGraphDataProvider<?, ?, ?> dataProvider) {
        if (dataProvider == null) {
            INSTANCES.remove(id);
            return;
        }
        INSTANCES.put(id, dataProvider);
    }
}

