/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTEqualsInitializer;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializer;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTInitializerList;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.c.CASTEqualsInitializer;

public class CASTInitializerList
extends ASTNode
implements IASTInitializerList,
IASTAmbiguityParent {
    private IASTInitializerClause[] initializers;
    private int initializersPos = -1;
    private int actualSize;

    @Override
    public CASTInitializerList copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTInitializerList copy(IASTNode.CopyStyle style) {
        CASTInitializerList copy = new CASTInitializerList();
        IASTInitializerClause[] iASTInitializerClauseArray = this.getClauses();
        int n = iASTInitializerClauseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause initializer = iASTInitializerClauseArray[n2];
            copy.addClause(initializer == null ? null : initializer.copy(style));
            ++n2;
        }
        copy.actualSize = this.getSize();
        return this.copy(copy, style);
    }

    @Override
    public int getSize() {
        return this.actualSize;
    }

    @Override
    public IASTInitializerClause[] getClauses() {
        if (this.initializers == null) {
            return IASTExpression.EMPTY_EXPRESSION_ARRAY;
        }
        this.initializers = ArrayUtil.trimAt(IASTInitializerClause.class, this.initializers, this.initializersPos);
        return this.initializers;
    }

    @Override
    @Deprecated
    public IASTInitializer[] getInitializers() {
        IASTInitializerClause[] clauses = this.getClauses();
        if (clauses.length == 0) {
            return IASTInitializer.EMPTY_INITIALIZER_ARRAY;
        }
        IASTInitializer[] inits = new IASTInitializer[clauses.length];
        int i = 0;
        while (i < inits.length) {
            IASTInitializerClause clause = clauses[i];
            if (clause instanceof IASTInitializer) {
                inits[i] = (IASTInitializer)((Object)clause);
            } else if (clause instanceof IASTExpression) {
                CASTEqualsInitializer initExpr = new CASTEqualsInitializer(((IASTExpression)clause).copy());
                initExpr.setParent(this);
                initExpr.setPropertyInParent(NESTED_INITIALIZER);
                inits[i] = initExpr;
            }
            ++i;
        }
        return inits;
    }

    @Override
    public void addClause(IASTInitializerClause d) {
        this.assertNotFrozen();
        if (d != null) {
            this.initializers = ArrayUtil.appendAt(IASTInitializerClause.class, this.initializers, ++this.initializersPos, d);
            d.setParent(this);
            d.setPropertyInParent(NESTED_INITIALIZER);
        }
        ++this.actualSize;
    }

    @Override
    @Deprecated
    public void addInitializer(IASTInitializer d) {
        this.assertNotFrozen();
        if (d instanceof IASTInitializerClause) {
            this.addClause((IASTInitializerClause)((Object)d));
        } else if (d instanceof IASTEqualsInitializer) {
            this.addClause(((IASTEqualsInitializer)d).getInitializerClause());
        } else {
            this.addClause(null);
        }
    }

    @Override
    public boolean accept(ASTVisitor action) {
        IASTInitializerClause[] list;
        if (action.shouldVisitInitializers) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        IASTInitializerClause[] iASTInitializerClauseArray = list = this.getClauses();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            IASTInitializerClause clause = iASTInitializerClauseArray[n2];
            if (!clause.accept(action)) {
                return false;
            }
            ++n2;
        }
        if (action.shouldVisitInitializers) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (this.initializers != null) {
            int i = 0;
            while (i < this.initializers.length) {
                if (child == this.initializers[i]) {
                    other.setPropertyInParent(child.getPropertyInParent());
                    other.setParent(child.getParent());
                    this.initializers[i] = (IASTInitializerClause)other;
                }
                ++i;
            }
        }
    }
}

