/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.executioncomparison.ui;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.event.FocusEvent;
import java.text.Format;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ExpandEvent;
import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.common.core.log.TraceCompassLogUtils;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.TmfCheckboxChangedSignal;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.core.TmfComparisonFilteringUpdatedSignal;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.ui.DifferentialFlameGraphView;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.ui.Messages;
import org.eclipse.tracecompass.incubator.internal.executioncomparison.ui.MultipleEventDensityViewer;
import org.eclipse.tracecompass.internal.tmf.ui.viewers.eventdensity.EventDensityTreeViewer;
import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalManager;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentInfo;
import org.eclipse.tracecompass.tmf.ui.signal.TmfTimeViewAlignmentSignal;
import org.eclipse.tracecompass.tmf.ui.viewers.ILegendImageProvider2;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfTimeViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.AbstractSelectTreeViewer2;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ICheckboxTreeViewerListener;
import org.eclipse.tracecompass.tmf.ui.viewers.tree.ITmfTreeViewerEntry;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.XYChartLegendImageProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXAxisChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfFilteredXYChartViewer;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfXYChartSettings;
import org.eclipse.tracecompass.tmf.ui.views.ManyEntriesSelectedDialogPreCheckedListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.FilteredCheckboxTree;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.IPreCheckStateListener;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.dialogs.TriStateFilteredCheckboxTree;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.themes.ITheme;
import org.eclipse.ui.themes.IThemeManager;

public class ExecutionComparisonView
extends DifferentialFlameGraphView
implements ICheckboxTreeViewerListener {
    public static final String VIEW_ID = Objects.requireNonNull(Messages.multipleDensityViewId);
    public static final String VIEW_TITLE = Objects.requireNonNull(Messages.multipleDensityViewTitle);
    private static final String DATA_SELECTION = Objects.requireNonNull(Messages.dataSelection);
    private static final String BACKGROUND = Objects.requireNonNull(Messages.background);
    private static final String FOREGROUND = Objects.requireNonNull(Messages.foreground);
    private static final String TRACE_NAME = Objects.requireNonNull(Messages.traceName);
    private static final String STATISTIC_NAME = Objects.requireNonNull(Messages.statisticName);
    private static final String TMF_VIEW_UI_CONTEXT = Objects.requireNonNull(Messages.tmfViewUiContext);
    private static final String Y_AXIS_LABEL = Objects.requireNonNull(Messages.yAxisLabel);
    private String fStatistic = Objects.requireNonNull(Messages.multipleDensityViewDuration);
    private static final int[] DEFAULT_WEIGHTS_ShowQuery = new int[]{450, 290, 260};
    private static final int[] DEFAULT_WEIGHTS_HideQuery = new int[]{450, 100, 450};
    private static final int[] DEFAULT_WEIGHTS_FILTERING_H = new int[]{3, 9};
    private static final int[] DEFAULT_WEIGHTS_TimeInterval = new int[]{240, 380, 380};
    private @Nullable TmfXYChartViewer fChartViewerA;
    private @Nullable TmfXYChartViewer fChartViewerB;
    private @Nullable SashForm fXYViewerContainerA;
    private @Nullable SashForm fXYViewerContainerB;
    private @Nullable TmfViewer fTmfViewerA;
    private @Nullable TmfViewer fTmfViewerB;
    private @Nullable SashForm fSashFormLeftChildA;
    private @Nullable SashForm fSashFormLeftChildB;
    private List<String> fTraceListA = new ArrayList<String>();
    private List<String> fTraceListB = new ArrayList<String>();
    private ITmfTimestamp fStartTimeA = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fStartTimeB = TmfTimestamp.BIG_BANG;
    private ITmfTimestamp fEndTimeA = TmfTimestamp.BIG_CRUNCH;
    private ITmfTimestamp fEndTimeB = TmfTimestamp.BIG_CRUNCH;
    private TmfTimestampFormat fFormat = new TmfTimestampFormat("yyyy-MM-dd HH:mm:ss.SSS.SSS.SSS");
    private JFormattedTextField ftextAFrom = new JFormattedTextField();
    private JFormattedTextField ftextBFrom = new JFormattedTextField();
    private JFormattedTextField ftextATo = new JFormattedTextField();
    private JFormattedTextField ftextBTo = new JFormattedTextField();
    private @Nullable IContextService fContextService;
    private @Nullable Action fConfigureStatisticAction;
    private @Nullable Text ftextQuery;
    private @Nullable Listener fSashDragListener;
    private @Nullable SashForm fsashForm = null;
    private List<IContextActivation> fActiveContexts = new ArrayList<IContextActivation>();

    @Override
    public void createPartControl(@Nullable Composite parent) {
        TmfXYChartViewer chartViewerB;
        SashForm xYViewerContainerB;
        TmfViewer tmfViewerB;
        SashForm sashFormLeftChildB;
        TmfXYChartViewer chartViewerA;
        SashForm xYViewerContainerA;
        TmfViewer tmfViewerA;
        SashForm sashFormLeftChildA;
        Color foregroundColor;
        Color backgroundColor;
        SashForm sashForm;
        TmfSignalManager.register((Object)((Object)this));
        this.setContentDescription(DATA_SELECTION);
        this.fsashForm = sashForm = new SashForm(parent, 512);
        sashForm.setLayout((Layout)new GridLayout(1, false));
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite sashFormFiltering = new Composite((Composite)sashForm, 256);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        sashFormFiltering.setLayout((Layout)layout);
        sashFormFiltering.setLayoutData((Object)new GridData(4, 4, true, true));
        Group groupA = new Group(sashFormFiltering, 0);
        GridLayout gridLayoutG = new GridLayout();
        GridData gridDataG = new GridData(1808);
        SashForm densityA = new SashForm((Composite)groupA, 0);
        GridData data = new GridData(4, 128, true, false);
        SashForm timeInputA = new SashForm((Composite)groupA, 0);
        ExecutionComparisonView.createGroups(groupA, gridLayoutG, gridDataG, densityA, data, timeInputA, true);
        Group groupB = new Group(sashFormFiltering, 0);
        SashForm densityB = new SashForm((Composite)groupB, 0);
        SashForm timeInputB = new SashForm((Composite)groupB, 0);
        ExecutionComparisonView.createGroups(groupB, gridLayoutG, gridDataG, densityB, data, timeInputB, false);
        IThemeManager themeManager = PlatformUI.getWorkbench().getThemeManager();
        ITheme currentTheme = themeManager.getCurrentTheme();
        RGB backgroundRGB = currentTheme.getColorRegistry().getRGB(BACKGROUND);
        if (backgroundRGB != null) {
            backgroundColor = new Color(backgroundRGB.red, backgroundRGB.green, backgroundRGB.blue);
        } else {
            org.eclipse.swt.graphics.Color swtColor = Display.getCurrent().getSystemColor(22);
            backgroundColor = new Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
        }
        RGB foregroundRGB = currentTheme.getColorRegistry().getRGB(FOREGROUND);
        if (foregroundRGB != null) {
            foregroundColor = new Color(foregroundRGB.red, foregroundRGB.green, foregroundRGB.blue);
        } else {
            org.eclipse.swt.graphics.Color swtColor = Display.getCurrent().getSystemColor(21);
            foregroundColor = new Color(swtColor.getRed(), swtColor.getGreen(), swtColor.getBlue());
        }
        Composite timelableA = new Composite((Composite)timeInputA, 0);
        Composite timelableAFrom = new Composite((Composite)timeInputA, 0x1000000);
        Composite timelableATo = new Composite((Composite)timeInputA, 0x1000000);
        timeInputA.setWeights(DEFAULT_WEIGHTS_TimeInterval);
        RowLayout rowLayout = new RowLayout();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        timelableA.setLayout((Layout)gridLayout);
        timelableAFrom.setLayout((Layout)rowLayout);
        timelableATo.setLayout((Layout)rowLayout);
        this.fSashFormLeftChildA = sashFormLeftChildA = new SashForm((Composite)densityA, 0);
        this.fTmfViewerA = tmfViewerA = this.createLeftChildViewer((Composite)sashFormLeftChildA);
        this.fXYViewerContainerA = xYViewerContainerA = new SashForm((Composite)densityA, 0);
        xYViewerContainerA.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.fChartViewerA = chartViewerA = this.createChartViewer((Composite)xYViewerContainerA);
        Button resetButtonA = new Button(timelableA, 8);
        this.createResetButtonA(resetButtonA, chartViewerA, tmfViewerA);
        Frame frameAFrom = SWT_AWT.new_Frame((Composite)timelableAFrom);
        Panel panelAFrom = new Panel();
        JFormattedTextField textAFrom = new JFormattedTextField((Format)this.fFormat);
        if (frameAFrom != null) {
            this.createLabelFromA(frameAFrom, panelAFrom, textAFrom, backgroundColor, foregroundColor, chartViewerA);
        }
        Frame frameATo = SWT_AWT.new_Frame((Composite)timelableATo);
        Panel panelATo = new Panel();
        JFormattedTextField textATo = new JFormattedTextField((Format)this.fFormat);
        if (frameATo != null) {
            this.createLabelToA(frameATo, panelATo, textATo, backgroundColor, foregroundColor, chartViewerA);
        }
        Composite timelableB = new Composite((Composite)timeInputB, 4);
        Composite timelableBFrom = new Composite((Composite)timeInputB, 0x1000000);
        Composite timelableBTo = new Composite((Composite)timeInputB, 0x1000000);
        timeInputB.setWeights(DEFAULT_WEIGHTS_TimeInterval);
        timelableB.setLayout((Layout)gridLayout);
        timelableBFrom.setLayout((Layout)rowLayout);
        timelableBTo.setLayout((Layout)rowLayout);
        this.fSashFormLeftChildB = sashFormLeftChildB = new SashForm((Composite)densityB, 0);
        this.fTmfViewerB = tmfViewerB = this.createLeftChildViewer((Composite)sashFormLeftChildB);
        this.fXYViewerContainerB = xYViewerContainerB = new SashForm((Composite)densityB, 512);
        xYViewerContainerB.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.fChartViewerB = chartViewerB = this.createChartViewer((Composite)xYViewerContainerB);
        Button resetButtonB = new Button(timelableB, 8);
        this.createResetButtonB(resetButtonB, chartViewerB, tmfViewerB);
        Frame frameBFrom = SWT_AWT.new_Frame((Composite)timelableBFrom);
        Panel panelBFrom = new Panel();
        JFormattedTextField textBFrom = new JFormattedTextField((Format)this.fFormat);
        if (frameBFrom != null) {
            this.createLabelFromB(frameBFrom, panelBFrom, textBFrom, backgroundColor, foregroundColor, chartViewerB);
        }
        Frame frameBTo = SWT_AWT.new_Frame((Composite)timelableBTo);
        Panel panelBTo = new Panel();
        JFormattedTextField textBTo = new JFormattedTextField((Format)this.fFormat);
        if (frameBTo != null) {
            this.createLabelToB(frameBTo, panelBTo, textBTo, backgroundColor, foregroundColor, chartViewerB);
        }
        this.createControlPaintListenerA(chartViewerA, sashFormLeftChildA);
        IStatusLineManager statusLineManager = this.getViewSite().getActionBars().getStatusLineManager();
        chartViewerA.setStatusLineManager(statusLineManager);
        ExecutionComparisonView.coupleSelectViewer(tmfViewerA, chartViewerA);
        ((AbstractSelectTreeViewer2)tmfViewerA).addTreeListener((ICheckboxTreeViewerListener)this);
        IWorkbenchPartSite site = this.getSite();
        this.fContextService = (IContextService)site.getWorkbenchWindow().getService(IContextService.class);
        this.createControlPaintListenerB(chartViewerB, sashFormLeftChildB);
        chartViewerB.setStatusLineManager(statusLineManager);
        ExecutionComparisonView.coupleSelectViewer(tmfViewerB, chartViewerB);
        ((AbstractSelectTreeViewer2)tmfViewerB).addTreeListener((ICheckboxTreeViewerListener)this);
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        Action aggregatedAction = this.fConfigureStatisticAction;
        if (aggregatedAction == null) {
            this.fConfigureStatisticAction = aggregatedAction = this.getAggregateByAction();
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)aggregatedAction);
        menuManager.add((IContributionItem)new Separator());
        densityA.setWeights(DEFAULT_WEIGHTS_FILTERING_H);
        densityB.setWeights(DEFAULT_WEIGHTS_FILTERING_H);
        Group groupQuery = new Group((Composite)sashForm, 0);
        groupQuery.setText(Messages.multipleDensityViewQueryGroup);
        gridLayoutG = new GridLayout();
        gridLayoutG.numColumns = 1;
        groupQuery.setLayout((Layout)gridLayoutG);
        gridDataG = new GridData(1808);
        gridDataG.horizontalSpan = 1;
        groupQuery.setLayoutData((Object)gridDataG);
        ExpandBar bar = new ExpandBar((Composite)groupQuery, 0);
        bar.setLayout((Layout)new GridLayout(1, false));
        GridData data2 = new GridData();
        data2.verticalAlignment = 4;
        data2.horizontalAlignment = 4;
        data2.grabExcessHorizontalSpace = true;
        data2.grabExcessVerticalSpace = true;
        data2.heightHint = 75;
        data2.widthHint = 100;
        bar.setLayoutData((Object)data2);
        Composite queryText = new Composite((Composite)bar, 0);
        queryText.setLayout((Layout)new GridLayout(1, false));
        queryText.setLayoutData((Object)new GridData(4, 4, true, true));
        Text text = new Text(queryText, 2050);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        data.heightHint = 75;
        data.widthHint = 100;
        text.setLayoutData((Object)data);
        this.ftextQuery = text;
        this.addTextFocusListener(text, chartViewerA, chartViewerB, tmfViewerA, tmfViewerB);
        ExpandItem item0 = new ExpandItem(bar, 0, 0);
        item0.setText(Messages.multipleDensityViewQueryExpandable);
        item0.setHeight(150);
        item0.setControl((Control)queryText);
        item0.setExpanded(false);
        bar.setSpacing(5);
        ExecutionComparisonView.createExpandBarListener(bar, queryText, sashForm);
        super.createPartControl((Composite)sashForm);
        sashForm.setWeights(DEFAULT_WEIGHTS_HideQuery);
        ITmfTrace activetrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activetrace != null) {
            this.buildDifferentialFlameGraph();
        }
    }

    private static void createGroups(Group group, GridLayout gridLayoutG, GridData gridDataG, SashForm density, GridData data, SashForm timeInput, boolean isA) {
        if (isA) {
            group.setText(Messages.multipleDensityViewGroupA);
        } else {
            group.setText(Messages.multipleDensityViewGroupB);
        }
        gridLayoutG.numColumns = 1;
        group.setLayout((Layout)gridLayoutG);
        gridDataG.horizontalSpan = 1;
        group.setLayoutData((Object)gridDataG);
        data.heightHint = 200;
        density.setLayoutData((Object)data);
        timeInput.setLayoutData((Object)new GridData(768));
    }

    private void createResetButtonA(Button resetButton, TmfXYChartViewer chartViewerA, TmfViewer tmfViewerA) {
        resetButton.setText("Reset Time IntervalA");
        resetButton.addListener(13, event -> {
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            if (trace != null) {
                List<ITmfTreeViewerEntry> treeCheckedElements = ((MultipleEventDensityViewer)chartViewerA).getWholeCheckedItems();
                this.setCheckedElements(chartViewerA, tmfViewerA, treeCheckedElements, false);
                this.fStartTimeA = trace.getStartTime();
                this.fEndTimeA = trace.getEndTime();
                this.ftextAFrom.setText(this.fStartTimeA.toString(this.fFormat));
                this.ftextATo.setText(this.fEndTimeA.toString(this.fFormat));
                if (this.ftextQuery != null) {
                    this.ftextQuery.setText(this.buildComparisonQuery());
                }
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)chartViewerA, this.fStartTimeA, this.fEndTimeA, this.getTrace()));
            }
        });
    }

    private void createResetButtonB(Button resetButton, TmfXYChartViewer chartViewerB, TmfViewer tmfViewerB) {
        resetButton.setText("Reset Time IntervalB");
        resetButton.addListener(13, event -> {
            ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
            if (trace != null) {
                List<ITmfTreeViewerEntry> treeCheckedElements = ((MultipleEventDensityViewer)chartViewerB).getWholeCheckedItems();
                this.setCheckedElements(chartViewerB, tmfViewerB, treeCheckedElements, false);
                this.fStartTimeB = trace.getStartTime();
                this.fEndTimeB = trace.getEndTime();
                this.ftextBFrom.setText(this.fStartTimeB.toString(this.fFormat));
                this.ftextBTo.setText(this.fEndTimeB.toString(this.fFormat));
                if (this.ftextQuery != null) {
                    this.ftextQuery.setText(this.buildComparisonQuery());
                }
                TmfSignalManager.dispatchSignal((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)chartViewerB, this.fStartTimeB, this.fEndTimeB, this.getTrace()));
            }
        });
    }

    private void createLabelFromA(Frame frameFrom, Panel panelFrom, final JFormattedTextField textFrom, Color backgroundColor, Color foregroundColor, final TmfXYChartViewer chartViewer) {
        frameFrom.add(panelFrom);
        JLabel labelAFrom = new JLabel();
        labelAFrom.setText(Messages.multipleDensityViewFrom);
        panelFrom.setBackground(backgroundColor);
        textFrom.setBackground(backgroundColor);
        labelAFrom.setBackground(backgroundColor);
        textFrom.setForeground(foregroundColor);
        labelAFrom.setForeground(foregroundColor);
        textFrom.addFocusListener(new java.awt.event.FocusListener(){
            private String oldVal = "";

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                String aFrom = textFrom.getText();
                if (aFrom != null) {
                    this.oldVal = aFrom;
                }
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                if (!this.oldVal.equals(textFrom.getText())) {
                    long newTime = 0L;
                    try {
                        ITmfTimestamp fromTime;
                        newTime = ExecutionComparisonView.this.fFormat.parseValue(textFrom.getText());
                        ExecutionComparisonView.this.fStartTimeA = fromTime = TmfTimestamp.fromNanos((long)newTime);
                        textFrom.setText(ExecutionComparisonView.this.fStartTimeA.toString(ExecutionComparisonView.this.fFormat));
                        ExecutionComparisonView.this.updateSelectedRange();
                        chartViewer.selectionRangeUpdated(new TmfSelectionRangeUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeA, ExecutionComparisonView.this.fEndTimeA, ExecutionComparisonView.this.getTrace()));
                    }
                    catch (ParseException e1) {
                        textFrom.setText(this.oldVal);
                        e1.printStackTrace();
                    }
                }
            }
        });
        textFrom.setText(this.fStartTimeA.toString(this.fFormat));
        panelFrom.add(labelAFrom);
        panelFrom.add(textFrom);
        this.ftextAFrom = textFrom;
    }

    private void createLabelFromB(Frame frameFrom, Panel panelFrom, final JFormattedTextField textFrom, Color backgroundColor, Color foregroundColor, final TmfXYChartViewer chartViewer) {
        frameFrom.add(panelFrom);
        JLabel labelBFrom = new JLabel();
        labelBFrom.setText(Messages.multipleDensityViewFrom);
        panelFrom.setBackground(backgroundColor);
        textFrom.setBackground(backgroundColor);
        labelBFrom.setBackground(backgroundColor);
        textFrom.setForeground(foregroundColor);
        labelBFrom.setForeground(foregroundColor);
        textFrom.addFocusListener(new java.awt.event.FocusListener(){
            private String oldVal = "";

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                String bFrom = textFrom.getText();
                if (bFrom != null) {
                    this.oldVal = bFrom;
                }
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                if (!this.oldVal.equals(textFrom.getText())) {
                    long newTime = 0L;
                    try {
                        ITmfTimestamp fromTime;
                        newTime = ExecutionComparisonView.this.fFormat.parseValue(textFrom.getText());
                        ExecutionComparisonView.this.fStartTimeB = fromTime = TmfTimestamp.fromNanos((long)newTime);
                        textFrom.setText(ExecutionComparisonView.this.fStartTimeB.toString(ExecutionComparisonView.this.fFormat));
                        ExecutionComparisonView.this.updateSelectedRange();
                        chartViewer.selectionRangeUpdated(new TmfSelectionRangeUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeB, ExecutionComparisonView.this.fEndTimeB, ExecutionComparisonView.this.getTrace()));
                    }
                    catch (ParseException e1) {
                        textFrom.setText(this.oldVal);
                        e1.printStackTrace();
                    }
                }
            }
        });
        textFrom.setText(this.fStartTimeB.toString(this.fFormat));
        panelFrom.add(labelBFrom);
        panelFrom.add(textFrom);
        this.ftextBFrom = textFrom;
    }

    private void createLabelToA(Frame frameTo, Panel panelTo, final JFormattedTextField textTo, Color backgroundColor, Color foregroundColor, final TmfXYChartViewer chartViewer) {
        frameTo.add(panelTo);
        JLabel labelATo = new JLabel();
        labelATo.setText(Messages.multipleDensityViewTo);
        panelTo.setBackground(backgroundColor);
        textTo.setBackground(backgroundColor);
        labelATo.setBackground(backgroundColor);
        textTo.setForeground(foregroundColor);
        labelATo.setForeground(foregroundColor);
        textTo.addFocusListener(new java.awt.event.FocusListener(){
            private String oldVal = "";

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                String aTo = textTo.getText();
                if (aTo != null) {
                    this.oldVal = aTo;
                }
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                if (!this.oldVal.equals(textTo.getText())) {
                    long newTime = 0L;
                    try {
                        ITmfTimestamp fromTime;
                        newTime = ExecutionComparisonView.this.fFormat.parseValue(textTo.getText());
                        ExecutionComparisonView.this.fEndTimeA = fromTime = TmfTimestamp.fromNanos((long)newTime);
                        textTo.setText(ExecutionComparisonView.this.fEndTimeA.toString(ExecutionComparisonView.this.fFormat));
                        ExecutionComparisonView.this.updateSelectedRange();
                        chartViewer.selectionRangeUpdated(new TmfSelectionRangeUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeA, ExecutionComparisonView.this.fEndTimeA, ExecutionComparisonView.this.getTrace()));
                    }
                    catch (ParseException e1) {
                        textTo.setText(this.oldVal);
                        e1.printStackTrace();
                    }
                }
            }
        });
        textTo.setText(this.fEndTimeA.toString(this.fFormat));
        panelTo.add(labelATo);
        panelTo.add(textTo);
        this.ftextATo = textTo;
    }

    private void createLabelToB(Frame frameTo, Panel panelTo, final JFormattedTextField textTo, Color backgroundColor, Color foregroundColor, final TmfXYChartViewer chartViewer) {
        frameTo.add(panelTo);
        JLabel labelBTo = new JLabel();
        labelBTo.setText(Messages.multipleDensityViewTo);
        panelTo.setBackground(backgroundColor);
        textTo.setBackground(backgroundColor);
        labelBTo.setBackground(backgroundColor);
        textTo.setForeground(foregroundColor);
        labelBTo.setForeground(foregroundColor);
        textTo.addFocusListener(new java.awt.event.FocusListener(){
            public @Nullable String oldVal = null;

            @Override
            public void focusGained(@Nullable FocusEvent e) {
                this.oldVal = textTo.getText();
            }

            @Override
            public void focusLost(@Nullable FocusEvent e) {
                if (this.oldVal != null && !this.oldVal.equals(textTo.getText())) {
                    long newTime = 0L;
                    try {
                        ITmfTimestamp fromTime;
                        newTime = ExecutionComparisonView.this.fFormat.parseValue(textTo.getText());
                        ExecutionComparisonView.this.fEndTimeB = fromTime = TmfTimestamp.fromNanos((long)newTime);
                        textTo.setText(ExecutionComparisonView.this.fEndTimeB.toString(ExecutionComparisonView.this.fFormat));
                        ExecutionComparisonView.this.updateSelectedRange();
                        chartViewer.selectionRangeUpdated(new TmfSelectionRangeUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeA, ExecutionComparisonView.this.fEndTimeA, ExecutionComparisonView.this.getTrace()));
                    }
                    catch (ParseException e1) {
                        textTo.setText(this.oldVal);
                        e1.printStackTrace();
                    }
                }
            }
        });
        textTo.setText(this.fEndTimeB.toString(this.fFormat));
        panelTo.add(labelBTo);
        panelTo.add(textTo);
        this.ftextBTo = textTo;
    }

    private void createControlPaintListenerA(final TmfXYChartViewer chartViewer, final SashForm sashFormLeftChildA) {
        chartViewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(@Nullable PaintEvent e) {
                Listener sashDragListener = ExecutionComparisonView.this.fSashDragListener;
                if (sashDragListener == null) {
                    Control[] controlArray = sashFormLeftChildA.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            ExecutionComparisonView.this.fSashDragListener = sashDragListener = event -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal((Object)sashFormLeftChildA, ExecutionComparisonView.this.getTimeViewAlignmentInfo(chartViewer, sashFormLeftChildA)));
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, sashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void createControlPaintListenerB(final TmfXYChartViewer chartViewer, final SashForm sashFormLeftChildB) {
        chartViewer.getControl().addPaintListener(new PaintListener(){

            public void paintControl(@Nullable PaintEvent e) {
                Listener sashDragListener = ExecutionComparisonView.this.fSashDragListener;
                if (sashDragListener == null) {
                    Control[] controlArray = sashFormLeftChildB.getChildren();
                    int n = controlArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Control control = controlArray[n2];
                        if (control instanceof Sash) {
                            ExecutionComparisonView.this.fSashDragListener = sashDragListener = event -> TmfSignalManager.dispatchSignal((TmfSignal)new TmfTimeViewAlignmentSignal((Object)sashFormLeftChildB, ExecutionComparisonView.this.getTimeViewAlignmentInfo(chartViewer, sashFormLeftChildB)));
                            control.removePaintListener((PaintListener)this);
                            control.addListener(13, sashDragListener);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void addTextFocusListener(Text text, final TmfXYChartViewer chartViewerA, final TmfXYChartViewer chartViewerB, final TmfViewer tmfViewerA, final TmfViewer tmfViewerB) {
        text.addFocusListener(new FocusListener(){

            public void focusGained(@Nullable org.eclipse.swt.events.FocusEvent e) {
            }

            public void focusLost(@Nullable org.eclipse.swt.events.FocusEvent e) {
                if (ExecutionComparisonView.this.ftextQuery != null) {
                    String query = ExecutionComparisonView.this.ftextQuery.getText();
                    if (query == null) {
                        return;
                    }
                    boolean parsed = ExecutionComparisonView.this.parseComparisonQuery(query);
                    if (parsed) {
                        chartViewerA.selectionRangeUpdated(new TmfSelectionRangeUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeA, ExecutionComparisonView.this.fEndTimeA, ExecutionComparisonView.this.getTrace()));
                        chartViewerB.selectionRangeUpdated(new TmfSelectionRangeUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeB, ExecutionComparisonView.this.fEndTimeB, ExecutionComparisonView.this.getTrace()));
                        List<ITmfTreeViewerEntry> treeWholeElements = ((MultipleEventDensityViewer)chartViewerA).getWholeCheckedItems();
                        List<ITmfTreeViewerEntry> treeCheckedElements = ExecutionComparisonView.this.updateCheckedElements(treeWholeElements, true);
                        ExecutionComparisonView.this.setCheckedElements(chartViewerA, tmfViewerA, treeCheckedElements, true);
                        treeWholeElements = ((MultipleEventDensityViewer)chartViewerB).getWholeCheckedItems();
                        treeCheckedElements = ExecutionComparisonView.this.updateCheckedElements(treeWholeElements, false);
                        ExecutionComparisonView.this.setCheckedElements(chartViewerB, tmfViewerB, treeCheckedElements, true);
                        TmfComparisonFilteringUpdatedSignal rangUpdateSignal = new TmfComparisonFilteringUpdatedSignal((Object)this, ExecutionComparisonView.this.fStartTimeA, ExecutionComparisonView.this.fEndTimeA, ExecutionComparisonView.this.fStartTimeB, ExecutionComparisonView.this.fEndTimeB, ExecutionComparisonView.this.fStatistic, ExecutionComparisonView.this.fTraceListA, ExecutionComparisonView.this.fTraceListB);
                        TmfSignalManager.dispatchSignal((TmfSignal)rangUpdateSignal);
                        ExecutionComparisonView.this.buildDifferentialFlameGraph();
                    }
                }
            }
        });
    }

    private List<ITmfTreeViewerEntry> updateCheckedElements(List<ITmfTreeViewerEntry> treeWholeElements, boolean isGroupA) {
        ArrayList<ITmfTreeViewerEntry> treeCheckedElements = new ArrayList<ITmfTreeViewerEntry>();
        if (isGroupA) {
            for (ITmfTreeViewerEntry trace : treeWholeElements) {
                if (!this.fTraceListA.contains(trace.getName())) continue;
                treeCheckedElements.add(trace);
                treeCheckedElements.addAll(trace.getChildren());
            }
        } else {
            for (ITmfTreeViewerEntry trace : treeWholeElements) {
                if (!this.fTraceListB.contains(trace.getName())) continue;
                treeCheckedElements.add(trace);
                treeCheckedElements.addAll(trace.getChildren());
            }
        }
        return treeCheckedElements;
    }

    private static void createExpandBarListener(ExpandBar bar, final Composite queryText, final SashForm sashForm) {
        bar.addExpandListener(new ExpandListener(){

            public void itemExpanded(@Nullable ExpandEvent e) {
                Display.getCurrent().asyncExec(() -> {
                    queryText.pack(true);
                    sashForm.setWeights(DEFAULT_WEIGHTS_ShowQuery);
                });
            }

            public void itemCollapsed(@Nullable ExpandEvent e) {
                Display.getCurrent().asyncExec(() -> {
                    queryText.pack(true);
                    sashForm.setWeights(DEFAULT_WEIGHTS_HideQuery);
                });
            }
        });
    }

    public TmfTimeViewAlignmentInfo getTimeViewAlignmentInfo(TmfXYChartViewer chartViewer, SashForm sashFormLeftChild) {
        return new TmfTimeViewAlignmentInfo(chartViewer.getControl().getShell(), sashFormLeftChild.toDisplay(0, 0), ExecutionComparisonView.getTimeAxisOffset(chartViewer, sashFormLeftChild));
    }

    private static int getTimeAxisOffset(TmfXYChartViewer chartViewer, SashForm sashFormLeftChild) {
        return sashFormLeftChild.getChildren()[0].getSize().x + sashFormLeftChild.getSashWidth() + chartViewer.getPointAreaOffset();
    }

    @Override
    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        super.traceSelected(signal);
        if (this.fTmfViewerA instanceof TmfTimeViewer) {
            ((TmfTimeViewer)this.fTmfViewerA).traceSelected(signal);
        }
        if (this.fChartViewerA != null) {
            this.fChartViewerA.traceSelected(signal);
        }
        if (this.fTmfViewerB instanceof TmfTimeViewer) {
            ((TmfTimeViewer)this.fTmfViewerB).traceSelected(signal);
        }
        if (this.fChartViewerB != null) {
            this.fChartViewerB.traceSelected(signal);
        }
        ITmfTrace trace = signal.getTrace();
        this.fStartTimeA = trace.getStartTime();
        this.fEndTimeA = trace.getEndTime();
        this.fStartTimeB = trace.getStartTime();
        this.fEndTimeB = trace.getEndTime();
        this.ftextAFrom.setText(this.fStartTimeA.toString(this.fFormat));
        this.ftextBFrom.setText(this.fStartTimeB.toString(this.fFormat));
        this.ftextATo.setText(this.fEndTimeA.toString(this.fFormat));
        this.ftextBTo.setText(this.fEndTimeB.toString(this.fFormat));
        TmfComparisonFilteringUpdatedSignal rangUpdateSignal = new TmfComparisonFilteringUpdatedSignal((Object)this, this.fStartTimeA, this.fEndTimeA, this.fStartTimeB, this.fEndTimeB, this.fStatistic, this.fTraceListA, this.fTraceListB);
        TmfSignalManager.dispatchSignal((TmfSignal)rangUpdateSignal);
        if (this.ftextQuery != null) {
            this.ftextQuery.setText(this.buildComparisonQuery());
        }
        this.buildDifferentialFlameGraph();
    }

    private Action createStatisticAction(final String name) {
        return new Action(name, 8){

            public void run() {
                ITmfTrace trace = ExecutionComparisonView.this.getTrace();
                if (trace == null) {
                    return;
                }
                ExecutionComparisonView.this.fStatistic = name;
                TmfComparisonFilteringUpdatedSignal rangUpdateSignal = new TmfComparisonFilteringUpdatedSignal((Object)this, ExecutionComparisonView.this.fStatistic, null, null);
                TmfSignalManager.dispatchSignal((TmfSignal)rangUpdateSignal);
                if (ExecutionComparisonView.this.ftextQuery != null) {
                    ExecutionComparisonView.this.ftextQuery.setText(ExecutionComparisonView.this.buildComparisonQuery());
                }
                ExecutionComparisonView.this.buildDifferentialFlameGraph();
            }
        };
    }

    @TmfSignalHandler
    public void traceOpened(TmfTraceOpenedSignal signal) {
        if (this.fChartViewerA != null) {
            this.fChartViewerA.traceOpened(signal);
        }
        if (this.fChartViewerB != null) {
            this.fChartViewerB.traceOpened(signal);
        }
    }

    private void buildDifferentialFlameGraph() {
        ITmfTrace activetrace = TmfTraceManager.getInstance().getActiveTrace();
        if (activetrace != null) {
            Display.getDefault().asyncExec(() -> this.buildFlameGraph(activetrace, null, null));
        }
    }

    public TmfViewer createLeftChildViewer(Composite parent) {
        EventDensityTreeViewer histogramTreeViewer = new EventDensityTreeViewer(parent);
        ITmfTrace trace = TmfTraceManager.getInstance().getActiveTrace();
        if (trace != null) {
            histogramTreeViewer.traceSelected(new TmfTraceSelectedSignal((Object)this, trace));
        }
        return histogramTreeViewer;
    }

    private TmfXYChartViewer createChartViewer(Composite parent) {
        final MultipleEventDensityViewer chartViewer = new MultipleEventDensityViewer(parent, new TmfXYChartSettings(null, null, Y_AXIS_LABEL, 1.0));
        chartViewer.setSendTimeAlignSignals(true);
        chartViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        chartViewer.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(@Nullable MouseEvent e) {
                super.mouseDoubleClick(e);
                ExecutionComparisonView.this.resetStartFinishTime(true, (TmfXYChartViewer)chartViewer);
            }
        });
        chartViewer.getControl().addFocusListener(new FocusListener(){

            public void focusLost(@Nullable org.eclipse.swt.events.FocusEvent e) {
                ExecutionComparisonView.this.deactivateContextService();
            }

            public void focusGained(@Nullable org.eclipse.swt.events.FocusEvent e) {
                ExecutionComparisonView.this.activateContextService();
            }
        });
        return chartViewer;
    }

    public void setCheckedElements(TmfXYChartViewer chart, TmfViewer tree, List<ITmfTreeViewerEntry> treeCheckedElements, boolean queryUpdate) {
        if (queryUpdate) {
            ((MultipleEventDensityViewer)chart).updateCheckStateChangedEvent(treeCheckedElements);
        } else {
            ((MultipleEventDensityViewer)chart).handleCheckStateChangedEvent(treeCheckedElements);
        }
        Object[] treeCheckedElementsObj = new Object[treeCheckedElements.size()];
        treeCheckedElements.toArray(treeCheckedElementsObj);
        ((AbstractSelectTreeViewer2)tree).getTriStateFilteredCheckboxTree().setCheckedElements(treeCheckedElementsObj);
    }

    public void resetStartFinishTime(boolean notify, TmfXYChartViewer chart) {
        if (notify) {
            TmfWindowRangeUpdatedSignal signal = new TmfWindowRangeUpdatedSignal((Object)this, TmfTimeRange.ETERNITY, this.getTrace());
            this.broadcast((TmfSignal)signal);
        }
    }

    private void deactivateContextService() {
        if (this.fContextService != null) {
            this.fContextService.deactivateContexts(this.fActiveContexts);
            this.fActiveContexts.clear();
        }
    }

    private void activateContextService() {
        if (this.fActiveContexts.isEmpty() && this.fContextService != null) {
            IContextActivation activateContext = this.fContextService.activateContext(TMF_VIEW_UI_CONTEXT);
            Objects.requireNonNull(activateContext);
            this.fActiveContexts.add(activateContext);
        }
    }

    private static void coupleSelectViewer(TmfViewer tree, TmfXYChartViewer chart) {
        if (tree instanceof AbstractSelectTreeViewer2 && chart instanceof TmfFilteredXYChartViewer) {
            AbstractSelectTreeViewer2 selectTree = (AbstractSelectTreeViewer2)tree;
            XYChartLegendImageProvider legendImageProvider = new XYChartLegendImageProvider((TmfCommonXAxisChartViewer)chart);
            selectTree.addTreeListener((ICheckboxTreeViewerListener)((TmfFilteredXYChartViewer)chart));
            selectTree.setLegendImageProvider((ILegendImageProvider2)legendImageProvider);
            TriStateFilteredCheckboxTree checkboxTree = selectTree.getTriStateFilteredCheckboxTree();
            checkboxTree.addPreCheckStateListener((IPreCheckStateListener)new ManyEntriesSelectedDialogPreCheckedListener((FilteredCheckboxTree)checkboxTree));
        }
    }

    @TmfSignalHandler
    public void selectionRangeUpdated(TmfSelectionRangeUpdatedSignal signal) {
        Object source = signal.getSource();
        if (source == this.fChartViewerA) {
            this.fStartTimeA = signal.getBeginTime();
            this.fEndTimeA = signal.getEndTime();
            this.ftextAFrom.setText(this.fStartTimeA.toString(this.fFormat));
            this.ftextATo.setText(this.fEndTimeA.toString(this.fFormat));
        } else if (source == this.fChartViewerB) {
            this.fStartTimeB = signal.getBeginTime();
            this.fEndTimeB = signal.getEndTime();
            this.ftextBFrom.setText(this.fStartTimeB.toString(this.fFormat));
            this.ftextBTo.setText(this.fEndTimeB.toString(this.fFormat));
        }
        this.updateSelectedRange();
    }

    public void updateSelectedRange() {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "MultiDensityView::SelectionRangeUpdated", new Object[0]);){
            TmfComparisonFilteringUpdatedSignal rangUpdateSignal = new TmfComparisonFilteringUpdatedSignal((Object)this, this.fStartTimeA, this.fEndTimeA, this.fStartTimeB, this.fEndTimeB, null, null, null);
            TmfSignalManager.dispatchSignal((TmfSignal)rangUpdateSignal);
            Display.getDefault().syncExec(() -> {
                if (this.ftextQuery != null) {
                    this.ftextQuery.setText(this.buildComparisonQuery());
                }
            });
            this.buildDifferentialFlameGraph();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public String getStatisticType() {
        return this.fStatistic;
    }

    private Action getAggregateByAction() {
        Action configureStatisticAction = new Action(Messages.flameGraphViewGroupByName, 4){};
        configureStatisticAction.setToolTipText(Messages.flameGraphViewStatisticTooltip);
        configureStatisticAction.setMenuCreator(new IMenuCreator(){
            @Nullable Menu menu = null;

            public void dispose() {
                if (this.menu != null) {
                    this.menu.dispose();
                    this.menu = null;
                }
            }

            public @Nullable Menu getMenu(@Nullable Control parent) {
                return null;
            }

            public @Nullable Menu getMenu(@Nullable Menu parent) {
                this.menu = new Menu(parent);
                Action statisticActionDur = ExecutionComparisonView.this.createStatisticAction(Objects.requireNonNull(Messages.multipleDensityViewDuration));
                new ActionContributionItem((IAction)statisticActionDur).fill(this.menu, -1);
                Action statisticActionSelf = ExecutionComparisonView.this.createStatisticAction(Objects.requireNonNull(Messages.multipleDensityViewSelfTime));
                new ActionContributionItem((IAction)statisticActionSelf).fill(this.menu, -1);
                return this.menu;
            }
        });
        return Objects.requireNonNull(configureStatisticAction);
    }

    @TmfSignalHandler
    public void checkBoxUpdated(TmfCheckboxChangedSignal signal) {
        Throwable throwable = null;
        Object var3_4 = null;
        try (TraceCompassLogUtils.ScopeLog sl = new TraceCompassLogUtils.ScopeLog(LOGGER, Level.FINE, "MultiDensityView::CheckBoxUpdated", new Object[0]);){
            TmfComparisonFilteringUpdatedSignal rangUpdateSignal = null;
            if (signal.getSource() == this.fChartViewerA) {
                this.fTraceListA.clear();
                for (String name : signal.getTraceList()) {
                    this.fTraceListA.add(name);
                }
                rangUpdateSignal = new TmfComparisonFilteringUpdatedSignal((Object)this, null, this.fTraceListA, null);
                TmfSignalManager.dispatchSignal((TmfSignal)rangUpdateSignal);
            }
            if (signal.getSource() == this.fChartViewerB) {
                this.fTraceListB.clear();
                for (String name : signal.getTraceList()) {
                    this.fTraceListB.add(name);
                }
                rangUpdateSignal = new TmfComparisonFilteringUpdatedSignal((Object)this, null, null, this.fTraceListB);
                TmfSignalManager.dispatchSignal((TmfSignal)rangUpdateSignal);
            }
            if (this.ftextQuery != null) {
                this.ftextQuery.setText(this.buildComparisonQuery());
            }
            this.buildDifferentialFlameGraph();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void handleCheckStateChangedEvent(Collection<ITmfTreeViewerEntry> entries) {
    }

    public void dispose() {
        super.dispose();
        TmfSignalManager.deregister((Object)((Object)this));
        if (this.fChartViewerA != null) {
            this.fChartViewerA.dispose();
        }
        if (this.fTmfViewerA != null) {
            this.fTmfViewerA.dispose();
        }
        if (this.fChartViewerB != null) {
            this.fChartViewerB.dispose();
        }
        if (this.fTmfViewerB != null) {
            this.fTmfViewerB.dispose();
        }
        if (this.fXYViewerContainerA != null) {
            this.fXYViewerContainerA.dispose();
        }
        if (this.fXYViewerContainerB != null) {
            this.fXYViewerContainerB.dispose();
        }
        if (this.fContextService != null) {
            this.fContextService.dispose();
        }
        if (this.fSashFormLeftChildA != null) {
            this.fSashFormLeftChildA.dispose();
        }
        if (this.fSashFormLeftChildB != null) {
            this.fSashFormLeftChildB.dispose();
        }
        if (this.fsashForm != null) {
            this.fsashForm.dispose();
        }
    }

    private String buildComparisonQuery() {
        StringBuilder query = new StringBuilder();
        query.append(TRACE_NAME);
        for (String trace : this.fTraceListA) {
            if (trace.equals("Total")) continue;
            query.append(trace);
            query.append(",");
        }
        query.append(System.lineSeparator());
        query.append(Messages.multipleDensityViewFrom);
        query.append(this.fStartTimeA.toString(this.fFormat));
        query.append(System.lineSeparator());
        query.append(Messages.multipleDensityViewTo);
        query.append(this.fEndTimeA.toString(this.fFormat));
        query.append(System.lineSeparator());
        query.append(Messages.multipleDensityViewQueryCompare);
        query.append(System.lineSeparator());
        query.append(TRACE_NAME);
        for (String trace : this.fTraceListB) {
            if (trace.equals("Total")) continue;
            query.append(trace);
            query.append(",");
        }
        query.append(System.lineSeparator());
        query.append(Messages.multipleDensityViewFrom);
        query.append(this.fStartTimeB.toString(this.fFormat));
        query.append(System.lineSeparator());
        query.append(Messages.multipleDensityViewTo);
        query.append(this.fEndTimeB.toString(this.fFormat));
        query.append(System.lineSeparator());
        query.append(STATISTIC_NAME);
        query.append(this.fStatistic);
        return query.toString();
    }

    boolean parseComparisonQuery(String query) {
        block7: {
            String[] parts;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                try {
                                    String lineSeparator = System.lineSeparator();
                                    if (lineSeparator == null) break block7;
                                    parts = query.split(lineSeparator);
                                    if (parts[1].indexOf(Messages.multipleDensityViewFrom) != -1) break block8;
                                    return false;
                                }
                                catch (ParseException e) {
                                    e.printStackTrace();
                                    return false;
                                }
                            }
                            String fromStrA = parts[1].substring(parts[1].indexOf(Messages.multipleDensityViewFrom) + Messages.multipleDensityViewFrom.length(), parts[1].length());
                            this.fStartTimeA = TmfTimestamp.fromNanos((long)this.fFormat.parseValue(fromStrA));
                            if (parts[2].indexOf(Messages.multipleDensityViewTo) != -1) break block9;
                            return false;
                        }
                        String toStrA = parts[2].substring(parts[2].indexOf(Messages.multipleDensityViewTo) + Messages.multipleDensityViewTo.length(), parts[2].length());
                        this.fEndTimeA = TmfTimestamp.fromNanos((long)this.fFormat.parseValue(toStrA));
                        if (parts[5].indexOf(Messages.multipleDensityViewFrom) != -1) break block10;
                        return false;
                    }
                    String fromStrB = parts[5].substring(parts[5].indexOf(Messages.multipleDensityViewFrom) + Messages.multipleDensityViewFrom.length(), parts[5].length());
                    this.fStartTimeB = TmfTimestamp.fromNanos((long)this.fFormat.parseValue(fromStrB));
                    if (parts[6].indexOf(Messages.multipleDensityViewTo) != -1) break block11;
                    return false;
                }
                String toStrB = parts[6].substring(parts[6].indexOf(Messages.multipleDensityViewTo) + Messages.multipleDensityViewTo.length(), parts[6].length());
                this.fEndTimeB = TmfTimestamp.fromNanos((long)this.fFormat.parseValue(toStrB));
                if (parts[0].indexOf(TRACE_NAME) != -1) break block12;
                return false;
            }
            String traceStrtA = parts[0].substring(parts[0].indexOf(TRACE_NAME) + TRACE_NAME.length(), parts[0].length());
            String[] traces = traceStrtA.split(",");
            ExecutionComparisonView.parseAndAddTraces(this.fTraceListA, traces);
            String traceStrtB = parts[4].substring(parts[4].indexOf(TRACE_NAME) + TRACE_NAME.length(), parts[4].length());
            String[] tracesB = traceStrtB.split(",");
            ExecutionComparisonView.parseAndAddTraces(this.fTraceListB, tracesB);
            this.fStatistic = parts[7].substring(parts[7].indexOf(STATISTIC_NAME) + STATISTIC_NAME.length(), parts[7].length());
            this.ftextAFrom.setText(this.fStartTimeA.toString(this.fFormat));
            this.ftextATo.setText(this.fEndTimeA.toString(this.fFormat));
            this.ftextBFrom.setText(this.fStartTimeB.toString(this.fFormat));
            this.ftextBTo.setText(this.fEndTimeB.toString(this.fFormat));
        }
        return true;
    }

    private static void parseAndAddTraces(List<String> fTraceList, String[] traces) {
        fTraceList.clear();
        String[] stringArray = traces;
        int n = traces.length;
        int n2 = 0;
        while (n2 < n) {
            String trace = stringArray[n2];
            if (trace != null) {
                fTraceList.add(trace);
            }
            ++n2;
        }
    }
}

