/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime;

import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenRuntimeData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioHistoryBuilder;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;

public class DataDrivenScenario {
    private final IAnalysisDataContainer fContainer;
    private final DataDrivenFsm fFsm;
    private DataDrivenScenarioInfo fScenarioInfo;
    DataDrivenScenarioHistoryBuilder fHistoryBuilder;

    public DataDrivenScenario(ITmfEvent event, DataDrivenFsm fsm, DataDrivenFsmState initialState, IAnalysisDataContainer container, DataDrivenRuntimeData executionData) {
        this.fFsm = fsm;
        this.fContainer = container;
        this.fHistoryBuilder = executionData.getHistoryBuilder();
        int quark = this.fHistoryBuilder.assignScenarioQuark(this.fContainer, fsm);
        int statusQuark = this.fHistoryBuilder.getScenarioStatusQuark(this.fContainer, quark);
        this.fScenarioInfo = new DataDrivenScenarioInfo(initialState, DataDrivenScenarioHistoryBuilder.ScenarioStatusType.PENDING, quark, statusQuark, this.fFsm);
        this.fHistoryBuilder.update(this.fContainer, this.fScenarioInfo, event);
    }

    public DataDrivenScenarioInfo getScenarioInfos() {
        return this.fScenarioInfo;
    }

    public void cancel() {
        this.fScenarioInfo.setStatus(DataDrivenScenarioHistoryBuilder.ScenarioStatusType.ABANDONED);
        if (this.fScenarioInfo.getStatus() != DataDrivenScenarioHistoryBuilder.ScenarioStatusType.PENDING) {
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, null);
        }
    }

    public boolean isActive() {
        return this.fScenarioInfo.getStatus() == DataDrivenScenarioHistoryBuilder.ScenarioStatusType.IN_PROGRESS;
    }

    public boolean isPending() {
        return this.fScenarioInfo.getStatus() == DataDrivenScenarioHistoryBuilder.ScenarioStatusType.PENDING;
    }

    public boolean handleEvent(ITmfEvent event, IAnalysisDataContainer container) {
        DataDrivenFsmState activeState = this.fScenarioInfo.getActiveState();
        DataDrivenFsmState nextState = activeState.takeTransition(event, this.fScenarioInfo, container);
        if (nextState == null) {
            return false;
        }
        if (this.fScenarioInfo.getStatus().equals((Object)DataDrivenScenarioHistoryBuilder.ScenarioStatusType.PENDING)) {
            this.fScenarioInfo.setStatus(DataDrivenScenarioHistoryBuilder.ScenarioStatusType.IN_PROGRESS);
            this.fHistoryBuilder.startScenario(this.fContainer, this.fScenarioInfo, event);
        }
        if (nextState.isFinal()) {
            this.fScenarioInfo.setStatus(DataDrivenScenarioHistoryBuilder.ScenarioStatusType.MATCHED);
            this.fHistoryBuilder.completeScenario(this.fContainer, this.fScenarioInfo, event);
        }
        this.fScenarioInfo.setActiveState(nextState);
        this.fHistoryBuilder.update(this.fContainer, this.fScenarioInfo, event);
        return true;
    }
}

