/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.AnalysisCompilationData;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.IDataDrivenCompilationUnit;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlActionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlConditionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlFsmStateTransitionCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsm;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmSimpleState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmState;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenFsmStateTransition;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.w3c.dom.Element;

public abstract class TmfXmlFsmStateCu
implements IDataDrivenCompilationUnit {
    private final String fId;

    private TmfXmlFsmStateCu(String id) {
        this.fId = id;
    }

    @Override
    public abstract DataDrivenFsmState generate();

    protected String getId() {
        return this.fId;
    }

    public static @Nullable TmfXmlFsmCu compileFsm(AnalysisCompilationData analysisData, Element element) {
        String id = element.getAttribute("id");
        if (id.isEmpty()) {
            Activator.logError("FSM: The FSM should have a non-empty 'id' parameter");
            return null;
        }
        String consumingStr = element.getAttribute("consuming");
        String multipleInstancesStr = element.getAttribute("multiple");
        boolean consuming = consumingStr.isEmpty() ? true : Boolean.parseBoolean(consumingStr);
        boolean instanceMultipleEnabled = multipleInstancesStr.isEmpty() ? true : Boolean.parseBoolean(multipleInstancesStr);
        HashMap<String, TmfXmlFsmSimpleStateCu> states = new HashMap<String, TmfXmlFsmSimpleStateCu>();
        List<Element> stateElements = TmfXmlUtils.getChildElements(element, "state");
        TmfXmlFsmSimpleStateCu firstState = null;
        for (Element stateElement : stateElements) {
            TmfXmlFsmSimpleStateCu state = TmfXmlFsmStateCu.compileSimpleState(analysisData, stateElement, states, false);
            if (state == null) {
                return null;
            }
            if (firstState != null) continue;
            firstState = state;
        }
        List<Element> finalElements = TmfXmlUtils.getChildElements(element, "final");
        if (!finalElements.isEmpty()) {
            TmfXmlFsmSimpleStateCu state;
            if (finalElements.size() > 1) {
                Activator.logWarning("Fsm " + id + ": there should be only one final state");
            }
            if ((state = TmfXmlFsmStateCu.compileSimpleState(analysisData, finalElements.get(0), states, true)) == null) {
                return null;
            }
        }
        String initialStr = element.getAttribute("initial");
        List<Element> nodesInitialElement = TmfXmlUtils.getChildElements(element, "initial");
        List<Element> nodesInitialStateElement = TmfXmlUtils.getChildElements(element, "initialState");
        TmfXmlFsmStateCu initialStateCu = null;
        if (!nodesInitialStateElement.isEmpty()) {
            if (!initialStr.isEmpty() || !nodesInitialElement.isEmpty()) {
                Activator.logWarning("Fsm " + id + ": the 'initial' attribute was set or an <initial> element was defined. Only one of the 3 should be used. The " + "initialState" + " element will have precedence");
            }
            if ((initialStateCu = TmfXmlFsmStateCu.compileInitialState(analysisData, nodesInitialStateElement.get(0), states)) == null) {
                return null;
            }
        } else if (initialStr.isEmpty() && nodesInitialElement.isEmpty()) {
            if (firstState == null) {
                Activator.logError("FSM " + id + ": No state was defined.");
                return null;
            }
            initialStateCu = firstState;
        } else {
            if (!initialStr.isEmpty() && !nodesInitialElement.isEmpty()) {
                Activator.logWarning("Fsm " + id + ": Both 'initial' attribute and <initial> element were declared. Only the 'initial' attribute will be used");
            }
            if (!initialStr.isEmpty()) {
                initialStateCu = (TmfXmlFsmStateCu)states.get(initialStr);
                if (initialStateCu == null) {
                    Activator.logError("FSM " + id + ": Undefined initial state " + initialStr);
                    return null;
                }
            } else {
                List<Element> transitionElements = TmfXmlUtils.getChildElements(nodesInitialElement.get(0), "transition");
                if (transitionElements.isEmpty()) {
                    Activator.logError("FSM " + id + ": No transition defined for 'initial' element");
                    return null;
                }
                if (transitionElements.size() > 1) {
                    Activator.logWarning("FSM " + id + ": Too many transitions defined for 'initial' element. Only 1 needed");
                }
                if ((initialStateCu = TmfXmlFsmStateTransitionCu.compileInitialTransition(analysisData, transitionElements.get(0), states)) == null) {
                    return null;
                }
            }
        }
        for (Element stateElement : stateElements) {
            TmfXmlFsmSimpleStateCu simpleState = TmfXmlFsmStateCu.getSimpleState(stateElement, states);
            List<TmfXmlFsmStateTransitionCu> transitions = TmfXmlFsmStateCu.compileTransitionElements(analysisData, stateElement, states);
            if (transitions == null) {
                return null;
            }
            if (transitions.isEmpty()) {
                Activator.logWarning("Fsm " + id + ": a state was defined without transition. You may get stuck there");
            }
            simpleState.addTransitions(transitions);
        }
        List<Element> preCondElements = TmfXmlUtils.getChildElements(element, "precondition");
        ArrayList<TmfXmlConditionCu> preConditions = new ArrayList<TmfXmlConditionCu>();
        for (Element preCondElement : preCondElements) {
            TmfXmlConditionCu preCond = TmfXmlFsmStateTransitionCu.compileAsCondition(analysisData, preCondElement);
            if (preCond == null) {
                return null;
            }
            preConditions.add(preCond);
        }
        TmfXmlConditionCu preCondition = TmfXmlConditionCu.createOrCondition(preConditions);
        TmfXmlFsmCu fsm = new TmfXmlFsmCu(id, initialStateCu, states.values(), consuming, instanceMultipleEnabled, preCondition);
        analysisData.addFsm(id, fsm);
        return fsm;
    }

    private static @Nullable List<TmfXmlFsmStateTransitionCu> compileTransitionElements(AnalysisCompilationData analysisData, Element element, Map<String, TmfXmlFsmSimpleStateCu> states) {
        List<Element> childElements = TmfXmlUtils.getChildElements(element, "transition");
        ArrayList<TmfXmlFsmStateTransitionCu> transitions = new ArrayList<TmfXmlFsmStateTransitionCu>();
        for (Element childElement : childElements) {
            TmfXmlFsmStateTransitionCu transition = TmfXmlFsmStateTransitionCu.compile(analysisData, childElement, states);
            if (transition == null) {
                return null;
            }
            transitions.add(transition);
        }
        return transitions;
    }

    private static @Nullable TmfXmlFsmSimpleStateCu compileInitialState(AnalysisCompilationData analysisData, Element element, Map<String, TmfXmlFsmSimpleStateCu> states) {
        List<TmfXmlFsmStateTransitionCu> transitions = TmfXmlFsmStateCu.compileTransitionElements(analysisData, element, states);
        if (transitions == null) {
            return null;
        }
        TmfXmlFsmSimpleStateCu initialState = new TmfXmlFsmSimpleStateCu("initialState", Collections.emptyList(), Collections.emptyList(), null, null);
        initialState.addTransitions(transitions);
        return initialState;
    }

    private static @Nullable TmfXmlFsmSimpleStateCu compileSimpleState(AnalysisCompilationData analysisData, Element element, Map<String, TmfXmlFsmSimpleStateCu> states, boolean isFinalState) {
        TmfXmlFsmSimpleStateCu stateCu;
        String stateId = element.getAttribute("id");
        if (stateId.isEmpty()) {
            Activator.logError("FSM State: The state should have a non-empty 'id' parameter");
            return null;
        }
        TmfXmlFsmStateCu currentStateCu = states.get(stateId);
        if (currentStateCu != null) {
            Activator.logError("FSM State: Redefinition of state " + stateId);
            return null;
        }
        List<Element> elements = TmfXmlUtils.getChildElements(element, "onentry");
        List<Object> onEntryActions = Collections.emptyList();
        if (!elements.isEmpty() && (onEntryActions = TmfXmlFsmStateCu.getActionList(analysisData, elements.get(0))) == null) {
            return null;
        }
        elements = TmfXmlUtils.getChildElements(element, "onexit");
        List<Object> onExitActions = Collections.emptyList();
        if (!elements.isEmpty() && (onExitActions = TmfXmlFsmStateCu.getActionList(analysisData, elements.get(0))) == null) {
            return null;
        }
        if (isFinalState) {
            if (!onExitActions.isEmpty() || !onEntryActions.isEmpty()) {
                Activator.logWarning("FSM State: Final state should not have any onEntry and onExit actions");
            }
            stateCu = new TmfXmlFsmFinalStateCu(stateId);
        } else {
            stateCu = new TmfXmlFsmSimpleStateCu(stateId, onEntryActions, onExitActions, null, null);
        }
        states.put(stateId, stateCu);
        return stateCu;
    }

    private static @Nullable List<TmfXmlActionCu> getActionList(AnalysisCompilationData analysisData, Element element) {
        String[] actionIds;
        ArrayList<TmfXmlActionCu> actions = new ArrayList<TmfXmlActionCu>();
        String onEntryActionStr = element.getAttribute("action");
        if (onEntryActionStr.isEmpty()) {
            return actions;
        }
        String[] stringArray = actionIds = onEntryActionStr.split(":");
        int n = actionIds.length;
        int n2 = 0;
        while (n2 < n) {
            String actionId = stringArray[n2];
            TmfXmlActionCu action = analysisData.getAction(actionId);
            if (action == null) {
                Activator.logError("FSM State: Undefined action " + actionId);
                return null;
            }
            actions.add(action);
            ++n2;
        }
        return actions;
    }

    private static TmfXmlFsmSimpleStateCu getSimpleState(Element stateElement, Map<String, TmfXmlFsmSimpleStateCu> states) {
        String stateId = stateElement.getAttribute("id");
        TmfXmlFsmStateCu state = states.get(stateId);
        if (!(state instanceof TmfXmlFsmSimpleStateCu)) {
            throw new NullPointerException("The requested state is not of the right type: " + stateId);
        }
        return (TmfXmlFsmSimpleStateCu)state;
    }

    /* synthetic */ TmfXmlFsmStateCu(String string, TmfXmlFsmStateCu tmfXmlFsmStateCu) {
        this(string);
    }

    public static class TmfXmlFsmCu
    extends TmfXmlFsmStateCu {
        private final TmfXmlFsmStateCu fInitialState;
        private final Collection<TmfXmlFsmSimpleStateCu> fStates;
        private final TmfXmlConditionCu fPreCondition;
        private final boolean fConsuming;
        private final boolean fMultipleInstances;

        private TmfXmlFsmCu(String id, TmfXmlFsmStateCu initialStateCu, Collection<TmfXmlFsmSimpleStateCu> states, boolean consuming, boolean instanceMultipleEnabled, TmfXmlConditionCu preCondition) {
            super(id, null);
            this.fInitialState = initialStateCu;
            this.fStates = states;
            this.fPreCondition = preCondition;
            this.fConsuming = consuming;
            this.fMultipleInstances = instanceMultipleEnabled;
        }

        @Override
        public DataDrivenFsm generate() {
            Map<String, DataDrivenFsmSimpleState> states = this.fStates.stream().map(TmfXmlFsmSimpleStateCu::generate).collect(Collectors.toMap(DataDrivenFsmState::getId, state -> state));
            return new DataDrivenFsm(this.getId(), this.fInitialState.generate(), states, this.fPreCondition.generate(), this.fConsuming, this.fMultipleInstances);
        }
    }

    private static class TmfXmlFsmFinalStateCu
    extends TmfXmlFsmSimpleStateCu {
        public TmfXmlFsmFinalStateCu(String id) {
            super(id, Collections.emptyList(), Collections.emptyList());
        }

        @Override
        public DataDrivenFsmSimpleState generate() {
            return DataDrivenFsmSimpleState.createFinalState(this.getId());
        }
    }

    static class TmfXmlFsmSimpleStateCu
    extends TmfXmlFsmStateCu {
        private final List<TmfXmlFsmStateTransitionCu> fTransitions = new ArrayList<TmfXmlFsmStateTransitionCu>();
        private final TmfXmlActionCu fOnEntryActions;
        private final TmfXmlActionCu fOnExitActions;

        private TmfXmlFsmSimpleStateCu(String id, List<TmfXmlActionCu> onEntryActions, List<TmfXmlActionCu> onExitActions) {
            super(id, null);
            this.fOnEntryActions = TmfXmlActionCu.createActionList(onEntryActions);
            this.fOnExitActions = TmfXmlActionCu.createActionList(onExitActions);
        }

        private void addTransitions(List<TmfXmlFsmStateTransitionCu> transitions) {
            this.fTransitions.addAll(transitions);
        }

        @Override
        public DataDrivenFsmSimpleState generate() {
            List<DataDrivenFsmStateTransition> transitions = this.fTransitions.stream().map(TmfXmlFsmStateTransitionCu::generate).collect(Collectors.toList());
            return new DataDrivenFsmSimpleState(this.getId(), transitions, this.fOnEntryActions.generate(), this.fOnExitActions.generate());
        }

        /* synthetic */ TmfXmlFsmSimpleStateCu(String string, List list, List list2, TmfXmlFsmSimpleStateCu tmfXmlFsmSimpleStateCu, TmfXmlFsmSimpleStateCu tmfXmlFsmSimpleStateCu2) {
            this(string, list, list2);
        }
    }
}

