/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.io.Closeable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleResolutionReport;
import org.eclipse.osgi.container.ModuleResolver;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.container.SystemModule;
import org.eclipse.osgi.framework.eventmgr.CopyOnWriteIdentityMap;
import org.eclipse.osgi.framework.eventmgr.EventDispatcher;
import org.eclipse.osgi.framework.eventmgr.EventManager;
import org.eclipse.osgi.framework.eventmgr.ListenerQueue;
import org.eclipse.osgi.framework.util.SecureAction;
import org.eclipse.osgi.framework.util.ThreadInfoReport;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.eclipse.osgi.internal.container.LockSet;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.report.resolution.ResolutionReport;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.framework.startlevel.FrameworkStartLevel;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.FrameworkWiring;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;
import org.osgi.resource.Wire;

public final class ModuleContainer
implements DebugOptionsListener {
    private static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private final LockSet<String> locationLocks = new LockSet();
    private final LockSet<String> nameLocks = new LockSet();
    private final ContainerWiring frameworkWiring;
    private final ContainerStartLevel frameworkStartLevel;
    final ModuleDatabase moduleDatabase;
    final ModuleContainerAdaptor adaptor;
    private final ModuleResolver moduleResolver;
    private final AtomicReference<SystemModule> refreshingSystemModule = new AtomicReference();
    private final long moduleLockTimeout;
    private final boolean autoStartOnResolve;
    final boolean restrictParallelStart;
    boolean DEBUG_MONITOR_LAZY = false;
    boolean DEBUG_BUNDLE_START_TIME = false;
    final ResolutionLock _resolutionLock = new ResolutionLock();
    final ReentrantLock _bundleStateLock = new ReentrantLock();

    public ModuleContainer(ModuleContainerAdaptor adaptor, ModuleDatabase moduledataBase) {
        String autoStartOnResolveProp;
        this.adaptor = adaptor;
        this.moduleResolver = new ModuleResolver(adaptor);
        this.moduleDatabase = moduledataBase;
        this.frameworkWiring = new ContainerWiring();
        this.frameworkStartLevel = new ContainerStartLevel();
        long tempModuleLockTimeout = 30L;
        String moduleLockTimeoutProp = adaptor.getProperty("osgi.module.lock.timeout");
        if (moduleLockTimeoutProp != null) {
            try {
                tempModuleLockTimeout = Long.parseLong(moduleLockTimeoutProp);
                if (tempModuleLockTimeout < 1L) {
                    tempModuleLockTimeout = 1L;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        this.moduleLockTimeout = tempModuleLockTimeout;
        DebugOptions debugOptions = adaptor.getDebugOptions();
        if (debugOptions != null) {
            this.DEBUG_MONITOR_LAZY = debugOptions.getBooleanOption("org.eclipse.osgi/monitor/lazy", false);
        }
        if ((autoStartOnResolveProp = adaptor.getProperty("osgi.module.auto.start.on.resolve")) == null) {
            autoStartOnResolveProp = Boolean.toString(true);
        }
        this.autoStartOnResolve = Boolean.parseBoolean(autoStartOnResolveProp);
        this.restrictParallelStart = Boolean.parseBoolean(adaptor.getProperty("equinox.start.level.restrict.parallel"));
    }

    public ModuleContainerAdaptor getAdaptor() {
        return this.adaptor;
    }

    public List<Module> getModules() {
        return this.moduleDatabase.getModules();
    }

    public Module getModule(long id) {
        return this.moduleDatabase.getModule(id);
    }

    public Module getModule(String location) {
        return this.moduleDatabase.getModule(location);
    }

    public static Requirement createRequirement(String namespace, Map<String, String> directives, Map<String, ?> attributes) {
        return new ModuleRequirement(namespace, directives, attributes, null);
    }

    public Module install(Module origin, String location, ModuleRevisionBuilder builder, Object revisionInfo) throws BundleException {
        long id = builder.getId();
        ModuleRevisionBuilder adaptBuilder = this.getAdaptor().adaptModuleRevisionBuilder(ModuleContainerAdaptor.ModuleEvent.INSTALLED, origin, builder, revisionInfo);
        if (adaptBuilder != null) {
            adaptBuilder.setInternalId(id);
            builder = adaptBuilder;
        }
        String name = builder.getSymbolicName();
        boolean locationLocked = false;
        boolean nameLocked = false;
        try {
            try {
                locationLocked = this.locationLocks.tryLock(location, 5L, TimeUnit.SECONDS);
                boolean bl = nameLocked = name != null && this.nameLocks.tryLock(name, 5L, TimeUnit.SECONDS);
                if (!locationLocked) {
                    throw new BundleException("Failed to obtain location lock for installation: " + location, 7, new ThreadInfoReport(this.locationLocks.getLockInfo(location)));
                }
                if (name != null && !nameLocked) {
                    throw new BundleException("Failed to obtain symbolic name lock for installation: " + name, 7, new ThreadInfoReport(this.nameLocks.getLockInfo(name)));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BundleException("Failed to obtain id locks for installation.", 7, e);
            }
            Module existingLocation = null;
            List<Module> collisionCandidates = Collections.emptyList();
            this.moduleDatabase.readLock();
            try {
                List<ModuleCapability> sameIdentity;
                existingLocation = this.moduleDatabase.getModule(location);
                if (existingLocation == null && !(sameIdentity = this.moduleDatabase.findCapabilities(ModuleContainer.getIdentityRequirement(name, builder.getVersion()))).isEmpty()) {
                    collisionCandidates = new ArrayList(1);
                    for (ModuleCapability identity : sameIdentity) {
                        ModuleRevision equinoxRevision = identity.getRevision();
                        if (!equinoxRevision.isCurrent() || collisionCandidates.contains(equinoxRevision.getRevisions().getModule())) continue;
                        collisionCandidates.add(equinoxRevision.getRevisions().getModule());
                    }
                }
            }
            finally {
                this.moduleDatabase.readUnlock();
            }
            if (existingLocation != null) {
                if (origin != null) {
                    BundleContext context;
                    Bundle bundle = origin.getBundle();
                    BundleContext bundleContext = context = bundle == null ? null : bundle.getBundleContext();
                    if (context != null && context.getBundle(existingLocation.getId()) == null) {
                        Bundle b = existingLocation.getBundle();
                        throw new BundleException(NLS.bind(Msg.ModuleContainer_NameCollisionWithLocation, new Object[]{b.getSymbolicName(), b.getVersion(), location}), 12);
                    }
                }
                Module module = existingLocation;
                return module;
            }
            if (origin != null && !collisionCandidates.isEmpty()) {
                this.adaptor.getModuleCollisionHook().filterCollisions(1, origin, collisionCandidates);
            }
            if (!collisionCandidates.isEmpty()) {
                throw new BundleException(NLS.bind(Msg.ModuleContainer_NameCollision, name, builder.getVersion()), 9);
            }
            Module result = this.moduleDatabase.install(location, builder, revisionInfo);
            this.adaptor.publishModuleEvent(ModuleContainerAdaptor.ModuleEvent.INSTALLED, result, origin);
            Module module = result;
            return module;
        }
        finally {
            if (locationLocked) {
                this.locationLocks.unlock(location);
            }
            if (nameLocked) {
                this.nameLocks.unlock(name);
            }
        }
    }

    public void update(Module module, ModuleRevisionBuilder builder, Object revisionInfo) throws BundleException {
        long id = builder.getId();
        ModuleRevisionBuilder adaptBuilder = this.getAdaptor().adaptModuleRevisionBuilder(ModuleContainerAdaptor.ModuleEvent.UPDATED, module, builder, revisionInfo);
        if (adaptBuilder != null) {
            adaptBuilder.setInternalId(id);
            builder = adaptBuilder;
        }
        this.checkAdminPermission(module.getBundle(), "lifecycle");
        String name = builder.getSymbolicName();
        boolean nameLocked = false;
        try {
            Module.State previousState;
            try {
                if (name != null && !(nameLocked = this.nameLocks.tryLock(name, 5L, TimeUnit.SECONDS))) {
                    throw new BundleException("Failed to obtain id locks for installation: " + name, 7, new ThreadInfoReport(this.nameLocks.getLockInfo(name)));
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new BundleException("Failed to obtain id locks for installation.", 7, e);
            }
            List<Module> collisionCandidates = Collections.emptyList();
            this.moduleDatabase.readLock();
            try {
                List<ModuleCapability> sameIdentity = this.moduleDatabase.findCapabilities(ModuleContainer.getIdentityRequirement(name, builder.getVersion()));
                if (!sameIdentity.isEmpty()) {
                    collisionCandidates = new ArrayList(1);
                    for (ModuleCapability identity : sameIdentity) {
                        Module m;
                        ModuleRevision equinoxRevision = identity.getRevision();
                        if (!equinoxRevision.isCurrent() || (m = equinoxRevision.getRevisions().getModule()).equals(module) || collisionCandidates.contains(m)) continue;
                        collisionCandidates.add(m);
                    }
                }
            }
            finally {
                this.moduleDatabase.readUnlock();
            }
            if (module != null && !collisionCandidates.isEmpty()) {
                this.adaptor.getModuleCollisionHook().filterCollisions(2, module, collisionCandidates);
            }
            if (!collisionCandidates.isEmpty()) {
                throw new BundleException(NLS.bind(Msg.ModuleContainer_NameCollision, name, builder.getVersion()), 9);
            }
            module.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UPDATED);
            try {
                module.checkValid();
                previousState = module.getState();
                if (Module.ACTIVE_SET.contains((Object)previousState)) {
                    module.stop(Module.StopOptions.TRANSIENT);
                }
                if (Module.RESOLVED_SET.contains((Object)previousState)) {
                    module.setState(Module.State.INSTALLED);
                    this.adaptor.publishModuleEvent(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, module, module);
                }
                this.moduleDatabase.update(module, builder, revisionInfo);
            }
            finally {
                module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UPDATED);
            }
            this.adaptor.publishModuleEvent(ModuleContainerAdaptor.ModuleEvent.UPDATED, module, module);
            if (Module.ACTIVE_SET.contains((Object)previousState)) {
                try {
                    module.start(Module.StartOptions.TRANSIENT_RESUME);
                }
                catch (BundleException e) {
                    this.getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, new FrameworkListener[0]);
                }
            }
        }
        finally {
            if (nameLocked) {
                this.nameLocks.unlock(name);
            }
        }
    }

    public void uninstall(Module module) throws BundleException {
        this.checkAdminPermission(module.getBundle(), "lifecycle");
        module.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
        try {
            module.checkValid();
            Module.State previousState = module.getState();
            if (Module.ACTIVE_SET.contains((Object)module.getState())) {
                try {
                    module.stop(Module.StopOptions.TRANSIENT);
                }
                catch (BundleException e) {
                    this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, new FrameworkListener[0]);
                }
            }
            if (Module.RESOLVED_SET.contains((Object)previousState)) {
                module.setState(Module.State.INSTALLED);
                this.adaptor.publishModuleEvent(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED, module, module);
            }
            this.moduleDatabase.uninstall(module);
            module.setState(Module.State.UNINSTALLED);
        }
        finally {
            module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
        }
        this.adaptor.publishModuleEvent(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED, module, module);
    }

    ModuleWiring getWiring(ModuleRevision revision) {
        return this.moduleDatabase.getWiring(revision);
    }

    public FrameworkWiring getFrameworkWiring() {
        return this.frameworkWiring;
    }

    public FrameworkStartLevel getFrameworkStartLevel() {
        return this.frameworkStartLevel;
    }

    public ResolutionReport resolve(Collection<Module> triggers, boolean triggersMandatory) {
        return this.resolve(triggers, triggersMandatory, false);
    }

    /*
     * Exception decompiling
     */
    private ResolutionReport resolve(Collection<Module> triggers, boolean triggersMandatory, boolean restartTriggers) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ResolutionReport resolveAndApply(Collection<Module> triggers, boolean triggersMandatory, boolean restartTriggers, ResolutionLock.Permits resolutionPermits) {
        Map<ModuleRevision, ModuleWiring> deltaWiring;
        Map<ModuleRevision, ModuleWiring> wiringClone;
        long timestamp;
        if (triggers == null) {
            triggers = new ArrayList<Module>(0);
        }
        ArrayList<ModuleRevision> triggerRevisions = new ArrayList<ModuleRevision>(triggers.size());
        ArrayList<ModuleRevision> unresolved = new ArrayList<ModuleRevision>();
        this.moduleDatabase.readLock();
        try {
            timestamp = this.moduleDatabase.getRevisionsTimestamp();
            wiringClone = this.moduleDatabase.getWiringsClone();
            for (Module module : triggers) {
                Object current;
                if (Module.State.UNINSTALLED.equals((Object)module.getState()) || (current = module.getCurrentRevision()) == null) continue;
                triggerRevisions.add((ModuleRevision)current);
            }
            List<Module> allModules = this.moduleDatabase.getModules();
            for (Module module : allModules) {
                ModuleRevision revision = module.getCurrentRevision();
                if (revision == null || wiringClone.containsKey(revision)) continue;
                unresolved.add(revision);
            }
        }
        finally {
            this.moduleDatabase.readUnlock();
        }
        ModuleResolutionReport report = this.moduleResolver.resolveDelta(triggerRevisions, triggersMandatory, unresolved, wiringClone, this.moduleDatabase);
        Map<Resource, List<Wire>> resolutionResult = report.getResolutionResult();
        Map<ModuleRevision, ModuleWiring> map = deltaWiring = resolutionResult == null ? Collections.emptyMap() : this.moduleResolver.generateDelta(resolutionResult, wiringClone);
        if (deltaWiring.isEmpty()) {
            return report;
        }
        ArrayList<Module> modulesResolved = new ArrayList<Module>();
        for (ModuleRevision deltaRevision : deltaWiring.keySet()) {
            if (wiringClone.containsKey(deltaRevision)) continue;
            modulesResolved.add(deltaRevision.getRevisions().getModule());
        }
        return this.applyDelta(deltaWiring, modulesResolved, triggers, timestamp, restartTriggers, resolutionPermits) ? report : null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ModuleWire resolveDynamic(String dynamicPkgName, ModuleRevision revision) {
        try {
            Throwable throwable = null;
            Object var9_5 = null;
            try (ResolutionLock.Permits resolutionPermits = this._resolutionLock.acquire(10);){
                ModuleWire result;
                long timestamp;
                ArrayList<Module> modulesResolved;
                Map<ModuleRevision, ModuleWiring> deltaWiring;
                do {
                    ModuleWiring wiring;
                    result = null;
                    Map<ModuleRevision, ModuleWiring> wiringClone = null;
                    List<ModuleRequirement.DynamicModuleRequirement> dynamicReqs = null;
                    ArrayList<ModuleRevision> unresolved = new ArrayList<ModuleRevision>();
                    this.moduleDatabase.readLock();
                    try {
                        ModuleWiring wiring2 = revision.getWiring();
                        if (wiring2 == null) {
                            return null;
                        }
                        if (wiring2.isDynamicPackageMiss(dynamicPkgName)) {
                            return null;
                        }
                        result = this.findExistingDynamicWire(revision.getWiring(), dynamicPkgName);
                        if (result != null) {
                            ModuleWire moduleWire = result;
                            return moduleWire;
                        }
                        dynamicReqs = this.getDynamicRequirements(dynamicPkgName, revision);
                        if (dynamicReqs.isEmpty()) {
                            wiring2.addDynamicPackageMiss(dynamicPkgName);
                            return null;
                        }
                        timestamp = this.moduleDatabase.getRevisionsTimestamp();
                        wiringClone = this.moduleDatabase.getWiringsClone();
                        List<Module> allModules = this.moduleDatabase.getModules();
                        for (Module module : allModules) {
                            ModuleRevision current = module.getCurrentRevision();
                            if (current == null || wiringClone.containsKey(current)) continue;
                            unresolved.add(current);
                        }
                    }
                    finally {
                        this.moduleDatabase.readUnlock();
                    }
                    deltaWiring = null;
                    boolean foundCandidates = false;
                    for (ModuleRequirement.DynamicModuleRequirement dynamicReq : dynamicReqs) {
                        ModuleResolutionReport report = this.moduleResolver.resolveDynamicDelta(dynamicReq, unresolved, wiringClone, this.moduleDatabase);
                        Map<Resource, List<Wire>> resolutionResult = report.getResolutionResult();
                        Map<ModuleRevision, ModuleWiring> map = deltaWiring = resolutionResult == null ? Collections.emptyMap() : this.moduleResolver.generateDelta(resolutionResult, wiringClone);
                        if (deltaWiring.get(revision) != null) break;
                        List<ResolutionReport.Entry> revisionEntries = report.getEntries().get(revision);
                        if (revisionEntries == null || revisionEntries.isEmpty()) {
                            foundCandidates = true;
                            continue;
                        }
                        boolean isMissingCapability = false;
                        for (ResolutionReport.Entry entry : revisionEntries) {
                            isMissingCapability |= ResolutionReport.Entry.Type.MISSING_CAPABILITY.equals((Object)entry.getType());
                        }
                        foundCandidates |= !isMissingCapability;
                    }
                    if (deltaWiring == null || deltaWiring.get(revision) == null) {
                        if (foundCandidates) return null;
                        wiring = revision.getWiring();
                        if (wiring == null) return null;
                        wiring.addDynamicPackageMiss(dynamicPkgName);
                        return null;
                    }
                    modulesResolved = new ArrayList<Module>();
                    for (ModuleRevision deltaRevision : deltaWiring.keySet()) {
                        if (wiringClone.containsKey(deltaRevision)) continue;
                        modulesResolved.add(deltaRevision.getRevisions().getModule());
                    }
                    wiring = (ModuleWiring)deltaWiring.get(revision);
                    result = this.findExistingDynamicWire(wiring, dynamicPkgName);
                } while (!this.applyDelta(deltaWiring, modulesResolved, Collections.emptyList(), timestamp, false, resolutionPermits));
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (ResolutionLockException resolutionLockException) {
            return null;
        }
    }

    private ModuleWire findExistingDynamicWire(ModuleWiring wiring, String dynamicPkgName) {
        if (wiring == null) {
            return null;
        }
        List<ModuleWire> wires = wiring.getRequiredModuleWires("osgi.wiring.package");
        int i = wires.size() - 1;
        while (i >= 0) {
            ModuleWire wire = wires.get(i);
            if (dynamicPkgName.equals(wire.getCapability().getAttributes().get("osgi.wiring.package"))) {
                return wire;
            }
            if (!"dynamic".equals(wire.getRequirement().getDirectives().get("resolution"))) {
                return null;
            }
            --i;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private boolean applyDelta(Map<ModuleRevision, ModuleWiring> deltaWiring, Collection<Module> modulesResolved, Collection<Module> triggers, long timestamp, boolean restartTriggers, ResolutionLock.Permits resolutionPermits) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 1[TRYBLOCK]], but top level block is 17[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void start(Module module, Module.StartOptions ... options) {
        try {
            secureAction.start(module, options);
        }
        catch (BundleException e) {
            if (e.getType() == 7 && Module.ACTIVE_SET.contains((Object)module.getState())) {
                return;
            }
            this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, new FrameworkListener[0]);
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    private List<ModuleRequirement.DynamicModuleRequirement> getDynamicRequirements(String dynamicPkgName, ModuleRevision revision) {
        if ((revision.getTypes() & 1) != 0) {
            return Collections.emptyList();
        }
        ModuleWiring wiring = revision.getWiring();
        if (wiring == null) {
            return Collections.emptyList();
        }
        ArrayList<ModuleRequirement.DynamicModuleRequirement> result = new ArrayList<ModuleRequirement.DynamicModuleRequirement>(1);
        for (ModuleRequirement requirement : wiring.getModuleRequirements("osgi.wiring.package")) {
            ModuleRequirement.DynamicModuleRequirement dynamicRequirement = requirement.getDynamicPackageRequirement(revision, dynamicPkgName);
            if (dynamicRequirement == null) continue;
            result.add(dynamicRequirement);
        }
        if (!result.isEmpty()) {
            for (ModuleCapability capability : wiring.getModuleCapabilities("osgi.wiring.package")) {
                if (!dynamicPkgName.equals(capability.getAttributes().get("osgi.wiring.package"))) continue;
                return Collections.emptyList();
            }
        }
        return result;
    }

    private Collection<Module> unresolve(Collection<Module> initial) {
        Collection<Module> refreshTriggers = null;
        while (refreshTriggers == null) {
            refreshTriggers = this.unresolve0(initial);
        }
        return refreshTriggers;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Collection<Module> unresolve0(Collection<Module> initial) {
        this.moduleDatabase.readLock();
        try {
            this.checkSystemExtensionRefresh(initial);
            timestamp = this.moduleDatabase.getRevisionsTimestamp();
            wiringCopy = this.moduleDatabase.getWiringsCopy();
            refreshTriggers = new ArrayList<Module>(this.getRefreshClosure(initial, wiringCopy));
            toRemoveRevisions = new ArrayList<ModuleRevision>();
            toRemoveWirings = new ArrayList<ModuleWiring>();
            toRemoveWireLists = new HashMap<ModuleWiring, ArrayList<ModuleWire>>();
            iTriggers = refreshTriggers.iterator();
            block18: while (true) {
                if (!iTriggers.hasNext()) {
                    this.moduleDatabase.sortModules(refreshTriggers, new ModuleDatabase.Sort[]{ModuleDatabase.Sort.BY_START_LEVEL, ModuleDatabase.Sort.BY_DEPENDENCY});
                    break;
                }
                module = (Module)iTriggers.next();
                first = true;
                var13_29 = module.getRevisions().getModuleRevisions().iterator();
                while (true) {
                    if (!var13_29.hasNext()) {
                        if (!module.getState().equals((Object)Module.State.UNINSTALLED)) continue block18;
                        iTriggers.remove();
                        continue block18;
                    }
                    var12_12 = var13_29.next();
                    removedWiring = wiringCopy.remove(var12_12);
                    if (removedWiring != null) {
                        toRemoveWirings.add(removedWiring);
                        removedWires = removedWiring.getRequiredModuleWires(null);
                        for (ModuleWire wire : removedWires) {
                            providerWires = (ArrayList<ModuleWire>)toRemoveWireLists.get(wire.getProviderWiring());
                            if (providerWires == null) {
                                providerWires = new ArrayList<ModuleWire>();
                                toRemoveWireLists.put(wire.getProviderWiring(), providerWires);
                            }
                            providerWires.add(wire);
                        }
                    }
                    if (!first || var12_12.getRevisions().isUninstalled()) {
                        toRemoveRevisions.add(var12_12);
                    }
                    first = false;
                }
                break;
            }
        }
        finally {
            this.moduleDatabase.readUnlock();
        }
        systemModule = this.moduleDatabase.getModule(0L);
        if (refreshTriggers.contains(systemModule) && Module.ACTIVE_SET.contains((Object)systemModule.getState())) {
            this.refreshSystemModule();
            return Collections.emptyList();
        }
        modulesLocked = new ArrayList<Module>(refreshTriggers.size());
        modulesUnresolved = new ArrayList<Module>();
        try {
            block43: {
                this._bundleStateLock.lock();
                try {
                    try {
                        var12_13 = refreshTriggers.listIterator(refreshTriggers.size());
                        while (var12_13.hasPrevious()) {
                            refreshModule = (Module)var12_13.previous();
                            refreshModule.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED);
                            modulesLocked.add(refreshModule);
                        }
                    }
                    catch (BundleException var12_14) {
                        throw new IllegalStateException(Msg.ModuleContainer_StateLockError, var12_14);
                    }
                }
                finally {
                    this._bundleStateLock.unlock();
                }
                var12_15 = refreshTriggers.listIterator(refreshTriggers.size());
                while (true) {
                    if (!var12_15.hasPrevious()) break;
                    refreshModule = (Module)var12_15.previous();
                    previousState = refreshModule.getState();
                    if (Module.ACTIVE_SET.contains((Object)previousState)) {
                        try {
                            refreshModule.stop(new Module.StopOptions[]{Module.StopOptions.TRANSIENT});
                        }
                        catch (BundleException e) {
                            this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, refreshModule, e, new FrameworkListener[0]);
                        }
                        continue;
                    }
                    var12_15.remove();
                }
                var13_29 = modulesLocked.iterator();
                do {
                    if (var13_29.hasNext()) continue;
                    this.moduleDatabase.writeLock();
                    ** try [egrp 5[TRYBLOCK] [4 : 736->749)] { 
lbl90:
                    // 1 sources

                    ** GOTO lbl-1000
                } while (!Module.ACTIVE_SET.contains((Object)(var12_17 = (Module)var13_29.next()).getState()));
                throw new IllegalStateException("Module is in the wrong state: " + var12_17 + ": " + (Object)var12_17.getState());
lbl-1000:
                // 1 sources

                {
                    if (timestamp != this.moduleDatabase.getRevisionsTimestamp()) {
                        this.moduleDatabase.writeUnlock();
                    }
                }
lbl96:
                // 1 sources

                catch (Throwable var17_36) {
                    throw var17_36;
                }
                ** try [egrp 7[TRYBLOCK] [5 : 800->1046)] { 
lbl99:
                // 2 sources

                for (Map.Entry var12_19 : toRemoveWireLists.entrySet()) {
                    provided = ((ModuleWiring)var12_19.getKey()).getProvidedModuleWires(null);
                    provided.removeAll((Collection)var12_19.getValue());
                    ((ModuleWiring)var12_19.getKey()).setProvidedWires(provided);
                    for (ModuleWire removedWire : (Collection)var12_19.getValue()) {
                        removedWire.invalidate();
                    }
                }
                var13_29 = toRemoveRevisions.iterator();
                while (true) {
                    if (!var13_29.hasNext()) break;
                    var12_21 = (ModuleRevision)var13_29.next();
                    var12_21.getRevisions().removeRevision(var12_21);
                    this.moduleDatabase.removeCapabilities(var12_21);
                }
                var13_29 = toRemoveWirings.iterator();
                while (true) {
                    if (var13_29.hasNext()) {
                        var12_23 = (ModuleWiring)var13_29.next();
                        var12_23.invalidate();
                        continue;
                    }
                    break block43;
                    break;
                }
lbl123:
                // 1 sources

                finally {
                    this.moduleDatabase.writeUnlock();
                }
            }
            this.moduleDatabase.setWiring(wiringCopy);
            this.moduleDatabase.cleanupRemovalPending();
            var13_29 = modulesLocked.iterator();
            while (true) {
                if (!var13_29.hasNext()) {
                }
                var12_25 = (Module)var13_29.next();
                if (!Module.State.RESOLVED.equals((Object)var12_25.getState())) continue;
                var12_25.setState(Module.State.INSTALLED);
                modulesUnresolved.add(var12_25);
            }
        }
        finally {
            var20_43 = modulesLocked.iterator();
        }
        while (true) {
            if (!var20_43.hasNext()) {
                return null;
            }
            module = (Module)var20_43.next();
            module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED);
        }
    }

    private void checkSystemExtensionRefresh(Collection<Module> initial) {
        if (initial == null) {
            return;
        }
        Long zero = new Long(0L);
        Iterator<Module> iModules = initial.iterator();
        while (iModules.hasNext()) {
            ModuleWiring wiring;
            ModuleRevision current;
            Module m = iModules.next();
            if (m.getId().equals(zero)) {
                if (!Module.ACTIVE_SET.contains((Object)m.getState())) continue;
                iModules.remove();
                continue;
            }
            if (!Module.RESOLVED_SET.contains((Object)m.getState()) || ((current = m.getCurrentRevision()).getTypes() & 1) == 0 || (wiring = current.getWiring()) == null) continue;
            List<ModuleWire> hostWires = wiring.getRequiredModuleWires("osgi.wiring.host");
            for (ModuleWire hostWire : hostWires) {
                if (!hostWire.getProvider().getRevisions().getModule().getId().equals(zero)) continue;
                iModules.remove();
            }
        }
    }

    public ResolutionReport refresh(Collection<Module> initial) {
        initial = initial == null ? null : new ArrayList<Module>(initial);
        Collection<Module> refreshTriggers = this.unresolve(initial);
        if (!this.isRefreshingSystemModule()) {
            return this.resolve(refreshTriggers, false, true);
        }
        return new ModuleResolutionReport(null, null, null);
    }

    public Collection<Module> getDependencyClosure(Collection<Module> initial) {
        this.moduleDatabase.readLock();
        try {
            Set<Module> set = this.getRefreshClosure(initial, this.moduleDatabase.getWiringsCopy());
            return set;
        }
        finally {
            this.moduleDatabase.readUnlock();
        }
    }

    public Collection<ModuleRevision> getRemovalPending() {
        return this.moduleDatabase.getRemovalPending();
    }

    public int getStartLevel() {
        return this.frameworkStartLevel.getStartLevel();
    }

    void setStartLevel(Module module, int startlevel) {
        this.frameworkStartLevel.setStartLevel(module, startlevel);
    }

    long getModuleLockTimeout() {
        return this.moduleLockTimeout;
    }

    void open() {
        this.loadModules();
        this.frameworkStartLevel.open();
        this.frameworkWiring.open();
        this.refreshingSystemModule.set(null);
    }

    void close() {
        this.frameworkStartLevel.close();
        this.frameworkWiring.close();
        this.unloadModules();
    }

    /*
     * Unable to fully structure code
     */
    private void loadModules() {
        block13: {
            modules = null;
            this.moduleDatabase.readLock();
            try {
                modules = this.getModules();
                for (Module module : modules) {
                    try {
                        module.lockStateChange(ModuleContainerAdaptor.ModuleEvent.RESOLVED);
                        wiring = this.moduleDatabase.getWiring(module.getCurrentRevision());
                        if (wiring != null) {
                            module.setState(Module.State.RESOLVED);
                            continue;
                        }
                        module.setState(Module.State.INSTALLED);
                    }
                    catch (BundleException e) {
                        throw new IllegalStateException("Unable to lock module state.", e);
                    }
                }
                wirings = this.moduleDatabase.getWiringsCopy();
                for (ModuleWiring wiring : wirings.values()) {
                    wiring.validate();
                }
            }
            finally {
                if (modules == null) break block13;
                ** for (module : modules)
            }
lbl-1000:
            // 1 sources

            {
                try {
                    module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.RESOLVED);
                }
                catch (IllegalMonitorStateException v0) {}
                continue;
            }
        }
        this.moduleDatabase.readUnlock();
    }

    /*
     * Unable to fully structure code
     */
    private void unloadModules() {
        block12: {
            modules = null;
            this.moduleDatabase.readLock();
            try {
                modules = this.getModules();
                for (Module module : modules) {
                    if (module.getId() == 0L) continue;
                    try {
                        module.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
                    }
                    catch (BundleException e) {
                        throw new IllegalStateException("Unable to lock module state.", e);
                    }
                    module.setState(Module.State.UNINSTALLED);
                }
                wirings = this.moduleDatabase.getWiringsCopy();
                for (ModuleWiring wiring : wirings.values()) {
                    wiring.unload();
                }
            }
            finally {
                if (modules == null) break block12;
                ** for (module : modules)
            }
lbl-1000:
            // 1 sources

            {
                if (module.getId() == 0L) continue;
                try {
                    module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
                }
                catch (IllegalMonitorStateException v0) {}
                continue;
            }
        }
        this.moduleDatabase.readUnlock();
    }

    public void setInitialModuleStates() throws BundleException {
        this.moduleDatabase.readLock();
        try {
            List<Module> modules = this.getModules();
            for (Module module : modules) {
                if (module.getId() == 0L) {
                    module.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
                    try {
                        module.setState(Module.State.INSTALLED);
                        continue;
                    }
                    finally {
                        module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
                    }
                }
                module.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
                try {
                    module.setState(Module.State.UNINSTALLED);
                }
                finally {
                    module.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UNINSTALLED);
                }
            }
            Map<ModuleRevision, ModuleWiring> wirings = this.moduleDatabase.getWiringsCopy();
            for (ModuleWiring wiring : wirings.values()) {
                wiring.unload();
            }
        }
        finally {
            this.moduleDatabase.readUnlock();
        }
    }

    Set<Module> getRefreshClosure(Collection<Module> initial, Map<ModuleRevision, ModuleWiring> wiringCopy) {
        HashSet<Module> refreshClosure = new HashSet<Module>();
        if (initial == null) {
            initial = new HashSet<Module>();
            Collection<ModuleRevision> removalPending = this.moduleDatabase.getRemovalPending();
            for (ModuleRevision revision : removalPending) {
                initial.add(revision.getRevisions().getModule());
            }
        }
        for (Module module : initial) {
            ModuleContainer.addDependents(module, wiringCopy, refreshClosure);
        }
        return refreshClosure;
    }

    private static void addDependents(Module module, Map<ModuleRevision, ModuleWiring> wiringCopy, Set<Module> refreshClosure) {
        if (refreshClosure.contains(module)) {
            return;
        }
        refreshClosure.add(module);
        List<ModuleRevision> revisions = module.getRevisions().getModuleRevisions();
        for (ModuleRevision revision : revisions) {
            ModuleWiring wiring = wiringCopy.get(revision);
            if (wiring == null) continue;
            List<ModuleWire> provided = wiring.getProvidedModuleWires(null);
            for (ModuleWire providedWire : provided) {
                ModuleContainer.addDependents(providedWire.getRequirer().getRevisions().getModule(), wiringCopy, refreshClosure);
            }
            if (revision.getTypes() != 1) continue;
            List<ModuleWire> hosts = wiring.getRequiredModuleWires("osgi.wiring.host");
            for (ModuleWire hostWire : hosts) {
                ModuleContainer.addDependents(hostWire.getProvider().getRevisions().getModule(), wiringCopy, refreshClosure);
            }
        }
    }

    static Collection<ModuleRevision> getDependencyClosure(ModuleRevision initial, Map<ModuleRevision, ModuleWiring> wiringCopy) {
        HashSet<ModuleRevision> dependencyClosure = new HashSet<ModuleRevision>();
        ModuleContainer.addDependents(initial, wiringCopy, dependencyClosure);
        return dependencyClosure;
    }

    private static void addDependents(ModuleRevision revision, Map<ModuleRevision, ModuleWiring> wiringCopy, Set<ModuleRevision> dependencyClosure) {
        if (dependencyClosure.contains(revision)) {
            return;
        }
        dependencyClosure.add(revision);
        ModuleWiring wiring = wiringCopy.get(revision);
        if (wiring == null) {
            return;
        }
        List<ModuleWire> provided = wiring.getProvidedModuleWires(null);
        for (ModuleWire providedWire : provided) {
            ModuleContainer.addDependents(providedWire.getRequirer(), wiringCopy, dependencyClosure);
        }
        if (revision.getTypes() == 1) {
            List<ModuleWire> hosts = wiring.getRequiredModuleWires("osgi.wiring.host");
            for (ModuleWire hostWire : hosts) {
                ModuleContainer.addDependents(hostWire.getProvider(), wiringCopy, dependencyClosure);
            }
        }
    }

    Bundle getSystemBundle() {
        Module systemModule = this.moduleDatabase.getModule(0L);
        return systemModule == null ? null : systemModule.getBundle();
    }

    void checkAdminPermission(Bundle bundle, String action) {
        if (bundle == null) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new AdminPermission(bundle, action));
        }
    }

    void refreshSystemModule() {
        final SystemModule systemModule = (SystemModule)this.moduleDatabase.getModule(0L);
        if (systemModule == this.refreshingSystemModule.getAndSet(systemModule)) {
            return;
        }
        this.getAdaptor().refreshedSystemModule();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    systemModule.lockStateChange(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED);
                    try {
                        systemModule.stop(new Module.StopOptions[0]);
                    }
                    finally {
                        systemModule.unlockStateChange(ModuleContainerAdaptor.ModuleEvent.UNRESOLVED);
                    }
                }
                catch (BundleException e) {
                    e.printStackTrace();
                }
            }
        });
        t.start();
    }

    boolean isRefreshingSystemModule() {
        return this.refreshingSystemModule.get() != null;
    }

    static Requirement getIdentityRequirement(String name, Version version) {
        version = version == null ? Version.emptyVersion : version;
        String filter = "(&(osgi.identity=" + name + ")(" + "version" + "=" + version.toString() + "))";
        Map<String, String> directives = Collections.singletonMap("filter", filter);
        return new ModuleRequirement("osgi.identity", directives, Collections.emptyMap(), null);
    }

    @Override
    public void optionsChanged(DebugOptions options) {
        this.moduleResolver.setDebugOptions();
        this.frameworkStartLevel.setDebugOptions();
        if (options != null) {
            this.DEBUG_MONITOR_LAZY = options.getBooleanOption("org.eclipse.osgi/monitor/lazy", false);
            this.DEBUG_BUNDLE_START_TIME = options.getBooleanOption("org.eclipse.osgi/debug/bundleStartTime", false);
        }
    }

    class ContainerStartLevel
    implements FrameworkStartLevel,
    EventDispatcher<Module, FrameworkListener[], Integer> {
        static final int USE_BEGINNING_START_LEVEL = Integer.MIN_VALUE;
        private static final int FRAMEWORK_STARTLEVEL = 1;
        private static final int MODULE_STARTLEVEL = 2;
        private final AtomicInteger activeStartLevel = new AtomicInteger(0);
        private final Object eventManagerLock = new Object();
        private EventManager startLevelThread = null;
        private final Object frameworkStartLevelLock = new Object();
        boolean debugStartLevel = false;

        ContainerStartLevel() {
            this.setDebugOptions();
        }

        void setDebugOptions() {
            DebugOptions options = ModuleContainer.this.getAdaptor().getDebugOptions();
            this.debugStartLevel = options == null ? false : options.getBooleanOption("org.eclipse.osgi/debug/startlevel", false);
        }

        @Override
        public Bundle getBundle() {
            return ModuleContainer.this.getSystemBundle();
        }

        @Override
        public int getStartLevel() {
            return this.activeStartLevel.get();
        }

        void setStartLevel(Module module, int startlevel) {
            ModuleContainer.this.checkAdminPermission(module.getBundle(), "execute");
            if (module.getId() == 0L) {
                throw new IllegalArgumentException(Msg.ModuleContainer_SystemStartLevelError);
            }
            if (startlevel < 1) {
                throw new IllegalArgumentException(String.valueOf(Msg.ModuleContainer_NegativeStartLevelError) + startlevel);
            }
            int currentLevel = module.getStartLevel();
            if (currentLevel == startlevel) {
                return;
            }
            ModuleContainer.this.moduleDatabase.setStartLevel(module, startlevel);
            if (currentLevel < startlevel || module.isPersistentlyStarted()) {
                CopyOnWriteIdentityMap<Module, FrameworkListener[]> dispatchListeners = new CopyOnWriteIdentityMap<Module, FrameworkListener[]>();
                dispatchListeners.put(module, new FrameworkListener[0]);
                ListenerQueue<Module, FrameworkListener[], Integer> queue = new ListenerQueue<Module, FrameworkListener[], Integer>(this.getManager());
                queue.queueListeners(dispatchListeners.entrySet(), this);
                queue.dispatchEventAsynchronous(2, startlevel);
            }
        }

        @Override
        public void setStartLevel(int startlevel, FrameworkListener ... listeners) {
            ModuleContainer.this.checkAdminPermission(this.getBundle(), "startlevel");
            if (startlevel < 1) {
                throw new IllegalArgumentException(String.valueOf(Msg.ModuleContainer_NegativeStartLevelError) + startlevel);
            }
            if (this.activeStartLevel.get() == 0) {
                throw new IllegalStateException(Msg.ModuleContainer_SystemNotActiveError);
            }
            if (this.debugStartLevel) {
                Debug.println("StartLevel: setStartLevel: " + startlevel);
            }
            CopyOnWriteIdentityMap<Module, FrameworkListener[]> dispatchListeners = new CopyOnWriteIdentityMap<Module, FrameworkListener[]>();
            dispatchListeners.put(ModuleContainer.this.moduleDatabase.getModule(0L), listeners);
            ListenerQueue<Module, FrameworkListener[], Integer> queue = new ListenerQueue<Module, FrameworkListener[], Integer>(this.getManager());
            queue.queueListeners(dispatchListeners.entrySet(), this);
            queue.dispatchEventAsynchronous(1, startlevel);
        }

        @Override
        public int getInitialBundleStartLevel() {
            return ModuleContainer.this.moduleDatabase.getInitialModuleStartLevel();
        }

        @Override
        public void setInitialBundleStartLevel(int startlevel) {
            ModuleContainer.this.checkAdminPermission(this.getBundle(), "startlevel");
            if (startlevel < 1) {
                throw new IllegalArgumentException(String.valueOf(Msg.ModuleContainer_NegativeStartLevelError) + startlevel);
            }
            ModuleContainer.this.moduleDatabase.setInitialModuleStartLevel(startlevel);
        }

        @Override
        public void dispatchEvent(Module module, FrameworkListener[] listeners, int eventAction, Integer startlevel) {
            switch (eventAction) {
                case 1: {
                    this.doContainerStartLevel(module, startlevel, listeners);
                    break;
                }
                case 2: {
                    if (this.debugStartLevel) {
                        Debug.println("StartLevel: changing bundle startlevel; " + this.toString(module) + "; newSL=" + startlevel + "; activeSL=" + this.getStartLevel());
                    }
                    try {
                        if (this.getStartLevel() < startlevel) {
                            if (!Module.ACTIVE_SET.contains((Object)module.getState())) break;
                            if (this.debugStartLevel) {
                                Debug.println("StartLevel: stopping bundle; " + this.toString(module) + "; with startLevel=" + startlevel);
                            }
                            module.stop(Module.StopOptions.TRANSIENT);
                            break;
                        }
                        if (this.debugStartLevel) {
                            Debug.println("StartLevel: resuming bundle; " + this.toString(module) + "; with startLevel=" + startlevel);
                        }
                        module.start(Module.StartOptions.TRANSIENT_IF_AUTO_START, Module.StartOptions.TRANSIENT_RESUME);
                    }
                    catch (BundleException e) {
                        ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, new FrameworkListener[0]);
                    }
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doContainerStartLevel(Module module, int newStartLevel, FrameworkListener ... listeners) {
            Object object = this.frameworkStartLevelLock;
            synchronized (object) {
                if (newStartLevel == Integer.MIN_VALUE) {
                    String beginningSL = ModuleContainer.this.adaptor.getProperty("org.osgi.framework.startlevel.beginning");
                    newStartLevel = beginningSL == null ? 1 : Integer.parseInt(beginningSL);
                }
                try {
                    Module systemModule;
                    int currentSL = this.getStartLevel();
                    if (currentSL == 0 && (systemModule = ModuleContainer.this.moduleDatabase.getModule(0L)) != null && !Module.State.STARTING.equals((Object)systemModule.getState())) {
                        return;
                    }
                    List<Module> sorted = null;
                    long currentTimestamp = Long.MIN_VALUE;
                    if (newStartLevel > currentSL) {
                        ArrayList<Module> lazyStart = null;
                        ArrayList<Module> lazyStartParallel = null;
                        ArrayList<Module> eagerStart = null;
                        ArrayList<Module> eagerStartParallel = null;
                        int i = currentSL;
                        while (i < newStartLevel) {
                            int toStartLevel = i + 1;
                            this.activeStartLevel.set(toStartLevel);
                            if (this.debugStartLevel) {
                                Debug.println("StartLevel: incremented active start level to; " + toStartLevel);
                            }
                            if (sorted == null || currentTimestamp != ModuleContainer.this.moduleDatabase.getTimestamp()) {
                                ModuleContainer.this.moduleDatabase.readLock();
                                try {
                                    sorted = ModuleContainer.this.moduleDatabase.getSortedModules(ModuleDatabase.Sort.BY_START_LEVEL);
                                    lazyStart = new ArrayList<Module>(sorted.size());
                                    lazyStartParallel = new ArrayList<Module>(sorted.size());
                                    eagerStart = new ArrayList<Module>(sorted.size());
                                    eagerStartParallel = new ArrayList<Module>(sorted.size());
                                    this.separateModulesByActivationPolicy(sorted, lazyStart, lazyStartParallel, eagerStart, eagerStartParallel);
                                    currentTimestamp = ModuleContainer.this.moduleDatabase.getTimestamp();
                                }
                                finally {
                                    ModuleContainer.this.moduleDatabase.readUnlock();
                                }
                            }
                            this.incStartLevel(toStartLevel, lazyStart, lazyStartParallel, eagerStart, eagerStartParallel);
                            ++i;
                        }
                    } else {
                        int i = currentSL;
                        while (i > newStartLevel) {
                            int toStartLevel = i - 1;
                            this.activeStartLevel.set(toStartLevel);
                            if (this.debugStartLevel) {
                                Debug.println("StartLevel: decremented active start level to " + toStartLevel);
                            }
                            if (sorted == null || currentTimestamp != ModuleContainer.this.moduleDatabase.getTimestamp()) {
                                ModuleContainer.this.moduleDatabase.readLock();
                                try {
                                    sorted = ModuleContainer.this.moduleDatabase.getSortedModules(ModuleDatabase.Sort.BY_START_LEVEL, ModuleDatabase.Sort.BY_DEPENDENCY);
                                    currentTimestamp = ModuleContainer.this.moduleDatabase.getTimestamp();
                                }
                                finally {
                                    ModuleContainer.this.moduleDatabase.readUnlock();
                                }
                            }
                            this.decStartLevel(toStartLevel, sorted);
                            --i;
                        }
                    }
                    if (currentSL > 0 && newStartLevel > 0) {
                        ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.START_LEVEL, module, null, listeners);
                    }
                }
                catch (Error | RuntimeException e) {
                    ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, listeners);
                    throw e;
                }
            }
        }

        private void incStartLevel(int toStartLevel, List<Module> lazyStart, List<Module> lazyStartParallel, List<Module> eagerStart, List<Module> eagerStartParallel) {
            this.incStartLevel(toStartLevel, lazyStartParallel, true);
            this.incStartLevel(toStartLevel, lazyStart, false);
            this.incStartLevel(toStartLevel, eagerStartParallel, true);
            this.incStartLevel(toStartLevel, eagerStart, false);
        }

        private void separateModulesByActivationPolicy(List<Module> sortedModules, List<Module> lazyStart, List<Module> lazyStartParallel, List<Module> eagerStart, List<Module> eagerStartParallel) {
            for (Module module : sortedModules) {
                if (!ModuleContainer.this.restrictParallelStart || module.isParallelActivated()) {
                    if (module.isLazyActivate(new Module.StartOptions[0])) {
                        lazyStartParallel.add(module);
                        continue;
                    }
                    eagerStartParallel.add(module);
                    continue;
                }
                if (module.isLazyActivate(new Module.StartOptions[0])) {
                    lazyStart.add(module);
                    continue;
                }
                eagerStart.add(module);
            }
        }

        private void incStartLevel(final int toStartLevel, List<Module> candidatesToStart, boolean inParallel) {
            if (candidatesToStart.isEmpty()) {
                return;
            }
            ArrayList<Module> toStart = new ArrayList<Module>();
            for (Module module : candidatesToStart) {
                if (ModuleContainer.this.isRefreshingSystemModule()) {
                    return;
                }
                try {
                    int moduleStartLevel = module.getStartLevel();
                    if (moduleStartLevel < toStartLevel) continue;
                    if (moduleStartLevel != toStartLevel) break;
                    toStart.add(module);
                }
                catch (IllegalStateException illegalStateException) {}
            }
            if (toStart.isEmpty()) {
                return;
            }
            Executor executor = inParallel ? ModuleContainer.this.adaptor.getStartLevelExecutor() : new Executor(){

                @Override
                public void execute(Runnable command) {
                    command.run();
                }
            };
            final CountDownLatch done = new CountDownLatch(toStart.size());
            for (final Module module : toStart) {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            try {
                                if (ContainerStartLevel.this.debugStartLevel) {
                                    Debug.println("StartLevel: resuming bundle; " + ContainerStartLevel.this.toString(module) + "; with startLevel=" + toStartLevel);
                                }
                                module.start(Module.StartOptions.TRANSIENT_IF_AUTO_START, Module.StartOptions.TRANSIENT_RESUME);
                            }
                            catch (BundleException e) {
                                ((ContainerStartLevel)ContainerStartLevel.this).ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, new FrameworkListener[0]);
                                done.countDown();
                            }
                            catch (IllegalStateException illegalStateException) {
                                done.countDown();
                            }
                        }
                        finally {
                            done.countDown();
                        }
                    }
                });
            }
            try {
                done.await();
            }
            catch (InterruptedException e) {
                ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, ModuleContainer.this.moduleDatabase.getModule(0L), e, new FrameworkListener[0]);
            }
        }

        private void decStartLevel(int toStartLevel, List<Module> sortedModules) {
            ListIterator<Module> iModules = sortedModules.listIterator(sortedModules.size());
            while (iModules.hasPrevious()) {
                Module module = iModules.previous();
                try {
                    int moduleStartLevel = module.getStartLevel();
                    if (moduleStartLevel > toStartLevel + 1) continue;
                    if (moduleStartLevel <= toStartLevel) break;
                    try {
                        if (!Module.ACTIVE_SET.contains((Object)module.getState())) continue;
                        if (this.debugStartLevel) {
                            Debug.println("StartLevel: stopping bundle; " + this.toString(module) + "; with startLevel=" + moduleStartLevel);
                        }
                        module.stop(Module.StopOptions.TRANSIENT);
                    }
                    catch (BundleException e) {
                        ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, module, e, new FrameworkListener[0]);
                    }
                }
                catch (IllegalStateException illegalStateException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventManager getManager() {
            Object object = this.eventManagerLock;
            synchronized (object) {
                if (this.startLevelThread == null) {
                    this.startLevelThread = new EventManager("Start Level: " + ModuleContainer.this.adaptor.toString());
                }
                return this.startLevelThread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = this.eventManagerLock;
            synchronized (object) {
                EventManager manager = this.getManager();
                manager.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open() {
            Object object = this.eventManagerLock;
            synchronized (object) {
                if (this.startLevelThread != null) {
                    this.startLevelThread.close();
                    this.startLevelThread = null;
                }
            }
        }

        String toString(Module m) {
            Bundle b = m.getBundle();
            return b != null ? b.toString() : m.toString();
        }
    }

    class ContainerWiring
    implements FrameworkWiring,
    EventDispatcher<ContainerWiring, FrameworkListener[], Collection<Module>> {
        private final Object monitor = new Object();
        private EventManager refreshThread = null;

        ContainerWiring() {
        }

        @Override
        public Bundle getBundle() {
            return ModuleContainer.this.getSystemBundle();
        }

        @Override
        public void refreshBundles(Collection<Bundle> bundles, FrameworkListener ... listeners) {
            ModuleContainer.this.checkAdminPermission(this.getBundle(), "resolve");
            Collection<Module> modules = this.getModules(bundles);
            CopyOnWriteIdentityMap<ContainerWiring, FrameworkListener[]> dispatchListeners = new CopyOnWriteIdentityMap<ContainerWiring, FrameworkListener[]>();
            dispatchListeners.put(this, listeners);
            ListenerQueue<ContainerWiring, FrameworkListener[], Collection<Module>> queue = new ListenerQueue<ContainerWiring, FrameworkListener[], Collection<Module>>(this.getManager());
            queue.queueListeners(dispatchListeners.entrySet(), this);
            queue.dispatchEventAsynchronous(0, modules);
        }

        @Override
        public boolean resolveBundles(Collection<Bundle> bundles) {
            ModuleContainer.this.checkAdminPermission(this.getBundle(), "resolve");
            Collection<Module> modules = this.getModules(bundles);
            ModuleContainer.this.resolve(modules, false);
            if (modules == null) {
                modules = ModuleContainer.this.getModules();
            }
            for (Module module : modules) {
                if (ModuleContainer.this.getWiring(module.getCurrentRevision()) != null) continue;
                return false;
            }
            return true;
        }

        @Override
        public Collection<Bundle> getRemovalPendingBundles() {
            ModuleContainer.this.moduleDatabase.readLock();
            try {
                HashSet<Bundle> removalPendingBundles = new HashSet<Bundle>();
                Collection<ModuleRevision> removalPending = ModuleContainer.this.moduleDatabase.getRemovalPending();
                for (ModuleRevision moduleRevision : removalPending) {
                    removalPendingBundles.add(moduleRevision.getBundle());
                }
                HashSet<Bundle> hashSet = removalPendingBundles;
                return hashSet;
            }
            finally {
                ModuleContainer.this.moduleDatabase.readUnlock();
            }
        }

        @Override
        public Collection<Bundle> getDependencyClosure(Collection<Bundle> bundles) {
            Collection<Module> modules = this.getModules(bundles);
            ModuleContainer.this.moduleDatabase.readLock();
            try {
                Set<Module> closure = ModuleContainer.this.getRefreshClosure(modules, ModuleContainer.this.moduleDatabase.getWiringsCopy());
                ArrayList<Bundle> result = new ArrayList<Bundle>(closure.size());
                for (Module module : closure) {
                    result.add(module.getBundle());
                }
                ArrayList<Bundle> arrayList = result;
                return arrayList;
            }
            finally {
                ModuleContainer.this.moduleDatabase.readUnlock();
            }
        }

        @Override
        public Collection<BundleCapability> findProviders(Requirement requirement) {
            return InternalUtils.asListBundleCapability(ModuleContainer.this.moduleDatabase.findCapabilities(requirement));
        }

        private Collection<Module> getModules(final Collection<Bundle> bundles) {
            if (bundles == null) {
                return null;
            }
            return AccessController.doPrivileged(new PrivilegedAction<Collection<Module>>(){

                @Override
                public Collection<Module> run() {
                    ArrayList<Module> result = new ArrayList<Module>(bundles.size());
                    for (Bundle bundle : bundles) {
                        Module module = bundle.adapt(Module.class);
                        if (module == null) {
                            throw new IllegalStateException("Could not adapt a bundle to a module. " + bundle);
                        }
                        result.add(module);
                    }
                    return result;
                }
            });
        }

        @Override
        public void dispatchEvent(ContainerWiring eventListener, FrameworkListener[] frameworkListeners, int eventAction, Collection<Module> eventObject) {
            try {
                ModuleContainer.this.refresh(eventObject);
            }
            finally {
                ModuleContainer.this.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.REFRESH, ModuleContainer.this.moduleDatabase.getModule(0L), null, frameworkListeners);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EventManager getManager() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.refreshThread == null) {
                    this.refreshThread = new EventManager("Refresh Thread: " + ModuleContainer.this.adaptor.toString());
                }
                return this.refreshThread;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close() {
            Object object = this.monitor;
            synchronized (object) {
                EventManager manager = this.getManager();
                manager.close();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open() {
            Object object = this.monitor;
            synchronized (object) {
                if (this.refreshThread != null) {
                    this.refreshThread.close();
                    this.refreshThread = null;
                }
            }
        }
    }

    static class ResolutionLock {
        static final int MAX_RESOLUTION_PERMITS = 10;
        final Semaphore permitPool = new Semaphore(10);
        final ReentrantReadWriteLock reenterLock = new ReentrantReadWriteLock();

        ResolutionLock() {
        }

        Permits acquire(int requestedPermits) throws ResolutionLockException {
            return new Permits(requestedPermits);
        }

        class Permits
        implements Closeable {
            private final int aquiredPermits;
            private final AtomicBoolean closed = new AtomicBoolean();

            Permits(int requestedPermits) throws ResolutionLockException {
                if (ResolutionLock.this.reenterLock.getReadHoldCount() > 0) {
                    requestedPermits = 0;
                }
                this.aquiredPermits = requestedPermits;
                boolean previousInterruption = Thread.interrupted();
                try {
                    try {
                        if (!ResolutionLock.this.permitPool.tryAcquire(requestedPermits, 30L, TimeUnit.SECONDS)) {
                            throw new ResolutionLockException();
                        }
                    }
                    catch (InterruptedException e) {
                        throw new ResolutionLockException(e);
                    }
                }
                finally {
                    if (previousInterruption) {
                        Thread.currentThread().interrupt();
                    }
                }
                ResolutionLock.this.reenterLock.readLock().lock();
            }

            @Override
            public void close() {
                if (this.closed.compareAndSet(false, true)) {
                    ResolutionLock.this.permitPool.release(this.aquiredPermits);
                    ResolutionLock.this.reenterLock.readLock().unlock();
                }
            }
        }
    }

    static class ResolutionLockException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ResolutionLockException() {
        }

        public ResolutionLockException(Throwable cause) {
            super(cause);
        }
    }
}

