/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.text.quicksearch.internal.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.IRegion;
import org.eclipse.text.quicksearch.internal.core.LineItem;

public class QuickTextQuery {
    private boolean caseInsensitive;
    private String orgPattern;
    private Pattern pattern;

    public QuickTextQuery() {
        this("", true);
    }

    public QuickTextQuery(String substring, boolean caseInsensitive) {
        this.orgPattern = substring;
        this.caseInsensitive = caseInsensitive;
        this.createMatcher(substring, caseInsensitive);
    }

    private void createMatcher(String patString, boolean caseSensitive) {
        StringBuilder segment = new StringBuilder();
        StringBuilder regexp = new StringBuilder();
        int pos = 0;
        int len = patString.length();
        while (pos < len) {
            char c = patString.charAt(pos++);
            switch (c) {
                case '?': {
                    this.appendSegment(segment, regexp);
                    regexp.append('.');
                    break;
                }
                case '*': {
                    this.appendSegment(segment, regexp);
                    regexp.append(".*");
                    break;
                }
                case '\\': {
                    char nextChar;
                    if (pos < len && ((nextChar = patString.charAt(pos)) == '*' || nextChar == '?' || nextChar == '\\')) {
                        segment.append(nextChar);
                        ++pos;
                        break;
                    }
                }
                default: {
                    segment.append(c);
                }
            }
        }
        this.appendSegment(segment, regexp);
        this.pattern = Pattern.compile(regexp.toString(), caseSensitive ? 2 : 0);
    }

    private void appendSegment(StringBuilder segment, StringBuilder regexp) {
        if (segment.length() > 0) {
            regexp.append(Pattern.quote(segment.toString()));
            segment.setLength(0);
        }
    }

    public boolean equalsFilter(QuickTextQuery o) {
        return this.caseInsensitive == o.caseInsensitive && this.orgPattern.equals(o.orgPattern);
    }

    public boolean isSubFilter(QuickTextQuery other) {
        if (this.isTrivial()) {
            return false;
        }
        if (this.caseInsensitive == other.caseInsensitive) {
            boolean caseSensitive = this.caseInsensitive;
            String otherPat = this.normalize(other.orgPattern, caseSensitive);
            String thisPat = this.normalize(this.orgPattern, caseSensitive);
            return otherPat.contains(thisPat);
        }
        return false;
    }

    private String normalize(String pat, boolean caseSensitive) {
        if (pat.endsWith("\\")) {
            pat = String.valueOf(pat) + "\\";
        }
        if (!caseSensitive) {
            pat = pat.toLowerCase();
        }
        return pat;
    }

    public boolean matchItem(LineItem item) {
        return this.matchItem(item.getText());
    }

    public boolean matchItem(String item) {
        Matcher matcher = this.pattern.matcher(item);
        return matcher.find();
    }

    public boolean isTrivial() {
        return "".equals(this.orgPattern);
    }

    public String toString() {
        return "QTQuery(" + this.orgPattern + ", " + (this.caseInsensitive ? "caseSens" : "caseInSens") + ")";
    }

    public List<TextRange> findAll(String text) {
        if (this.isTrivial()) {
            return Arrays.asList(new TextRange[0]);
        }
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        Matcher matcher = this.pattern.matcher(text);
        while (matcher.find()) {
            int start = matcher.start();
            int end = matcher.end();
            ranges.add(new TextRange(start, end - start));
        }
        return ranges;
    }

    public TextRange findFirst(String str) {
        List<TextRange> all = this.findAll(str);
        if (all != null && !all.isEmpty()) {
            return all.get(0);
        }
        return null;
    }

    public String getPatternString() {
        return this.orgPattern;
    }

    public class TextRange
    implements IRegion {
        public final int start;
        public final int len;

        public TextRange(int start, int len) {
            this.start = start;
            this.len = len;
        }

        public int getLength() {
            return this.len;
        }

        public int getOffset() {
            return this.start;
        }
    }
}

