/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xycharts;

import org.eclipse.tracecompass.internal.tmf.ui.viewers.xycharts.TmfXyUiUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xycharts.TmfXYChartViewer;
import org.swtchart.Chart;
import org.swtchart.IAxis;

public abstract class TmfBaseProvider {
    private final ITmfChartTimeProvider fChartViewer;

    public TmfBaseProvider(ITmfChartTimeProvider tmfChartViewer) {
        this.fChartViewer = tmfChartViewer;
    }

    public ITmfChartTimeProvider getChartViewer() {
        return this.fChartViewer;
    }

    protected Chart getChart() {
        return (Chart)this.fChartViewer.getControl();
    }

    protected long limitXDataCoordinate(double x) {
        return TmfXyUiUtils.limitXDataCoordinate(this.getChartViewer(), x);
    }

    protected int limitXPixelCoordinate(int axisIndex, int x) {
        ITmfChartTimeProvider viewer = this.getChartViewer();
        long windowStartTime = viewer.getWindowStartTime() - viewer.getTimeOffset();
        long windowEndTime = viewer.getWindowEndTime() - viewer.getTimeOffset();
        IAxis xAxis = this.getChart().getAxisSet().getXAxis(0);
        int startX = xAxis.getPixelCoordinate((double)windowStartTime);
        if (x < startX) {
            return startX;
        }
        int endX = xAxis.getPixelCoordinate((double)windowEndTime);
        if (x > endX) {
            return endX;
        }
        return x;
    }

    public void dispose() {
        this.deregister();
    }

    public void refresh() {
        if (!TmfXYChartViewer.getDisplay().isDisposed()) {
            TmfXYChartViewer.getDisplay().asyncExec(() -> {
                if (!this.getChart().isDisposed()) {
                    this.getChart().redraw();
                }
            });
        }
    }

    protected abstract void register();

    protected abstract void deregister();
}

