/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.dataprovider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.core.Activator;

@NonNullByDefault
public class X11ColorUtils {
    private static final String X11_COLOR_FILE = "share/rgb.txt";
    private static final Pattern PATTERN = Pattern.compile("\\s*(\\d{1,3})\\s*(\\d{1,3})\\s*(\\d{1,3})\\s*(.*\\S)\\s*");
    private static final String HEX_COLOR_FORMAT = "#%02x%02x%02x";
    private static final Map<String, String> COLORS = new HashMap<String, String>();

    static {
        URL url = Activator.getDefault().getBundle().getEntry(X11_COLOR_FILE);
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openConnection().getInputStream()));){
                String line;
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = PATTERN.matcher(line);
                    if (!matcher.matches()) continue;
                    int r = Integer.parseInt(matcher.group(1));
                    int g = Integer.parseInt(matcher.group(2));
                    int b = Integer.parseInt(matcher.group(3));
                    String hexColor = String.format(HEX_COLOR_FORMAT, r, g, b);
                    COLORS.put(matcher.group(4).toLowerCase(), hexColor);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.logError("Cannot read the file from URL", e);
        }
    }

    public static @Nullable String toHexColor(String name) {
        return COLORS.get(name.toLowerCase());
    }
}

