/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.junit;

import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class DOMUtil {
    private DOMUtil() {
    }

    public static NodeList listChildNodes(Node parent, NodeFilter filter, boolean recurse) {
        NodeListImpl matches = new NodeListImpl();
        NodeList children = parent.getChildNodes();
        if (children != null) {
            int len = children.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = children.item(i);
                if (filter.accept(child)) {
                    matches.addElement(child);
                }
                if (!recurse) continue;
                NodeList recmatches = DOMUtil.listChildNodes(child, filter, recurse);
                int reclength = recmatches.getLength();
                for (int j = 0; j < reclength; ++j) {
                    matches.addElement(recmatches.item(i));
                }
            }
        }
        return matches;
    }

    public static String getNodeAttribute(Node node, String name) {
        if (node instanceof Element) {
            Element element = (Element)node;
            return element.getAttribute(name);
        }
        return null;
    }

    public static Element getChildByTagName(Node parent, String tagname) {
        if (parent == null) {
            return null;
        }
        NodeList childList = parent.getChildNodes();
        int len = childList.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = childList.item(i);
            if (child == null || child.getNodeType() != 1 || !child.getNodeName().equals(tagname)) continue;
            return (Element)child;
        }
        return null;
    }

    public static Node importNode(Node parent, Node child) {
        Node copy = null;
        Document doc = parent.getOwnerDocument();
        switch (child.getNodeType()) {
            case 4: {
                copy = doc.createCDATASection(((CDATASection)child).getData());
                break;
            }
            case 8: {
                copy = doc.createComment(((Comment)child).getData());
                break;
            }
            case 11: {
                copy = doc.createDocumentFragment();
                break;
            }
            case 1: {
                Element elem = doc.createElement(((Element)child).getTagName());
                copy = elem;
                NamedNodeMap attributes = child.getAttributes();
                if (attributes == null) break;
                int size = attributes.getLength();
                for (int i = 0; i < size; ++i) {
                    Attr attr = (Attr)attributes.item(i);
                    elem.setAttribute(attr.getName(), attr.getValue());
                }
                break;
            }
            case 5: {
                copy = doc.createEntityReference(child.getNodeName());
                break;
            }
            case 7: {
                ProcessingInstruction pi = (ProcessingInstruction)child;
                copy = doc.createProcessingInstruction(pi.getTarget(), pi.getData());
                break;
            }
            case 3: {
                copy = doc.createTextNode(((Text)child).getData());
                break;
            }
            default: {
                throw new IllegalStateException("Invalid node type: " + child.getNodeType());
            }
        }
        try {
            NodeList children = child.getChildNodes();
            if (children != null) {
                int size = children.getLength();
                for (int i = 0; i < size; ++i) {
                    Node newChild = children.item(i);
                    if (newChild == null) continue;
                    DOMUtil.importNode(copy, newChild);
                }
            }
        }
        catch (DOMException dOMException) {
            // empty catch block
        }
        parent.appendChild(copy);
        return copy;
    }

    public static class NodeListImpl
    extends Vector
    implements NodeList {
        private static final long serialVersionUID = 3175749150080946423L;

        @Override
        public int getLength() {
            return this.size();
        }

        @Override
        public Node item(int i) {
            try {
                return (Node)this.elementAt(i);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                return null;
            }
        }
    }

    public static interface NodeFilter {
        public boolean accept(Node var1);
    }
}

