/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.callstack.ui.flamegraph;

import java.util.Comparator;
import org.eclipse.tracecompass.incubator.internal.callstack.core.instrumented.provider.FlameChartEntryModel;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.TimeGraphEntry;

class ThreadNameComparator
implements Comparator<ITimeGraphEntry> {
    private static final Comparator<ITimeGraphEntry> INSTANCE = new ThreadNameComparator();

    private ThreadNameComparator() {
    }

    public static Comparator<ITimeGraphEntry> getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(ITimeGraphEntry o1, ITimeGraphEntry o2) {
        if (o1 instanceof TimeGraphEntry && o2 instanceof TimeGraphEntry) {
            ITmfTreeDataModel entryModel1 = ((TimeGraphEntry)o1).getEntryModel();
            ITmfTreeDataModel entryModel2 = ((TimeGraphEntry)o2).getEntryModel();
            if (entryModel1 instanceof FlameChartEntryModel && entryModel2 instanceof FlameChartEntryModel) {
                FlameChartEntryModel fcEntry1 = (FlameChartEntryModel)entryModel1;
                FlameChartEntryModel fcEntry2 = (FlameChartEntryModel)entryModel2;
                if (fcEntry1.getEntryType().equals((Object)FlameChartEntryModel.EntryType.FUNCTION) || fcEntry2.getEntryType().equals((Object)FlameChartEntryModel.EntryType.FUNCTION) || fcEntry1.getEntryType().equals((Object)FlameChartEntryModel.EntryType.KERNEL) || fcEntry2.getEntryType().equals((Object)FlameChartEntryModel.EntryType.KERNEL)) {
                    return 0;
                }
            }
        }
        return o1.getName().compareTo(o2.getName());
    }
}

