/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.template.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.wst.jsdt.internal.corext.template.java.JavaTemplateMessages;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TemplateSet {
    private static final String NAME_ATTRIBUTE = "name";
    private static final String DESCRIPTION_ATTRIBUTE = "description";
    private static final String CONTEXT_ATTRIBUTE = "context";
    private List fTemplates = new ArrayList();
    private String fTemplateTag;
    private static final int TEMPLATE_PARSE_EXCEPTION = 10002;
    private static final int TEMPLATE_IO_EXCEPTION = 10005;
    private ContextTypeRegistry fRegistry;

    public TemplateSet(String templateTag, ContextTypeRegistry registry) {
        this.fTemplateTag = templateTag;
        this.fRegistry = registry;
    }

    public void addFromFile(File file, boolean allowDuplicates) throws CoreException {
        block14: {
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(file);
                    this.addFromStream(stream, allowDuplicates);
                }
                catch (IOException e) {
                    TemplateSet.throwReadException(e);
                    try {
                        if (stream != null) {
                            ((InputStream)stream).close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        ((InputStream)stream).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (stream != null) {
                    ((InputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public String getTemplateTag() {
        return this.fTemplateTag;
    }

    public void addFromStream(InputStream stream, boolean allowDuplicates) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document document = parser.parse(new InputSource(stream));
            NodeList elements = document.getElementsByTagName(this.getTemplateTag());
            int count = elements.getLength();
            int i = 0;
            while (i != count) {
                Node node = elements.item(i);
                NamedNodeMap attributes = node.getAttributes();
                if (attributes != null) {
                    String name = this.getAttributeValue(attributes, NAME_ATTRIBUTE);
                    String description = this.getAttributeValue(attributes, DESCRIPTION_ATTRIBUTE);
                    if (name != null && description != null) {
                        String context = this.getAttributeValue(attributes, CONTEXT_ATTRIBUTE);
                        if (name == null || description == null || context == null) {
                            throw new SAXException(JavaTemplateMessages.TemplateSet_error_missing_attribute);
                        }
                        StringBuffer buffer = new StringBuffer();
                        NodeList children = node.getChildNodes();
                        int j = 0;
                        while (j != children.getLength()) {
                            String value = children.item(j).getNodeValue();
                            if (value != null) {
                                buffer.append(value);
                            }
                            ++j;
                        }
                        String pattern = buffer.toString().trim();
                        Template template = new Template(name, description, context, pattern);
                        String message = this.validateTemplate(template);
                        if (message == null) {
                            if (!allowDuplicates) {
                                Template[] templates = this.getTemplates(name);
                                int k = 0;
                                while (k < templates.length) {
                                    this.remove(templates[k]);
                                    ++k;
                                }
                            }
                            this.add(template);
                        } else {
                            TemplateSet.throwReadException(null);
                        }
                    }
                }
                ++i;
            }
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwReadException(e);
        }
        catch (IOException e) {
            TemplateSet.throwReadException(e);
        }
        catch (SAXException e) {
            TemplateSet.throwReadException(e);
        }
    }

    protected String validateTemplate(Template template) {
        TemplateContextType type = this.fRegistry.getContextType(template.getContextTypeId());
        if (type == null) {
            return "Unknown context type: " + template.getContextTypeId();
        }
        try {
            type.validate(template.getPattern());
            return null;
        }
        catch (TemplateException e) {
            return e.getMessage();
        }
    }

    private String getAttributeValue(NamedNodeMap attributes, String name) {
        Node node = attributes.getNamedItem(name);
        return node == null ? null : node.getNodeValue();
    }

    public void saveToFile(File file) throws CoreException {
        block14: {
            FileOutputStream stream = null;
            try {
                try {
                    stream = new FileOutputStream(file);
                    this.saveToStream(stream);
                }
                catch (IOException e) {
                    TemplateSet.throwWriteException(e);
                    try {
                        if (stream != null) {
                            ((OutputStream)stream).close();
                        }
                        break block14;
                    }
                    catch (IOException iOException) {}
                    break block14;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        ((OutputStream)stream).close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (stream != null) {
                    ((OutputStream)stream).close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void saveToStream(OutputStream stream) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element root = document.createElement("templates");
            document.appendChild(root);
            int i = 0;
            while (i != this.fTemplates.size()) {
                Template template = (Template)this.fTemplates.get(i);
                Element node = document.createElement(this.getTemplateTag());
                root.appendChild(node);
                NamedNodeMap attributes = node.getAttributes();
                Attr name = document.createAttribute(NAME_ATTRIBUTE);
                name.setValue(template.getName());
                attributes.setNamedItem(name);
                Attr description = document.createAttribute(DESCRIPTION_ATTRIBUTE);
                description.setValue(template.getDescription());
                attributes.setNamedItem(description);
                Attr context = document.createAttribute(CONTEXT_ATTRIBUTE);
                context.setValue(template.getContextTypeId());
                attributes.setNamedItem(context);
                Text pattern = document.createTextNode(template.getPattern());
                node.appendChild(pattern);
                ++i;
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            DOMSource source = new DOMSource(document);
            StreamResult result = new StreamResult(stream);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException e) {
            TemplateSet.throwWriteException(e);
        }
        catch (TransformerException e) {
            TemplateSet.throwWriteException(e);
        }
    }

    private static void throwReadException(Throwable t) throws CoreException {
        int code = t instanceof SAXException ? 10002 : 10005;
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jface.text", code, JavaTemplateMessages.TemplateSet_error_read, t));
    }

    private static void throwWriteException(Throwable t) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.jface.text", 10005, JavaTemplateMessages.TemplateSet_error_write, t));
    }

    public void add(Template template) {
        if (this.exists(template)) {
            return;
        }
        this.fTemplates.add(template);
    }

    private boolean exists(Template template) {
        for (Template anotherTemplate : this.fTemplates) {
            if (!template.equals((Object)anotherTemplate)) continue;
            return true;
        }
        return false;
    }

    public void remove(Template template) {
        this.fTemplates.remove(template);
    }

    public void clear() {
        this.fTemplates.clear();
    }

    public Template[] getTemplates() {
        return this.fTemplates.toArray(new Template[this.fTemplates.size()]);
    }

    public Template[] getTemplates(String name) {
        ArrayList<Template> res = new ArrayList<Template>();
        for (Template curr : this.fTemplates) {
            if (!curr.getName().equals(name)) continue;
            res.add(curr);
        }
        return res.toArray(new Template[res.size()]);
    }

    public Template getFirstTemplate(String name) {
        for (Template curr : this.fTemplates) {
            if (!curr.getName().equals(name)) continue;
            return curr;
        }
        return null;
    }
}

