/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers;

import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.RocmCallStackStateProvider;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.AbstractGpuEventHandler;
import org.eclipse.tracecompass.incubator.internal.rocm.core.analysis.handlers.HostThreadIdentifier;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;

public class HsaActivityEventHandler
extends AbstractGpuEventHandler {
    public HsaActivityEventHandler(RocmCallStackStateProvider stateProvider) {
        super(stateProvider);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ssb, ITmfEvent event) throws AttributeNotFoundException {
        int copyQuark = ssb.getQuarkAbsoluteAndAdd(new String[]{"Processes", "Memory"});
        int tempQuark1 = ssb.getQuarkRelativeAndAdd(copyQuark, new String[]{""});
        int tempQuark2 = ssb.getQuarkRelativeAndAdd(tempQuark1, new String[]{"Memory Transfers"});
        int callStackQuark = ssb.getQuarkRelativeAndAdd(tempQuark2, new String[]{"CallStack"});
        Long timestamp = event.getTimestamp().toNanos();
        Long timestampEnd = AbstractGpuEventHandler.getEndTime(event);
        ssb.pushAttribute(timestamp.longValue(), (Object)"Copy", callStackQuark);
        if (timestampEnd != null) {
            this.fStateProvider.addFutureEvent(timestampEnd, null, callStackQuark, ITmfStateProvider.FutureEventType.POP);
        }
        HostThreadIdentifier hostThreadIdentifier = new HostThreadIdentifier();
        this.addHostIdToStateSystemIfNotDefined(ssb, event.getTrace(), hostThreadIdentifier, callStackQuark);
    }
}

