/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring;

import org.eclipse.core.runtime.Assert;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;

public class RefactoringSessionDescriptor {
    public static final String VERSION_1_0 = "1.0";
    private final String fComment;
    private final RefactoringDescriptor[] fDescriptors;
    private final String fVersion;

    public RefactoringSessionDescriptor(RefactoringDescriptor[] descriptors, String version, String comment) {
        Assert.isNotNull((Object)descriptors);
        Assert.isTrue((version != null && !"".equals(version) ? 1 : 0) != 0);
        this.fDescriptors = new RefactoringDescriptor[descriptors.length];
        System.arraycopy(descriptors, 0, this.fDescriptors, 0, descriptors.length);
        this.fVersion = version;
        this.fComment = comment;
    }

    public final String getComment() {
        return this.fComment != null ? this.fComment : "";
    }

    public final RefactoringDescriptor[] getRefactorings() {
        RefactoringDescriptor[] result = new RefactoringDescriptor[this.fDescriptors.length];
        System.arraycopy(this.fDescriptors, 0, result, 0, result.length);
        return result;
    }

    public final String getVersion() {
        return this.fVersion;
    }
}

