/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.incubator.internal.trace.server.jersey.rest.core.model.views.FilterQueryParameters;
import org.eclipse.tracecompass.statesystem.core.StateSystemUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.tmf.core.model.annotations.IAnnotation;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphArrow;
import org.eclipse.tracecompass.tmf.core.model.timegraph.TimeGraphState;

public class QueryParametersUtil {
    private static final String DESTINATION_ID = "destinationId";
    private static final String DURATION = "duration";
    private static final String ELEMENT_TYPE = "elementType";
    private static final String END = "end";
    private static final String ENTRY_ID = "entryId";
    private static final String FILTER_QUERY_PARAMETERS = "filter_query_parameters";
    private static final String FILTER_EXPRESSIONS_MAP = "filter_expressions_map";
    private static final String NAME = "name";
    private static final String NBTIMES = "nbTimes";
    private static final String REQUESTED_TIMERANGE_KEY = "requested_timerange";
    private static final String SEP = ": ";
    private static final String START = "start";
    private static final String STRATEGY = "strategy";
    private static final String TIME = "time";
    private static final String TRACES = "traces";
    private static final String URI = "uri";
    private static final long MAX_NBTIMES = 65536L;
    private static final @NonNull OutputElementStyle EMPTY_STYLE = new OutputElementStyle(null, Collections.emptyMap());

    public static String validateTraceQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateString(URI, params);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateExperimentQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateString(NAME, params);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = QueryParametersUtil.validateStringList(TRACES, params);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateTreeQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateRequestedTimeRange(params, false, true);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateRequestedQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateRequestedTimeRange(params, true, false);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = QueryParametersUtil.validateRequestedItems(params, true);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateArrowsQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateRequestedTimeRange(params, true, false);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateAnnotationsQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateRequestedTimeRange(params, true, false);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = QueryParametersUtil.validateRequestedItems(params, false);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateTooltipQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateRequestedTimes(params, true);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = QueryParametersUtil.validateRequestedItems(params, true);
        if (errorMessage != null) {
            return errorMessage;
        }
        errorMessage = QueryParametersUtil.validateRequestedElement(params);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateLinesQueryParameters(Map<String, Object> params) {
        String errorMessage = QueryParametersUtil.validateRequestedTimes(params, false);
        if (errorMessage != null) {
            return errorMessage;
        }
        return null;
    }

    public static String validateFilterQueryParameters(Map<String, Object> params) {
        Map map;
        Object filterExpressionsMapObj;
        Object value = params.get(FILTER_QUERY_PARAMETERS);
        if (value == null) {
            return null;
        }
        if (value instanceof Map && (filterExpressionsMapObj = ((Map)value).get(FILTER_EXPRESSIONS_MAP)) instanceof Map && (map = (Map)filterExpressionsMapObj).size() > 0) {
            HashMap<Integer, Collection<String>> filterExpressionsMap = new HashMap<Integer, Collection<String>>();
            for (Map.Entry entry : map.entrySet()) {
                try {
                    if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof Collection) || !((Collection)entry.getValue()).stream().allMatch(item -> item instanceof String)) continue;
                    filterExpressionsMap.put(Integer.parseInt((String)entry.getKey()), new ArrayList((Collection)entry.getValue()));
                }
                catch (NumberFormatException e) {
                    return "Invalid query parameters: filter_expressions_map";
                }
            }
            if (filterExpressionsMap.size() > 0) {
                FilterQueryParameters filterQueryParameters = new FilterQueryParameters();
                filterQueryParameters.setFilterExpressionsMap(filterExpressionsMap);
                Object filterExpressionsStrategyObject = ((Map)value).get(STRATEGY);
                if (FilterQueryParameters.FilterQueryStrategy.DEEP.name().equals(filterExpressionsStrategyObject)) {
                    filterQueryParameters.setStrategy(FilterQueryParameters.FilterQueryStrategy.DEEP);
                }
                params.put("regex_map_filters", filterExpressionsMap);
                Boolean isDeepSearch = filterQueryParameters.isDeepSearch();
                if (isDeepSearch.booleanValue()) {
                    params.put("full_search", isDeepSearch);
                }
            }
        }
        params.remove(FILTER_QUERY_PARAMETERS);
        return null;
    }

    private static String validateString(String param, Map<String, Object> params) {
        Object value = params.get(param);
        if (value == null) {
            return "Missing query parameters: " + param;
        }
        if (!(value instanceof String)) {
            return "Invalid query parameters: " + param;
        }
        return null;
    }

    private static String validateStringList(String param, Map<String, Object> params) {
        Object value = params.get(param);
        if (value == null) {
            return "Missing query parameters: " + param;
        }
        if (!(value instanceof List)) {
            return "Invalid query parameters: " + param;
        }
        for (Object elem : (List)value) {
            if (elem instanceof String) continue;
            return "Invalid query parameters: " + param;
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static String validateRequestedTimeRange(Map<String, Object> params, boolean required, boolean isTree) {
        Object requestedTimeRange = params.get(REQUESTED_TIMERANGE_KEY);
        Object requestedTimes = params.get("requested_times");
        if (required && requestedTimeRange == null && requestedTimes == null) {
            return "Missing query parameters: requested_timerange";
        }
        if (requestedTimeRange != null) {
            requestedTimes = params.computeIfPresent(REQUESTED_TIMERANGE_KEY, (k, v) -> {
                if (v instanceof Map) {
                    Map map = (Map)v;
                    Object startObj = map.get(START);
                    Object endObj = map.get(END);
                    Object nbTimesObj = map.get(NBTIMES);
                    if (!(startObj instanceof Number) || !(endObj instanceof Number)) {
                        return null;
                    }
                    long start = ((Number)startObj).longValue();
                    long end = ((Number)endObj).longValue();
                    if (!(nbTimesObj instanceof Number)) {
                        return Arrays.asList(start, end);
                    }
                    long nbTimes = Math.min(((Number)nbTimesObj).longValue(), 65536L);
                    if (nbTimes <= 1L) {
                        return Arrays.asList(start, end);
                    }
                    long resolution = (end - start) / (nbTimes - 1L);
                    return StateSystemUtils.getTimes((long)start, (long)end, (long)resolution);
                }
                return null;
            });
            if (requestedTimes == null) {
                return "Invalid query parameters: requested_timerange";
            }
            params.put("requested_times", requestedTimes);
            params.remove(REQUESTED_TIMERANGE_KEY);
        } else if (requestedTimes != null) {
            @NonNull List timeRequested = DataProviderParameterUtils.extractTimeRequested(params);
            if (timeRequested == null || isTree && timeRequested.size() == 1 || !isTree && timeRequested.isEmpty()) {
                return "Invalid query parameters: requested_times";
            }
            params.put("requested_times", timeRequested);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static String validateRequestedTimes(Map<String, Object> params, boolean required) {
        Object value = params.get("requested_times");
        if (required && value == null) {
            return "Missing query parameters: requested_times";
        }
        if (value != null) {
            @NonNull List timeRequested = DataProviderParameterUtils.extractTimeRequested(params);
            if (timeRequested == null || timeRequested.isEmpty()) {
                return "Invalid query parameters: requested_times";
            }
            params.put("requested_times", value);
        }
        return null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static String validateRequestedItems(Map<String, Object> params, boolean required) {
        Object value = params.get("requested_items");
        if (required && value == null) {
            return "Missing query parameters: requested_items";
        }
        if (value != null) {
            @NonNull List selectedItems = DataProviderParameterUtils.extractSelectedItems(params);
            if (selectedItems == null) {
                return "Invalid query parameters: requested_items";
            }
            params.put("requested_items", value);
        }
        return null;
    }

    private static String validateRequestedElement(Map<String, Object> params) {
        Object value = params.get("requested_element");
        if (value == null) {
            return "Missing query parameters: requested_element";
        }
        params.computeIfPresent("requested_element", (k, v) -> {
            if (v instanceof Map) {
                Map map = (Map)v;
                Object elementType = map.get(ELEMENT_TYPE);
                long time = ((Number)map.getOrDefault(TIME, 0L)).longValue();
                long duration = ((Number)map.getOrDefault(DURATION, 0L)).longValue();
                if ("state".equals(elementType)) {
                    return new TimeGraphState(time, duration, null, null);
                }
                if ("annotation".equals(elementType)) {
                    long entryId = ((Number)map.getOrDefault(ENTRY_ID, -1L)).longValue();
                    return new Annotation(time, duration, entryId, IAnnotation.AnnotationType.CHART, null, EMPTY_STYLE);
                }
                if ("arrow".equals(elementType)) {
                    long sourceId = ((Number)map.getOrDefault(ENTRY_ID, -1L)).longValue();
                    long destinationId = ((Number)map.getOrDefault(DESTINATION_ID, -1L)).longValue();
                    return new TimeGraphArrow(sourceId, destinationId, time, duration, EMPTY_STYLE);
                }
            }
            return null;
        });
        if (params.get("requested_element") == null) {
            return "Invalid query parameters: requested_element";
        }
        return null;
    }

    private static interface ElementType {
        public static final String STATE = "state";
        public static final String ANNOTATION = "annotation";
        public static final String ARROW = "arrow";
    }
}

