/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters;

import com.google.common.base.Objects;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters.ActiveThreadsFilter;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.controlflow.filters.Messages;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class DynamicFilterDialog
extends TitleAreaDialog {
    private static final Pattern CPU_RANGE = Pattern.compile("^((\\d+(\\-\\d+)?, ?)*(\\d+(\\-\\d+)?))+$");
    private static final @NonNull String INTERNAL_RANGE_SEPARATOR = "-";
    private static final @NonNull String RANGES_DELIMITER = ",";
    private static final int EXPECTED_RANGE_LEN = 2;
    private static final int NUM_COLUMNS = 2;
    private @NonNull ActiveThreadsFilter fInternalActiveThreadsFilter;
    private final @Nullable ITmfTrace fTrace;
    private Button fActiveThreadEnabledButton;
    private Button fAllActiveThreadsRadionButton;
    private Button fCpuRangesRadioButton;
    private Text fCpuRangesField;

    public DynamicFilterDialog(Shell parentShell, @NonNull ActiveThreadsFilter filter, @Nullable ITmfTrace trace) {
        super(parentShell);
        this.fInternalActiveThreadsFilter = filter;
        this.fTrace = trace;
    }

    public void create() {
        super.create();
        this.setTitle(Messages.DynamicFilterDialog_Title);
        this.getShell().setText(Messages.DynamicFilterDialog_Title);
    }

    private static boolean validateCpuRange(String newString) {
        return CPU_RANGE.matcher(newString).matches();
    }

    private void createActiveThreadSection(Composite parent) {
        boolean usesCpuRanges = false;
        boolean filterActive = false;
        ActiveThreadsFilter filter = this.fInternalActiveThreadsFilter;
        filterActive = this.fInternalActiveThreadsFilter.isEnabled();
        usesCpuRanges = filter.isCpuRangesBased();
        Group activeThreadGroup = new Group(parent, 2080);
        activeThreadGroup.setText(Messages.DynamicFilterDialog_ActiveThreadsFilterName);
        activeThreadGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout gl = new GridLayout(1, true);
        gl.marginRight = 0;
        gl.marginLeft = 0;
        activeThreadGroup.setLayout((Layout)gl);
        this.fActiveThreadEnabledButton = new Button((Composite)activeThreadGroup, 32);
        this.fActiveThreadEnabledButton.setText(Messages.DynamicFilterDialog_ActiveThreadsFilterName);
        this.fActiveThreadEnabledButton.setLayoutData((Object)new GridData(4, 4, true, true));
        final Group cpuSelectionGroup = new Group((Composite)activeThreadGroup, 32);
        cpuSelectionGroup.setText(Messages.DynamicFilterDialog_OptionsGroupLabel);
        cpuSelectionGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        cpuSelectionGroup.setLayout((Layout)new GridLayout(2, false));
        this.fAllActiveThreadsRadionButton = new Button((Composite)cpuSelectionGroup, 16);
        this.fAllActiveThreadsRadionButton.setText(Messages.DynamicFilterDialog_RadioButtonAllActiveThreads);
        this.fAllActiveThreadsRadionButton.setToolTipText(Messages.DynamicFilterDialog_RadioButtonAllActiveThreadsToolTip);
        this.fAllActiveThreadsRadionButton.setSelection(!usesCpuRanges);
        GridData gd = new GridData(4, 4, true, true);
        gd.horizontalSpan = 2;
        this.fAllActiveThreadsRadionButton.setLayoutData((Object)gd);
        this.fCpuRangesRadioButton = new Button((Composite)cpuSelectionGroup, 16);
        this.fCpuRangesRadioButton.setText(Messages.DynamicFilterDialog_CpuRangesLabel);
        this.fCpuRangesRadioButton.setToolTipText(Messages.DynamicFilterDialog_CpuRangesTooltip);
        this.fCpuRangesRadioButton.setLayoutData((Object)new GridData(16384, 4, false, true));
        this.fCpuRangesField = new Text((Composite)cpuSelectionGroup, 2052);
        this.fCpuRangesField.setLayoutData((Object)new GridData(16384, 4, true, true));
        this.fCpuRangesField.setMessage(Messages.DynamicFilterDialog_CpuRangesExamples);
        this.fCpuRangesRadioButton.setToolTipText(Messages.DynamicFilterDialog_CpuRangesTooltip);
        this.fCpuRangesField.addVerifyListener(e -> {
            String oldString = this.fCpuRangesField.getText();
            String newString = String.valueOf(oldString.substring(0, e.start)) + e.text + oldString.substring(e.end);
            boolean valid = DynamicFilterDialog.validateCpuRange(newString);
            Button okButton = this.getButton(0);
            if (okButton != null) {
                this.getButton(0).setEnabled(valid);
            }
            if (valid) {
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(Messages.DynamicFilterDialog_InvalidRangesErrorMsg);
            }
        });
        this.fAllActiveThreadsRadionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean selected = ((Button)e.widget).getSelection();
                if (!selected) {
                    return;
                }
                DynamicFilterDialog.this.setErrorMessage(null);
                DynamicFilterDialog.this.getButton(0).setEnabled(true);
            }
        });
        this.fCpuRangesRadioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean selected = ((Button)e.widget).getSelection();
                DynamicFilterDialog.this.fCpuRangesField.setEnabled(selected);
                DynamicFilterDialog.validateCpuRange(DynamicFilterDialog.this.fCpuRangesField.getText());
            }
        });
        this.fActiveThreadEnabledButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                super.widgetSelected(e);
                boolean selected = ((Button)e.widget).getSelection();
                cpuSelectionGroup.setEnabled(selected);
                DynamicFilterDialog.this.fAllActiveThreadsRadionButton.setEnabled(selected);
                DynamicFilterDialog.this.fCpuRangesRadioButton.setEnabled(selected);
                DynamicFilterDialog.this.fCpuRangesField.setEnabled(selected && DynamicFilterDialog.this.fCpuRangesRadioButton.getSelection());
            }
        });
        this.fActiveThreadEnabledButton.setSelection(filterActive);
        cpuSelectionGroup.setEnabled(filterActive);
        this.fCpuRangesRadioButton.setEnabled(filterActive);
        this.fAllActiveThreadsRadionButton.setEnabled(filterActive);
        this.fAllActiveThreadsRadionButton.setSelection(!usesCpuRanges);
        this.fCpuRangesRadioButton.setSelection(usesCpuRanges);
        this.fCpuRangesField.setEnabled(filterActive && usesCpuRanges);
        if (!filter.getCpuRanges().isEmpty()) {
            StringJoiner joiner = new StringJoiner(RANGES_DELIMITER);
            for (Range<Long> range : filter.getCpuRanges()) {
                String rangeString = ((Long)range.lowerEndpoint()).toString();
                if (!Objects.equal((Object)range.lowerEndpoint(), (Object)range.upperEndpoint())) {
                    rangeString = rangeString.concat(INTERNAL_RANGE_SEPARATOR + range.upperEndpoint());
                }
                joiner.add(rangeString);
            }
            this.fCpuRangesField.setText(joiner.toString());
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = new GridLayout(1, true);
        container.setLayout((Layout)layout);
        this.createActiveThreadSection(container);
        return area;
    }

    protected boolean isResizable() {
        return true;
    }

    private void saveInput() {
        if (!this.fAllActiveThreadsRadionButton.getSelection() && !this.fCpuRangesRadioButton.getSelection() || this.fAllActiveThreadsRadionButton.getSelection() && this.fCpuRangesRadioButton.getSelection()) {
            throw new IllegalStateException(Messages.DynamicFilterDialog_InvalidRadioButtonState);
        }
        List<Range<Long>> ranges = null;
        ranges = DynamicFilterDialog.parseCpuRangesText(this.fCpuRangesField.getText());
        this.fInternalActiveThreadsFilter = new ActiveThreadsFilter(ranges, this.fCpuRangesRadioButton.getSelection(), this.fTrace);
        this.fInternalActiveThreadsFilter.setEnabled(this.fActiveThreadEnabledButton.getSelection());
    }

    private static List<Range<Long>> parseCpuRangesText(String string) {
        ArrayList<Range<Long>> results = new ArrayList<Range<Long>>();
        if (DynamicFilterDialog.validateCpuRange(string)) {
            String[] stringArray = string.split(RANGES_DELIMITER);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String range = stringArray[n2];
                if (range.contains(INTERNAL_RANGE_SEPARATOR)) {
                    String[] split = range.split(INTERNAL_RANGE_SEPARATOR);
                    if (split.length == 2) {
                        long[] sorted = new long[split.length];
                        Arrays.setAll(sorted, i -> Long.parseLong(split[i]));
                        Arrays.sort(sorted);
                        results.add((Range<Long>)Range.closed((Comparable)Long.valueOf(sorted[0]), (Comparable)Long.valueOf(sorted[1])));
                    }
                } else {
                    Long value = Long.parseLong(range);
                    results.add((Range<Long>)Range.closed((Comparable)value, (Comparable)value));
                }
                ++n2;
            }
        }
        return results;
    }

    protected void okPressed() {
        this.saveInput();
        super.okPressed();
    }

    public boolean isHelpAvailable() {
        return false;
    }

    public @NonNull ActiveThreadsFilter getActiveThreadsResult() {
        return this.fInternalActiveThreadsFilter;
    }
}

