/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.ui.swtbot.tests.latency;

import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swtbot.eclipse.finder.SWTWorkbenchBot;
import org.eclipse.swtbot.eclipse.finder.widgets.SWTBotView;
import org.eclipse.swtbot.swt.finder.SWTBotAssert;
import org.eclipse.swtbot.swt.finder.exceptions.WidgetNotFoundException;
import org.eclipse.swtbot.swt.finder.finders.UIThreadRunnable;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.matchers.WidgetOfType;
import org.eclipse.swtbot.swt.finder.results.Result;
import org.eclipse.swtbot.swt.finder.utils.SWTBotPreferences;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBot;
import org.eclipse.swtbot.swt.finder.widgets.AbstractSWTBotControl;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTable;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.Range;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.density2.AbstractSegmentStoreDensityView;
import org.eclipse.tracecompass.analysis.timing.ui.views.segmentstore.table.AbstractSegmentStoreTableViewer;
import org.eclipse.tracecompass.internal.analysis.os.linux.ui.views.latency.SystemCallLatencyDensityView;
import org.eclipse.tracecompass.testtraces.ctf.CtfTestTrace;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.ConditionHelpers;
import org.eclipse.tracecompass.tmf.ui.swtbot.tests.shared.SWTBotUtils;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=SWTBotJunit4ClassRunner.class)
public class SystemCallLatencyDensityViewTest {
    private static final String TRACE_TYPE = "org.eclipse.linuxtools.lttng2.kernel.tracetype";
    private static final String PROJECT_NAME = "test";
    private static final String VIEW_ID = "org.eclipse.tracecompass.analysis.os.linux.views.latency.density";
    private AbstractSegmentStoreDensityView fDensityView;
    private AbstractSegmentStoreTableViewer fDensityViewer;
    private Chart fDensityChart;
    private static SWTWorkbenchBot fBot;

    @BeforeClass
    public static void beforeClass() {
        SWTBotUtils.initialize();
        Thread.currentThread().setName("SWTBotTest");
        SWTBotPreferences.TIMEOUT = 20000L;
        SWTBotPreferences.KEYBOARD_LAYOUT = "EN_US";
        fBot = new SWTWorkbenchBot();
        WaitUtils.waitForJobs();
    }

    @Before
    public void createDensityViewer() throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        SWTBotUtils.openView((String)VIEW_ID);
        SWTBotView viewBot = fBot.viewById(VIEW_ID);
        final IViewReference viewReference = viewBot.getViewReference();
        IViewPart viewPart = (IViewPart)UIThreadRunnable.syncExec((Result)new Result<IViewPart>(){

            public IViewPart run() {
                return viewReference.getView(true);
            }
        });
        Assert.assertNotNull((Object)viewPart);
        if (!(viewPart instanceof SystemCallLatencyDensityView)) {
            Assert.fail((String)"Could not instanciate view");
        }
        this.fDensityView = (SystemCallLatencyDensityView)viewPart;
        Field field = AbstractSegmentStoreDensityView.class.getDeclaredField("fTableViewer");
        field.setAccessible(true);
        this.fDensityViewer = (AbstractSegmentStoreTableViewer)field.get(this.fDensityView);
        this.fDensityChart = (Chart)viewBot.bot().widget(WidgetOfType.widgetOfType(Chart.class));
        Assert.assertNotNull((Object)this.fDensityViewer);
    }

    @After
    public void closeDensityViewer() {
        SWTBotUtils.closeViewById((String)VIEW_ID, (SWTWorkbenchBot)fBot);
    }

    @Test
    public void testWithTrace() throws IOException, NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        String tracePath = FileUtils.toFile((URL)FileLocator.toFileURL((URL)CtfTestTrace.ARM_64_BIT_HEADER.getTraceURL())).getAbsolutePath();
        SWTWorkbenchBot bot = new SWTWorkbenchBot();
        SWTBotUtils.closeViewById((String)VIEW_ID, (SWTWorkbenchBot)fBot);
        SWTBotUtils.createProject((String)PROJECT_NAME);
        SWTBotUtils.openTrace((String)PROJECT_NAME, (String)tracePath, (String)TRACE_TYPE);
        WaitUtils.waitForJobs();
        this.createDensityViewer();
        WaitUtils.waitForJobs();
        SWTBotTable tableBot = new SWTBotTable(this.fDensityViewer.getTableViewer().getTable());
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1,600", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1,600", (int)0, (int)2));
        tableBot.header("Duration").click();
        bot.waitUntil(ConditionHelpers.isTableCellFilled((SWTBotTable)tableBot, (String)"1,001,046,400", (int)0, (int)2));
        Chart densityChart = this.fDensityChart;
        Assert.assertNotNull((Object)densityChart);
        bot.waitUntil(ConditionHelpers.numberOfSeries((Chart)densityChart, (int)1));
        SWTBotChart chartBot = new SWTBotChart(densityChart);
        SWTBotAssert.assertVisible((AbstractSWTBot)chartBot);
        Assert.assertEquals((Object)"", (Object)chartBot.getToolTipText());
        Range range = densityChart.getAxisSet().getXAxes()[0].getRange();
        Assert.assertTrue((0.0 > range.lower ? 1 : 0) != 0);
        Assert.assertTrue((1.0010464E9 < range.upper ? 1 : 0) != 0);
        bot.closeAllEditors();
        SWTBotUtils.deleteProject((String)PROJECT_NAME, (SWTWorkbenchBot)bot);
    }

    private static class SWTBotChart
    extends AbstractSWTBotControl<Chart> {
        public SWTBotChart(Chart w) throws WidgetNotFoundException {
            super((Control)w);
        }
    }
}

