/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.dialogs;

import java.util.List;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.Criteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.dialogs.FilterCriteria;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.handlers.provider.ISDFilterProvider;
import org.junit.Assert;
import org.junit.Test;

public class CriteriaTest {
    @Test
    public void testCriteria() {
        Criteria criteria = new Criteria();
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isAsyncMessageReturnSelected());
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isAsyncMessageSelected());
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isCaseSenstiveSelected());
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isLifeLineSelected());
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isStopSelected());
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isSyncMessageReturnSelected());
        Assert.assertFalse((String)"testCriteria", (boolean)criteria.isSyncMessageSelected());
        Assert.assertNull((String)"testCriteria", (Object)criteria.getExpression());
        Assert.assertNull((String)"testCriteria", (Object)criteria.getPattern());
    }

    @Test
    public void testCriteriaCriteria() {
        Criteria criteria = new Criteria();
        criteria.setExpression("test");
        criteria.setLifeLineSelected(true);
        criteria.setSyncMessageSelected(true);
        Criteria copy = new Criteria(criteria);
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isAsyncMessageReturnSelected(), (Object)copy.isAsyncMessageReturnSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isAsyncMessageSelected(), (Object)copy.isAsyncMessageSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isCaseSenstiveSelected(), (Object)copy.isCaseSenstiveSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isLifeLineSelected(), (Object)copy.isLifeLineSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isStopSelected(), (Object)copy.isStopSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isSyncMessageReturnSelected(), (Object)copy.isSyncMessageReturnSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.isSyncMessageSelected(), (Object)copy.isSyncMessageSelected());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.getExpression(), (Object)copy.getExpression());
        Assert.assertEquals((String)"testCriteriaCriteria", (Object)criteria.getPattern().pattern(), (Object)copy.getPattern().pattern());
    }

    @Test
    public void testAccessors() {
        Criteria criteria = new Criteria();
        criteria.setAsyncMessageReturnSelected(true);
        criteria.setAsyncMessageSelected(true);
        criteria.setCaseSenstiveSelected(true);
        criteria.setLifeLineSelected(true);
        criteria.setStopSelected(true);
        criteria.setSyncMessageReturnSelected(true);
        criteria.setSyncMessageSelected(true);
        criteria.setExpression("test.*");
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isAsyncMessageReturnSelected());
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isAsyncMessageSelected());
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isCaseSenstiveSelected());
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isLifeLineSelected());
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isStopSelected());
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isSyncMessageReturnSelected());
        Assert.assertTrue((String)"testAccessors", (boolean)criteria.isSyncMessageSelected());
        Assert.assertEquals((String)"testAccessors", (Object)"test.*", (Object)criteria.getExpression());
        Assert.assertNotNull((String)"testAccessors", (Object)criteria.getPattern());
        Assert.assertEquals((String)"testAccessors", (Object)"test.*", (Object)criteria.getPattern().pattern());
        Assert.assertEquals((String)"testAccessors", (long)0L, (long)(criteria.getPattern().flags() & 2));
        criteria.setAsyncMessageReturnSelected(false);
        criteria.setAsyncMessageSelected(false);
        criteria.setCaseSenstiveSelected(false);
        criteria.setLifeLineSelected(false);
        criteria.setStopSelected(false);
        criteria.setSyncMessageReturnSelected(false);
        criteria.setSyncMessageSelected(false);
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isAsyncMessageReturnSelected());
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isAsyncMessageSelected());
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isCaseSenstiveSelected());
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isLifeLineSelected());
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isStopSelected());
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isSyncMessageReturnSelected());
        Assert.assertFalse((String)"testAccessors", (boolean)criteria.isSyncMessageSelected());
        Assert.assertEquals((String)"testAccessors", (Object)"test.*", (Object)criteria.getExpression());
        Assert.assertNotNull((String)"testAccessors", (Object)criteria.getPattern());
        Assert.assertEquals((String)"testAccessors", (Object)"test.*", (Object)criteria.getPattern().pattern());
        Assert.assertEquals((String)"testAccessors", (long)2L, (long)(criteria.getPattern().flags() & 2));
    }

    @Test
    public void testCompareTo() {
        Criteria criteria = new Criteria();
        criteria.setExpression("test");
        criteria.setLifeLineSelected(true);
        criteria.setSyncMessageSelected(true);
        Criteria copy = new Criteria(criteria);
        Assert.assertTrue((String)"testCompareTo", (boolean)criteria.compareTo(copy));
        Assert.assertTrue((String)"testCompareTo", (boolean)copy.compareTo(criteria));
        Assert.assertTrue((String)"testCompareTo", (boolean)criteria.compareTo(criteria));
        copy.setExpression(null);
        Assert.assertFalse((String)"testCompareTo", (boolean)criteria.compareTo(copy));
        Assert.assertFalse((String)"testCompareTo", (boolean)copy.compareTo(criteria));
        criteria.setExpression(null);
        Assert.assertTrue((String)"testCompareTo", (boolean)criteria.compareTo(copy));
        Assert.assertTrue((String)"testCompareTo", (boolean)copy.compareTo(criteria));
        criteria.setExpression("test");
        copy.setExpression("test.*[12345]");
        Assert.assertFalse((String)"testCompareTo", (boolean)criteria.compareTo(copy));
        Assert.assertFalse((String)"testCompareTo", (boolean)copy.compareTo(criteria));
        copy.setExpression("test");
        copy.setAsyncMessageReturnSelected(true);
        Assert.assertFalse((String)"testCompareTo", (boolean)criteria.compareTo(copy));
        Assert.assertFalse((String)"testCompareTo", (boolean)copy.compareTo(criteria));
    }

    @Test
    public void testSave() {
        DialogSettings settings = new DialogSettings("mysettings");
        Criteria criteria = new Criteria();
        criteria.setExpression("test");
        criteria.setLifeLineSelected(true);
        criteria.setSyncMessageSelected(true);
        criteria.save(settings);
        Assert.assertEquals((String)"testSave", (Object)"test", (Object)settings.get("expression"));
        Assert.assertEquals((String)"testSave", (Object)"false", (Object)settings.get("isCaseSenstiveSelected"));
        Assert.assertEquals((String)"testSave", (Object)"false", (Object)settings.get("isAsyncMessageReturnSelected"));
        Assert.assertEquals((String)"testSave", (Object)"false", (Object)settings.get("isAsyncMessageSelected"));
        Assert.assertEquals((String)"testSave", (Object)"true", (Object)settings.get("isLifeLineSelected"));
        Assert.assertEquals((String)"testSave", (Object)"false", (Object)settings.get("isStopSelected"));
        Assert.assertEquals((String)"testSave", (Object)"false", (Object)settings.get("isSyncMessageReturnSelected"));
        Assert.assertEquals((String)"testSave", (Object)"true", (Object)settings.get("isSyncMessageSelected"));
    }

    @Test
    public void testLoad() {
        DialogSettings settings = new DialogSettings("mysettings");
        Criteria criteria = new Criteria();
        criteria.setExpression("test");
        criteria.setLifeLineSelected(true);
        criteria.setSyncMessageSelected(true);
        criteria.save(settings);
        Criteria copy = new Criteria();
        copy.load(settings);
        Assert.assertTrue((String)"testCompareTo", (boolean)criteria.compareTo(copy));
        Assert.assertTrue((String)"testCompareTo", (boolean)copy.compareTo(criteria));
    }

    @Test
    public void testGetGraphNodeSummary() {
        ISDFilterProvider provider = new ISDFilterProvider(){

            public boolean isNodeSupported(int nodeType) {
                return true;
            }

            public String getNodeName(int nodeType, String loaderClassName) {
                switch (nodeType) {
                    case 0: {
                        return "MyLifeline";
                    }
                    case 1: {
                        return "MySyncMessage";
                    }
                    case 2: {
                        return "MySyncMessageReturn";
                    }
                    case 3: {
                        return "MyAsyncMessage";
                    }
                    case 4: {
                        return "MyAsyncMessageReturn";
                    }
                    case 5: {
                        return "MyStop";
                    }
                }
                return "";
            }

            public boolean filter(List<FilterCriteria> filters) {
                return false;
            }
        };
        Criteria criteria = new Criteria();
        criteria.setExpression("BALL_.*");
        criteria.setAsyncMessageReturnSelected(true);
        criteria.setAsyncMessageSelected(true);
        criteria.setLifeLineSelected(true);
        criteria.setStopSelected(true);
        criteria.setSyncMessageReturnSelected(true);
        criteria.setSyncMessageSelected(true);
        String summary = criteria.getGraphNodeSummary(provider, null);
        Assert.assertEquals((String)"testGetGraphNodeSummary", (Object)"[MyLifeline or MySyncMessage or MySyncMessageReturn or MyAsyncMessage or MyAsyncMessageReturn or MyStop]", (Object)summary);
        summary = criteria.getGraphNodeSummary(null, null);
        Assert.assertEquals((String)"testGetGraphNodeSummary", (Object)"[Lifeline or Synchronous message or Synchronous message return or Asynchronous message or Asynchronous message return or Stop]", (Object)summary);
    }

    @Test
    public void testMatches() {
        Criteria criteria = new Criteria();
        criteria.setExpression("BALL_.*");
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("BALL_REQUEST"));
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("BALL_REPLY"));
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("BALL_R"));
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("ball_request"));
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("ball_request"));
        Assert.assertFalse((String)"testMatches", (boolean)criteria.matches("NOBALL_REQUEST"));
        Assert.assertFalse((String)"testMatches", (boolean)criteria.matches("BLABLA"));
        criteria.setCaseSenstiveSelected(true);
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("BALL_REQUEST"));
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("BALL_REPLY"));
        Assert.assertTrue((String)"testMatches", (boolean)criteria.matches("BALL_R"));
        Assert.assertFalse((String)"testMatches", (boolean)criteria.matches("ball_request"));
        Assert.assertFalse((String)"testMatches", (boolean)criteria.matches("ball_request"));
        Assert.assertFalse((String)"testMatches", (boolean)criteria.matches("NOBALL_REQUEST"));
        Assert.assertFalse((String)"testMatches", (boolean)criteria.matches("BLABLA"));
    }
}

