/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.map;

import java.util.Map;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.collection.ImmutableCollection;
import org.eclipse.collections.api.map.MapIterable;
import org.eclipse.collections.api.multimap.ImmutableMultimap;
import org.eclipse.collections.api.partition.PartitionImmutableCollection;
import org.eclipse.collections.api.tuple.Pair;

public interface ImmutableMapIterable<K, V>
extends MapIterable<K, V> {
    public Map<K, V> castToMap();

    public ImmutableMapIterable<K, V> newWithKeyValue(K var1, V var2);

    public ImmutableMapIterable<K, V> newWithAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> var1);

    public ImmutableMapIterable<K, V> newWithAllKeyValueArguments(Pair<? extends K, ? extends V> ... var1);

    public ImmutableMapIterable<K, V> newWithoutKey(K var1);

    public ImmutableMapIterable<K, V> newWithoutAllKeys(Iterable<? extends K> var1);

    @Override
    public ImmutableMapIterable<K, V> tap(Procedure<? super V> var1);

    @Override
    public ImmutableMapIterable<V, K> flipUniqueValues();

    @Override
    public ImmutableMultimap<V, K> flip();

    @Override
    public ImmutableMapIterable<K, V> select(Predicate2<? super K, ? super V> var1);

    @Override
    public ImmutableMapIterable<K, V> reject(Predicate2<? super K, ? super V> var1);

    @Override
    public <K2, V2> ImmutableMapIterable<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> var1);

    @Override
    public <R> ImmutableMapIterable<K, R> collectValues(Function2<? super K, ? super V, ? extends R> var1);

    @Override
    public ImmutableCollection<V> select(Predicate<? super V> var1);

    @Override
    public <P> ImmutableCollection<V> selectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public ImmutableCollection<V> reject(Predicate<? super V> var1);

    @Override
    public <P> ImmutableCollection<V> rejectWith(Predicate2<? super V, ? super P> var1, P var2);

    @Override
    public PartitionImmutableCollection<V> partition(Predicate<? super V> var1);

    @Override
    public <S> ImmutableCollection<S> selectInstancesOf(Class<S> var1);

    @Override
    default public <V1> ImmutableBag<V1> countBy(Function<? super V, ? extends V1> function) {
        return this.asLazy().collect(function).toBag().toImmutable();
    }

    @Override
    default public <V1, P> ImmutableBag<V1> countByWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        return this.asLazy().collectWith(function, (Object)parameter).toBag().toImmutable();
    }

    @Override
    public <V1> ImmutableMultimap<V1, V> groupBy(Function<? super V, ? extends V1> var1);

    @Override
    public <V1> ImmutableMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> var1);

    @Override
    public <V1> ImmutableMapIterable<V1, V> groupByUniqueKey(Function<? super V, ? extends V1> var1);

    @Override
    public <S> ImmutableCollection<Pair<V, S>> zip(Iterable<S> var1);

    @Override
    public ImmutableCollection<Pair<V, Integer>> zipWithIndex();

    @Override
    public <KK, VV> ImmutableMapIterable<KK, VV> aggregateInPlaceBy(Function<? super V, ? extends KK> var1, Function0<? extends VV> var2, Procedure2<? super VV, ? super V> var3);

    @Override
    public <KK, VV> ImmutableMapIterable<KK, VV> aggregateBy(Function<? super V, ? extends KK> var1, Function0<? extends VV> var2, Function2<? super VV, ? super V, ? extends VV> var3);
}

