/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.ApplicationType;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.HostInstance;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Identifiable;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.State;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.StateMachine;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.Transition;
import org.eclipse.viatra.examples.cps.deployment.BehaviorState;
import org.eclipse.viatra.examples.cps.deployment.BehaviorTransition;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.deployment.DeploymentApplication;
import org.eclipse.viatra.examples.cps.deployment.DeploymentBehavior;
import org.eclipse.viatra.examples.cps.deployment.DeploymentElement;
import org.eclipse.viatra.examples.cps.deployment.DeploymentFactory;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.traceability.CPS2DeploymentTrace;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.traceability.TraceabilityFactory;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.AppInstancesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.AppTypesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.Cps2depTraceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.DepApp2depHostMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.DepBehavior2depAppMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.HostInstancesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.SendTransitionAppSignalMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.Sm2DeploymentbehaviorMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.State2StatemachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.StateMachinesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.StatesMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.Transition2StateMachineMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.TransitionsMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.AppInstancesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.AppTypesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.HostInstancesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.StateMachinesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.StatesQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.aggr.queries.util.TransitionsQuerySpecification;
import org.eclipse.viatra.examples.cps.xform.m2m.util.NamingUtil;
import org.eclipse.viatra.examples.cps.xform.m2m.util.SignalUtil;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.ChangeDelta;
import org.eclipse.viatra.transformation.runtime.emf.changemonitor.ChangeMonitor;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class CPS2DeploymentPartialBatchTransformation {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.incr.aggr");
    @Extension
    private CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    private DeploymentFactory depFactory = DeploymentFactory.eINSTANCE;
    private TraceabilityFactory tracFactory = TraceabilityFactory.eINSTANCE;
    private CPSToDeployment mapping;
    private ViatraQueryEngine engine;
    private ChangeMonitor monitor;
    private Stopwatch clearModelPerformance;
    private Stopwatch hostTransformationPerformance;
    private Stopwatch appTransformationPerformance;
    private Stopwatch stateMachineTransformationPerformance;
    private Stopwatch stateTransformationPerformance;
    private Stopwatch transitionTransformationPerformance;
    private Stopwatch triggerTransformationPerformance;
    private Stopwatch otherTimer;
    private Table<State, DeploymentBehavior, BehaviorState> stateTable;
    private Map<Identifiable, CPS2DeploymentTrace> traceTable;
    private Map<Transition, String> transitionMap;

    public CPS2DeploymentPartialBatchTransformation(CPSToDeployment mapping, ViatraQueryEngine engine) {
        ChangeMonitor _changeMonitor;
        Preconditions.checkArgument((mapping != null ? 1 : 0) != 0, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = mapping.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = mapping.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"Engine cannot be null!");
        this.mapping = mapping;
        this.engine = engine;
        this.logger.debug((Object)"Preparing queries on engine.");
        Stopwatch watch = Stopwatch.createStarted();
        this.cpsXformM2M.prepare(engine);
        HashMap<Transition, String> _hashMap = new HashMap<Transition, String>();
        this.transitionMap = _hashMap;
        Consumer<TransitionsMatch> _function = m -> this.transitionMap.put(m.getTransition(), m.getTransition().getAction());
        this.cpsXformM2M.getTransitions(engine).getAllMatches().forEach(_function);
        this.monitor = _changeMonitor = new ChangeMonitor(engine);
        this.monitor.addRule((IQuerySpecification)HostInstancesQuerySpecification.instance());
        this.monitor.addRule((IQuerySpecification)AppTypesQuerySpecification.instance());
        this.monitor.addRule((IQuerySpecification)AppInstancesQuerySpecification.instance());
        this.monitor.addRule((IQuerySpecification)StateMachinesQuerySpecification.instance());
        this.monitor.addRule((IQuerySpecification)StatesQuerySpecification.instance());
        this.monitor.addRule((IQuerySpecification)TransitionsQuerySpecification.instance());
        this.monitor.startMonitoring();
        watch.stop();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Prepared queries on engine (");
        long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append(" ms)");
        this.logger.info((Object)_builder);
    }

    public void execute() {
        this.initPerformanceTimers();
        ChangeDelta delta = this.monitor.createCheckpoint();
        Consumer<IQuerySpecification> _function = spec -> {
            Consumer<IPatternMatch> _function_1 = b -> {
                if (b instanceof TransitionsMatch) {
                    Transition transition = ((TransitionsMatch)((Object)((Object)b))).getTransition();
                    this.transitionMap.put(transition, transition.getAction());
                }
            };
            delta.getAppeared(spec).forEach(_function_1);
        };
        delta.getChangedQuerySpecifications().forEach(_function);
        this.clearModelPerformance.start();
        this.clearModel(delta);
        this.clearModelPerformance.stop();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing transformation on:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("Cyber-physical system: ");
        String _identifier = this.mapping.getCps().getIdentifier();
        _builder.append(_identifier, "\t");
        this.logger.info((Object)_builder);
        this.stateTable = HashBasedTable.create();
        this.traceTable = Maps.newHashMap();
        this.logger.debug((Object)"Running host transformations.");
        Functions.Function1 _function_1 = it -> it.getInstances();
        Consumer<HostInstance> _function_2 = it -> this.transform((HostInstance)it);
        Iterables.concat((Iterable)ListExtensions.map((List)this.mapping.getCps().getHostTypes(), (Functions.Function1)_function_1)).forEach(_function_2);
        this.logger.debug((Object)"Running action transformations.");
        Functions.Function1 _function_3 = it -> it.getDepTransition();
        Consumer<BehaviorTransition> _function_4 = it -> this.mapAction((BehaviorTransition)it);
        IterableExtensions.map((Iterable)this.cpsXformM2M.getDepTransition(this.engine).getAllMatches(), (Functions.Function1)_function_3).forEach(_function_4);
        this.reportPerformance();
    }

    private Stopwatch initPerformanceTimers() {
        Stopwatch _xblockexpression = null;
        this.clearModelPerformance = Stopwatch.createUnstarted();
        this.hostTransformationPerformance = Stopwatch.createUnstarted();
        this.appTransformationPerformance = Stopwatch.createUnstarted();
        this.stateMachineTransformationPerformance = Stopwatch.createUnstarted();
        this.stateTransformationPerformance = Stopwatch.createUnstarted();
        this.transitionTransformationPerformance = Stopwatch.createUnstarted();
        this.triggerTransformationPerformance = Stopwatch.createUnstarted();
        _xblockexpression = this.otherTimer = Stopwatch.createUnstarted();
        return _xblockexpression;
    }

    private void reportPerformance() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(">>>Cleared model in: ");
        long _elapsed = this.clearModelPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Host transformation: ");
        long _elapsed_1 = this.hostTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_1);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Application Instance transformation: ");
        long _elapsed_2 = this.appTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_2);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>State Machine transformation: ");
        long _elapsed_3 = this.stateMachineTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_3);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>State transformation: ");
        long _elapsed_4 = this.stateTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_4);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Transition transformation: ");
        long _elapsed_5 = this.transitionTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_5);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Trigger transformation: ");
        long _elapsed_6 = this.triggerTransformationPerformance.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_6);
        _builder.append(" ms");
        _builder.newLineIfNotEmpty();
        _builder.append(">>>Other perf: ");
        long _elapsed_7 = this.otherTimer.elapsed(TimeUnit.MILLISECONDS);
        _builder.append((Object)_elapsed_7);
        _builder.append(" ms");
        this.logger.debug((Object)_builder);
    }

    private void transform(HostInstance cpsHost) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsHost = ");
        String _name = NamingUtil.name((EObject)cpsHost);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.hostTransformationPerformance.start();
        int _size = this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsHost, null).size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            DeploymentHost depHost = this.createDepHost(cpsHost);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Adding host (");
            String _description = depHost.getDescription();
            _builder_1.append(_description);
            _builder_1.append(") to deployment model.");
            this.logger.debug((Object)_builder_1);
            EList _hosts = this.mapping.getDeployment().getHosts();
            _hosts.add((Object)depHost);
            this.addTrace((Identifiable)cpsHost, (DeploymentElement)depHost);
            this.hostTransformationPerformance.stop();
            this.logger.debug((Object)"Running application instance transformations.");
            Functions.Function1 _function = it -> {
                ApplicationType _type = it.getType();
                CyberPhysicalSystem _cps = null;
                if (_type != null) {
                    _cps = _type.getCps();
                }
                CyberPhysicalSystem _cps_1 = this.mapping.getCps();
                return Objects.equal((Object)_cps, (Object)_cps_1);
            };
            Consumer<ApplicationInstance> _function_1 = it -> this.transform((ApplicationInstance)it, depHost);
            IterableExtensions.filter((Iterable)cpsHost.getApplications(), (Functions.Function1)_function).forEach(_function_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Running application instance transformations finished");
            this.logger.debug((Object)_builder_2);
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Execution ended: transform");
            this.logger.trace((Object)_builder_3);
        } else {
            DeploymentElement element = ((Cps2depTraceMatch[])Conversions.unwrapArray(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsHost, null), Cps2depTraceMatch.class))[0].getDepElement();
            DeploymentHost depHost_1 = (DeploymentHost)element;
            this.hostTransformationPerformance.stop();
            this.logger.debug((Object)"Running application instance transformations.");
            Functions.Function1 _function_2 = it -> {
                ApplicationType _type = it.getType();
                CyberPhysicalSystem _cps = null;
                if (_type != null) {
                    _cps = _type.getCps();
                }
                CyberPhysicalSystem _cps_1 = this.mapping.getCps();
                return Objects.equal((Object)_cps, (Object)_cps_1);
            };
            Consumer<ApplicationInstance> _function_3 = it -> this.transform((ApplicationInstance)it, depHost_1);
            IterableExtensions.filter((Iterable)cpsHost.getApplications(), (Functions.Function1)_function_2).forEach(_function_3);
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("Running application instance transformations finished");
            this.logger.debug((Object)_builder_4);
            StringConcatenation _builder_5 = new StringConcatenation();
            _builder_5.append("Execution ended: transform");
            this.logger.trace((Object)_builder_5);
        }
    }

    private void transform(ApplicationInstance cpsInstance, DeploymentHost depHost) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsInstance = ");
        String _name = NamingUtil.name((EObject)cpsInstance);
        _builder.append(_name);
        _builder.append(", depHost = ");
        String _name_1 = NamingUtil.name((EObject)depHost);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.appTransformationPerformance.start();
        int _size = this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsInstance, null).size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            DeploymentApplication depApp = this.createDepApplication(cpsInstance);
            EList _applications = depHost.getApplications();
            _applications.add((Object)depApp);
            this.addTrace((Identifiable)cpsInstance, (DeploymentElement)depApp);
            this.appTransformationPerformance.stop();
            this.logger.debug((Object)"Running state machine transformations.");
            Stopwatch watch = Stopwatch.createStarted();
            StateMachine _behavior = cpsInstance.getType().getBehavior();
            if (_behavior != null) {
                this.transform(_behavior, depApp);
            }
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Running state machine transformations (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_1.append((Object)_elapsed);
            _builder_1.append(" ms)");
            this.logger.debug((Object)_builder_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Execution ended: transform");
            this.logger.trace((Object)_builder_2);
        } else {
            DeploymentElement _depElement = ((Cps2depTraceMatch[])Conversions.unwrapArray(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsInstance, null), Cps2depTraceMatch.class))[0].getDepElement();
            DeploymentApplication depApp_1 = (DeploymentApplication)_depElement;
            this.appTransformationPerformance.stop();
            this.logger.debug((Object)"Running state machine transformations.");
            Stopwatch watch_1 = Stopwatch.createStarted();
            StateMachine _behavior_1 = cpsInstance.getType().getBehavior();
            if (_behavior_1 != null) {
                this.transform(_behavior_1, depApp_1);
            }
            StringConcatenation _builder_3 = new StringConcatenation();
            _builder_3.append("Running state machine transformations (");
            long _elapsed_1 = watch_1.elapsed(TimeUnit.MILLISECONDS);
            _builder_3.append((Object)_elapsed_1);
            _builder_3.append(" ms)");
            this.logger.debug((Object)_builder_3);
            StringConcatenation _builder_4 = new StringConcatenation();
            _builder_4.append("Execution ended: transform");
            this.logger.trace((Object)_builder_4);
        }
    }

    private void transform(StateMachine cpsBehavior, DeploymentApplication depApp) {
        boolean _equals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsBehavior = ");
        String _name = NamingUtil.name((EObject)cpsBehavior);
        _builder.append(_name);
        _builder.append(", depApp = ");
        String _name_1 = NamingUtil.name((EObject)depApp);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.stateMachineTransformationPerformance.start();
        Collection<Sm2DeploymentbehaviorMatch> matches = this.cpsXformM2M.getSm2Deploymentbehavior(this.engine).getAllMatches(this.mapping, cpsBehavior, depApp, null);
        int _size = matches.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            boolean _tripleNotEquals;
            DeploymentBehavior depBehavior = this.createDepBehavior(cpsBehavior);
            depApp.setBehavior(depBehavior);
            this.addTraceOneToN((Identifiable)cpsBehavior, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depBehavior})));
            this.stateMachineTransformationPerformance.stop();
            this.logger.debug((Object)"Running state transformations.");
            Stopwatch watch = Stopwatch.createStarted();
            Consumer<State> _function = it -> this.transform((State)it, depBehavior);
            cpsBehavior.getStates().forEach(_function);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Running state transformations finished");
            this.logger.debug((Object)_builder_1);
            this.logger.debug((Object)"Resolving state relationships.");
            watch.reset().start();
            Consumer<State> _function_1 = it -> this.buildStateRelations((State)it, depBehavior, cpsBehavior);
            cpsBehavior.getStates().forEach(_function_1);
            StringConcatenation _builder_2 = new StringConcatenation();
            _builder_2.append("Resolving state relationships finished");
            this.logger.debug((Object)_builder_2);
            this.logger.debug((Object)"Resolving initial state.");
            this.stateMachineTransformationPerformance.start();
            watch.reset().start();
            State _initial = cpsBehavior.getInitial();
            boolean bl2 = _tripleNotEquals = _initial != null;
            if (_tripleNotEquals) {
                Functions.Function1 _function_2 = it -> it.getDepElement();
                Functions.Function1 _function_3 = it -> depBehavior.getStates().contains(it);
                depBehavior.setCurrent((BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.map(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)cpsBehavior.getInitial(), null), (Functions.Function1)_function_2), BehaviorState.class), (Functions.Function1)_function_3));
            } else {
                depBehavior.setCurrent(null);
            }
        }
        this.stateMachineTransformationPerformance.stop();
        StringConcatenation _builder_3 = new StringConcatenation();
        _builder_3.append("Resolving initial state finished");
        this.logger.debug((Object)_builder_3);
        StringConcatenation _builder_4 = new StringConcatenation();
        _builder_4.append("Execution ended: transform");
        this.logger.trace((Object)_builder_4);
    }

    private void transform(State cpsState, DeploymentBehavior depBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: transform(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append(_name);
        _builder.append(", depBehavior = ");
        String _name_1 = NamingUtil.name((EObject)depBehavior);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.stateTransformationPerformance.start();
        BehaviorState depState = this.createDepState(cpsState);
        EList _states = depBehavior.getStates();
        _states.add((Object)depState);
        this.addTraceOneToN((Identifiable)cpsState, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depState})));
        this.stateTable.put((Object)cpsState, (Object)depBehavior, (Object)depState);
        this.stateTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: transform");
        this.logger.trace((Object)_builder_1);
    }

    private void buildStateRelations(State cpsState, DeploymentBehavior depBehavior, StateMachine cpsBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: buildStateRelations(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append(_name);
        _builder.append(", depBehavior = ");
        String _name_1 = NamingUtil.name((EObject)depBehavior);
        _builder.append(_name_1);
        _builder.append(", cpsBehavior = ");
        String _name_2 = NamingUtil.name((EObject)cpsBehavior);
        _builder.append(_name_2);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.transitionTransformationPerformance.start();
        BehaviorState depState = (BehaviorState)this.stateTable.get((Object)cpsState, (Object)depBehavior);
        Functions.Function1 _function = it -> it.getTargetState() != null && cpsBehavior.getStates().contains((Object)it.getTargetState());
        Consumer<Transition> _function_1 = it -> this.mapTransition((Transition)it, depState, depBehavior);
        IterableExtensions.filter((Iterable)cpsState.getOutgoingTransitions(), (Functions.Function1)_function).forEach(_function_1);
        this.transitionTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: buildStateRelations");
        this.logger.trace((Object)_builder_1);
    }

    private void mapTransition(Transition transition, BehaviorState depState, DeploymentBehavior depBehavior) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: mapTransition(transition = ");
        String _name = NamingUtil.name((EObject)transition);
        _builder.append(_name);
        _builder.append(", depState = ");
        String _name_1 = NamingUtil.name((EObject)depState);
        _builder.append(_name_1);
        _builder.append(", depBehavior = ");
        String _name_2 = NamingUtil.name((EObject)depBehavior);
        _builder.append(_name_2);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        BehaviorTransition depTransition = this.createDepTransition(transition);
        EList _outgoing = depState.getOutgoing();
        _outgoing.add((Object)depTransition);
        EList _transitions = depBehavior.getTransitions();
        _transitions.add((Object)depTransition);
        this.otherTimer.start();
        this.addTraceOneToN((Identifiable)transition, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new DeploymentElement[]{depTransition})));
        this.otherTimer.stop();
        Functions.Function1 _function = it -> it.getDepElement();
        Functions.Function1 _function_1 = it -> depBehavior.getStates().contains(it);
        depTransition.setTo((BehaviorState)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)IterableExtensions.map(this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)transition.getTargetState(), null), (Functions.Function1)_function), BehaviorState.class), (Functions.Function1)_function_1));
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: mapTransition");
        this.logger.trace((Object)_builder_1);
    }

    private void mapAction(BehaviorTransition depSendTransition) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: mapAction(depTrigger = ");
        String _name = NamingUtil.name((EObject)depSendTransition);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        this.triggerTransformationPerformance.start();
        Identifiable _head = (Identifiable)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfcpsElement(this.mapping, null, (DeploymentElement)depSendTransition));
        Transition cpsSendTransition = (Transition)_head;
        Iterable cpsWaitTransitions = Iterables.filter(this.cpsXformM2M.getTriggerPair(this.engine).getAllValuesOfcpsTarget(cpsSendTransition), Transition.class);
        EObject _eContainer = depSendTransition.eContainer().eContainer();
        DeploymentApplication senderDepApp = (DeploymentApplication)_eContainer;
        Identifiable _head_1 = (Identifiable)IterableExtensions.head(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOfcpsElement(this.mapping, null, (DeploymentElement)senderDepApp));
        ApplicationInstance cpsSendAppInstance = (ApplicationInstance)_head_1;
        Consumer<Transition> _function = cpsWaitTransition -> {
            Set<ApplicationInstance> cpsWaitAppInstances = this.cpsXformM2M.getCpsApplicationTransition(this.engine).getAllValuesOfcpsApp((Transition)cpsWaitTransition);
            Functions.Function1 _function_1 = it -> this.cpsXformM2M.getCommunicatingAppInstances(this.engine).hasMatch(cpsSendAppInstance, (ApplicationInstance)it);
            Iterable communicatingWaitAppInstances = IterableExtensions.filter(cpsWaitAppInstances, (Functions.Function1)_function_1);
            Consumer<ApplicationInstance> _function_2 = cpsWaitAppInstance -> {
                CPS2DeploymentTrace waitTransitionTrace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(this.mapping, (Identifiable)cpsWaitTransition, null), CPS2DeploymentTrace.class));
                CPS2DeploymentTrace waitAppInstanceTrace = (CPS2DeploymentTrace)IterableExtensions.head((Iterable)Iterables.filter(this.cpsXformM2M.getCps2depTrace(this.engine).getAllValuesOftrace(this.mapping, (Identifiable)cpsWaitAppInstance, null), CPS2DeploymentTrace.class));
                DeploymentApplication depWaitApp = (DeploymentApplication)IterableExtensions.head((Iterable)Iterables.filter((Iterable)waitAppInstanceTrace.getDeploymentElements(), DeploymentApplication.class));
                Functions.Function1 _function_3 = it -> {
                    EObject _eContainer_1 = it.eContainer().eContainer();
                    return Objects.equal((Object)depWaitApp, (Object)_eContainer_1);
                };
                BehaviorTransition depWaitTransition = (BehaviorTransition)IterableExtensions.findFirst((Iterable)Iterables.filter((Iterable)waitTransitionTrace.getDeploymentElements(), BehaviorTransition.class), (Functions.Function1)_function_3);
                EList _trigger = depSendTransition.getTrigger();
                _trigger.add((Object)depWaitTransition);
            };
            communicatingWaitAppInstances.forEach(_function_2);
        };
        cpsWaitTransitions.forEach(_function);
        this.triggerTransformationPerformance.stop();
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: mapAction");
        this.logger.trace((Object)_builder_1);
    }

    private DeploymentHost createDepHost(HostInstance cpsHost) {
        DeploymentHost _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepHost(cpsHost = ");
        String _name = NamingUtil.name((EObject)cpsHost);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        DeploymentHost depHost = this.depFactory.createDeploymentHost();
        depHost.setIp(cpsHost.getNodeIp());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepHost");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depHost;
        return _xblockexpression;
    }

    private DeploymentApplication createDepApplication(ApplicationInstance cpsAppInstance) {
        DeploymentApplication _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepApplication(cpsAppInstance = ");
        String _name = NamingUtil.name((EObject)cpsAppInstance);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        DeploymentApplication depApp = this.depFactory.createDeploymentApplication();
        depApp.setId(cpsAppInstance.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution: createDepApplication");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depApp;
        return _xblockexpression;
    }

    private DeploymentBehavior createDepBehavior(StateMachine cpsBehavior) {
        DeploymentBehavior _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepBehavior(cpsBehavior = ");
        String _name = NamingUtil.name((EObject)cpsBehavior);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        DeploymentBehavior depBehavior = this.depFactory.createDeploymentBehavior();
        depBehavior.setDescription(cpsBehavior.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepBehavior");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depBehavior;
        return _xblockexpression;
    }

    private BehaviorState createDepState(State cpsState) {
        BehaviorState _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepState(cpsState = ");
        String _name = NamingUtil.name((EObject)cpsState);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        BehaviorState depState = this.depFactory.createBehaviorState();
        depState.setDescription(cpsState.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepState");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depState;
        return _xblockexpression;
    }

    private BehaviorTransition createDepTransition(Transition cpsTransition) {
        BehaviorTransition _xblockexpression = null;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: createDepTransition(cpsTransition = ");
        String _name = NamingUtil.name((EObject)cpsTransition);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        BehaviorTransition depTransition = this.depFactory.createBehaviorTransition();
        depTransition.setDescription(cpsTransition.getIdentifier());
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: createDepTransition");
        this.logger.trace((Object)_builder_1);
        _xblockexpression = depTransition;
        return _xblockexpression;
    }

    private void clearModel(ChangeDelta delta) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: clearModel(ChangeDelta delta)");
        this.logger.trace((Object)_builder);
        Consumer<IPatternMatch> _function = b -> {
            if (b instanceof HostInstancesMatch) {
                this.removeHostInstance(((HostInstancesMatch)((Object)b)).getHostInstance());
            }
            if (b instanceof AppTypesMatch) {
                this.removeAppType(((AppTypesMatch)((Object)b)).getAppType());
            }
            if (b instanceof AppInstancesMatch) {
                this.removeAppInstance(((AppInstancesMatch)((Object)b)).getAppInstance());
            }
            if (b instanceof StateMachinesMatch) {
                this.removeStateMachine(((StateMachinesMatch)((Object)b)).getStateMachine(), true);
            }
            if (b instanceof StatesMatch) {
                State state = ((StatesMatch)((Object)b)).getState();
                this.removeState(state);
                Consumer<State2StatemachineMatch> _function_1 = match -> this.removeStateMachine(match.getSm(), true);
                this.cpsXformM2M.getState2Statemachine(this.engine).getAllMatches(state, null).forEach(_function_1);
            }
            if (b instanceof TransitionsMatch) {
                Transition transition = ((TransitionsMatch)((Object)b)).getTransition();
                String action = this.transitionMap.get(transition);
                if (action != null && SignalUtil.isWait((String)action)) {
                    String id = SignalUtil.getSignalId((String)action);
                    Consumer<SendTransitionAppSignalMatch> _function_2 = match -> {
                        this.removeTransition(match.getTransition());
                        Consumer<Transition2StateMachineMatch> _function_3 = m -> this.removeStateMachine(m.getSm(), true);
                        this.cpsXformM2M.getTransition2StateMachine(this.engine).getAllMatches(match.getTransition(), null).forEach(_function_3);
                    };
                    this.cpsXformM2M.getSendTransitionAppSignal(this.engine).getAllMatches(null, null, id).forEach(_function_2);
                }
                this.removeTransition(transition);
                Consumer<Transition2StateMachineMatch> _function_3 = match -> this.removeStateMachine(match.getSm(), true);
                this.cpsXformM2M.getTransition2StateMachine(this.engine).getAllMatches(transition, null).forEach(_function_3);
            }
        };
        Stream.concat(delta.getAllDisappeared().stream(), delta.getAllUpdated().stream()).forEach(_function);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: clearModel");
        this.logger.trace((Object)_builder_1);
    }

    private void removeHostInstance(HostInstance host) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: removeHostInstance(app = ");
        String _name = NamingUtil.name((EObject)host);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        Consumer<Cps2depTraceMatch> _function = c -> {
            this.mapping.getTraces().remove((Object)c.getTrace());
            this.mapping.getDeployment().getHosts().remove((Object)c.getDepElement());
        };
        this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)host, null).forEach(_function);
        Consumer<ApplicationInstance> _function_1 = app -> this.removeAppInstance((ApplicationInstance)app);
        host.getApplications().forEach(_function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: removeHostInstance");
        this.logger.trace((Object)_builder_1);
    }

    private void removeAppInstance(ApplicationInstance app) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: removeAppinstance(app = ");
        String _name = NamingUtil.name((EObject)app);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        Consumer<Cps2depTraceMatch> _function = c -> {
            boolean _tripleNotEquals;
            DeploymentElement _depElement = c.getDepElement();
            boolean bl = _tripleNotEquals = _depElement != null;
            if (_tripleNotEquals) {
                this.mapping.getTraces().remove((Object)c.getTrace());
                DeploymentElement _depElement_1 = c.getDepElement();
                DeploymentApplication depapp = (DeploymentApplication)_depElement_1;
                Consumer<DepApp2depHostMatch> _function_1 = match -> {
                    DeploymentHost host = match.getDephost();
                    host.getApplications().remove((Object)depapp);
                };
                this.cpsXformM2M.getDepApp2depHost(this.engine).getAllMatches(depapp, null).forEach(_function_1);
            }
        };
        this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)app, null).forEach(_function);
        ApplicationType _type = app.getType();
        StateMachine _behavior = null;
        if (_type != null) {
            _behavior = _type.getBehavior();
        }
        if (_behavior != null) {
            this.removeStateMachine(_behavior, true);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: removeAppinstance");
        this.logger.trace((Object)_builder_1);
    }

    private void removeAppType(ApplicationType app) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: removeAppType(app = ");
        String _name = NamingUtil.name((EObject)app);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        StateMachine _behavior = app.getBehavior();
        if (_behavior != null) {
            this.removeStateMachine(_behavior, true);
        }
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: removeAppType");
        this.logger.trace((Object)_builder_1);
    }

    private void removeStateMachine(StateMachine sm, boolean recursive) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: removeStateMachine(sm = ");
        String _name = NamingUtil.name((EObject)sm);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        Consumer<Cps2depTraceMatch> _function = c -> {
            boolean _tripleNotEquals;
            DeploymentElement _depElement = c.getDepElement();
            boolean bl = _tripleNotEquals = _depElement != null;
            if (_tripleNotEquals) {
                this.mapping.getTraces().remove((Object)c.getTrace());
                DeploymentElement _depElement_1 = c.getDepElement();
                DeploymentBehavior depBehavior = (DeploymentBehavior)_depElement_1;
                Consumer<DepBehavior2depAppMatch> _function_1 = match -> {
                    DeploymentApplication app = match.getDepapp();
                    app.setBehavior(null);
                };
                this.cpsXformM2M.getDepBehavior2depApp(this.engine).getAllMatches(depBehavior, null).forEach(_function_1);
            }
        };
        this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)sm, null).forEach(_function);
        Consumer<State> _function_1 = state -> {
            this.removeState((State)state);
            Consumer<Transition> _function_2 = trans -> {
                String action;
                if (recursive && (action = this.transitionMap.get(trans)) != null && SignalUtil.isWait((String)action)) {
                    String id = SignalUtil.getSignalId((String)action);
                    Consumer<SendTransitionAppSignalMatch> _function_3 = match -> {
                        Consumer<Transition2StateMachineMatch> _function_4 = m -> {
                            boolean _not;
                            boolean _equals = m.getSm().equals(sm);
                            boolean bl = _not = !_equals;
                            if (_not) {
                                this.removeStateMachine(m.getSm(), false);
                            }
                        };
                        this.cpsXformM2M.getTransition2StateMachine(this.engine).getAllMatches(match.getTransition(), null).forEach(_function_4);
                    };
                    this.cpsXformM2M.getSendTransitionAppSignal(this.engine).getAllMatches(null, null, id).forEach(_function_3);
                }
                this.removeTransition((Transition)trans);
            };
            state.getOutgoingTransitions().forEach(_function_2);
        };
        sm.getStates().forEach(_function_1);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: removeState");
        this.logger.trace((Object)_builder_1);
    }

    private void removeState(State state) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: removeState(trans = ");
        String _name = NamingUtil.name((EObject)state);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        Consumer<Cps2depTraceMatch> _function = c -> {
            boolean _tripleNotEquals;
            DeploymentElement _depElement = c.getDepElement();
            boolean bl = _tripleNotEquals = _depElement != null;
            if (_tripleNotEquals) {
                this.mapping.getTraces().remove((Object)c.getTrace());
            }
        };
        this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)state, null).forEach(_function);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: removeState");
        this.logger.trace((Object)_builder_1);
    }

    private void removeTransition(Transition trans) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: removeTransition(trans = ");
        String _name = NamingUtil.name((EObject)trans);
        _builder.append(_name);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        Consumer<Cps2depTraceMatch> _function = c -> {
            boolean _tripleNotEquals;
            DeploymentElement _depElement = c.getDepElement();
            boolean bl = _tripleNotEquals = _depElement != null;
            if (_tripleNotEquals) {
                this.mapping.getTraces().remove((Object)c.getTrace());
                DeploymentElement _depElement_1 = c.getDepElement();
                BehaviorTransition depTrans = (BehaviorTransition)_depElement_1;
                depTrans.getTrigger().clear();
            }
        };
        this.cpsXformM2M.getCps2depTrace(this.engine).getAllMatches(this.mapping, null, (Identifiable)trans, null).forEach(_function);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Execution ended: removeTransition");
        this.logger.trace((Object)_builder_1);
    }

    private void addTraceOneToN(Identifiable cpsElement, List<? extends DeploymentElement> depElements) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: addTraceOneToN(cpsElement = ");
        String _name = NamingUtil.name((EObject)cpsElement);
        _builder.append(_name);
        _builder.append(", depElements = [");
        boolean _hasElements = false;
        for (DeploymentElement deploymentElement : depElements) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            String _name_1 = NamingUtil.name((EObject)deploymentElement);
            _builder.append(_name_1);
        }
        _builder.append("])");
        this.logger.trace((Object)_builder);
        CPS2DeploymentTrace trace = this.traceTable.get(cpsElement);
        if (trace == null) {
            trace = this.tracFactory.createCPS2DeploymentTrace();
            this.traceTable.put(cpsElement, trace);
            EList eList = trace.getCpsElements();
            eList.add((Object)cpsElement);
        }
        EList eList = trace.getDeploymentElements();
        Iterables.addAll((Collection)eList, depElements);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Adding trace (");
        String _name_2 = NamingUtil.name((EObject)cpsElement);
        _builder_1.append(_name_2);
        _builder_1.append("->[");
        boolean _hasElements_1 = false;
        for (DeploymentElement deploymentElement : depElements) {
            if (!_hasElements_1) {
                _hasElements_1 = true;
            } else {
                _builder_1.appendImmediate((Object)", ", "");
            }
            String _name_3 = NamingUtil.name((EObject)deploymentElement);
            _builder_1.append(_name_3);
        }
        _builder_1.append("]) to traceability model.");
        this.logger.debug((Object)_builder_1);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("Execution ended: addTraceOneToN");
        this.logger.trace((Object)stringConcatenation);
    }

    private void addTrace(Identifiable cpsElement, DeploymentElement depElement) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing: addTrace(cpsElement = ");
        String _name = NamingUtil.name((EObject)cpsElement);
        _builder.append(_name);
        _builder.append(", depElement = ");
        String _name_1 = NamingUtil.name((EObject)depElement);
        _builder.append(_name_1);
        _builder.append(")");
        this.logger.trace((Object)_builder);
        CPS2DeploymentTrace trace = this.tracFactory.createCPS2DeploymentTrace();
        EList _cpsElements = trace.getCpsElements();
        _cpsElements.add((Object)cpsElement);
        EList _deploymentElements = trace.getDeploymentElements();
        _deploymentElements.add((Object)depElement);
        StringConcatenation _builder_1 = new StringConcatenation();
        _builder_1.append("Adding trace (");
        String _name_2 = NamingUtil.name((EObject)cpsElement);
        _builder_1.append(_name_2);
        _builder_1.append("->");
        String _name_3 = NamingUtil.name((EObject)depElement);
        _builder_1.append(_name_3);
        _builder_1.append(") to traceability model.");
        this.logger.debug((Object)_builder_1);
        EList _traces = this.mapping.getTraces();
        _traces.add((Object)trace);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("Execution ended: addTrace");
        this.logger.trace((Object)_builder_2);
    }

    public void dispose() {
        this.logger.trace((Object)"dispose");
        if (this.monitor != null) {
            this.monitor.dispose();
        }
        this.monitor = null;
    }
}

