/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.deployment.Deployment;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.patterns.CpsXformM2M;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.viatra.rules.RuleProvider;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.debug.configuration.TransformationDebuggerConfiguration;
import org.eclipse.viatra.transformation.evm.api.Scheduler;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdapterConfiguration;
import org.eclipse.viatra.transformation.evm.api.resolver.ConflictResolver;
import org.eclipse.viatra.transformation.evm.specific.resolver.InvertedDisappearancePriorityConflictResolver;
import org.eclipse.viatra.transformation.runtime.emf.transformation.eventdriven.EventDrivenTransformation;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Extension;

public class CPS2DeploymentTransformationViatra {
    @Extension
    private Logger logger = Logger.getLogger((String)"cps.xform.m2m.incr.viatra");
    @Extension
    private CpsXformM2M cpsXformM2M = CpsXformM2M.instance();
    @Extension
    private RuleProvider ruleProvider;
    private CPSToDeployment cps2dep;
    private ViatraQueryEngine engine;
    private EventDrivenTransformation transform;
    private Scheduler.ISchedulerFactory factory;
    private boolean initialized = false;

    public boolean initialize(CPSToDeployment cps2dep, ViatraQueryEngine engine) {
        return this.initialize(cps2dep, engine, false, null);
    }

    public boolean initialize(CPSToDeployment cps2dep, ViatraQueryEngine engine, boolean isDebuggable, String debugName) {
        boolean _xblockexpression = false;
        Preconditions.checkArgument((cps2dep != null ? 1 : 0) != 0, (Object)"Mapping cannot be null!");
        CyberPhysicalSystem _cps = cps2dep.getCps();
        boolean _tripleNotEquals = _cps != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals, (Object)"CPS not defined in mapping!");
        Deployment _deployment = cps2dep.getDeployment();
        boolean _tripleNotEquals_1 = _deployment != null;
        Preconditions.checkArgument((boolean)_tripleNotEquals_1, (Object)"Deployment not defined in mapping!");
        Preconditions.checkArgument((engine != null ? 1 : 0) != 0, (Object)"Engine cannot be null!");
        boolean _xifexpression = false;
        if (!this.initialized) {
            RuleProvider _ruleProvider;
            boolean _xblockexpression_1 = false;
            this.cps2dep = cps2dep;
            this.engine = engine;
            this.logger.debug((Object)"Preparing queries on engine.");
            Stopwatch watch = Stopwatch.createStarted();
            this.cpsXformM2M.prepare(engine);
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Prepared queries on engine (");
            long _elapsed = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder.append((Object)_elapsed);
            _builder.append(" ms)");
            this.logger.info((Object)_builder);
            this.logger.info((Object)"Preparing transformation rules.");
            watch = Stopwatch.createStarted();
            this.ruleProvider = _ruleProvider = new RuleProvider(engine, cps2dep);
            this.createTransformation(isDebuggable, debugName);
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("Prepared transformation rules (");
            long _elapsed_1 = watch.elapsed(TimeUnit.MILLISECONDS);
            _builder_1.append((Object)_elapsed_1);
            _builder_1.append(" ms)");
            this.logger.info((Object)_builder_1);
            this.initialized = true;
            _xifexpression = _xblockexpression_1 = true;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public void execute() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Executing transformation on: Cyber-physical system: ");
        String _identifier = this.cps2dep.getCps().getIdentifier();
        _builder.append(_identifier);
        this.logger.debug((Object)_builder);
        if (this.factory == null) {
            this.transform.getExecutionSchema().startUnscheduledExecution();
        }
    }

    public Scheduler.ISchedulerFactory setScheduler(Scheduler.ISchedulerFactory factory) {
        this.factory = factory;
        return this.factory;
    }

    private EventDrivenTransformation createTransformation(boolean isDebuggable, String debugName) {
        EventDrivenTransformation _xblockexpression = null;
        InvertedDisappearancePriorityConflictResolver fixedPriorityResolver = new InvertedDisappearancePriorityConflictResolver();
        fixedPriorityResolver.setPriority(this.ruleProvider.getHostRule().getRuleSpecification(), 1);
        fixedPriorityResolver.setPriority(this.ruleProvider.getApplicationRule().getRuleSpecification(), 2);
        fixedPriorityResolver.setPriority(this.ruleProvider.getStateMachineRule().getRuleSpecification(), 3);
        fixedPriorityResolver.setPriority(this.ruleProvider.getStateRule().getRuleSpecification(), 4);
        fixedPriorityResolver.setPriority(this.ruleProvider.getTransitionRule().getRuleSpecification(), 5);
        fixedPriorityResolver.setPriority(this.ruleProvider.getTriggerRule().getRuleSpecification(), 6);
        EventDrivenTransformation.EventDrivenTransformationBuilder builder = EventDrivenTransformation.forEngine((ViatraQueryEngine)this.engine).setConflictResolver((ConflictResolver)fixedPriorityResolver).addRule(this.ruleProvider.getHostRule()).addRule(this.ruleProvider.getApplicationRule()).addRule(this.ruleProvider.getStateMachineRule()).addRule(this.ruleProvider.getStateRule()).addRule(this.ruleProvider.getTransitionRule()).addRule(this.ruleProvider.getTriggerRule());
        if (this.factory != null) {
            builder.setSchedulerFactory(this.factory);
        }
        if (isDebuggable) {
            String _elvis = null;
            _elvis = debugName != null ? debugName : "CPS2DeploymentTransformationViatra";
            TransformationDebuggerConfiguration debuggerConfig = new TransformationDebuggerConfiguration(_elvis);
            builder.addAdapterConfiguration((IAdapterConfiguration)debuggerConfig);
        }
        _xblockexpression = this.transform = builder.build();
        return _xblockexpression;
    }

    public void dispose() {
        if (this.transform != null) {
            this.transform.getExecutionSchema().dispose();
        }
        this.transform = null;
    }
}

