/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui.labeling;

import com.google.inject.Inject;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.patternlanguage.emf.annotations.PatternAnnotationProvider;
import org.eclipse.viatra.query.patternlanguage.emf.types.ITypeInferrer;
import org.eclipse.viatra.query.patternlanguage.emf.types.ITypeSystem;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Annotation;
import org.eclipse.viatra.query.patternlanguage.emf.vql.AnnotationParameter;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Expression;
import org.eclipse.viatra.query.patternlanguage.emf.vql.PackageImport;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Variable;
import org.eclipse.viatra.query.patternlanguage.emf.vql.VariableReference;
import org.eclipse.viatra.query.runtime.emf.types.EClassTransitiveInstancesKey;
import org.eclipse.viatra.query.runtime.emf.types.EDataTypeInSlotsKey;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.tooling.core.generator.genmodel.IVQGenmodelProvider;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.ui.hover.XbaseHoverDocumentationProvider;

public class EMFPatternLanguageHoverDocumentationProvider
extends XbaseHoverDocumentationProvider {
    @Inject
    private IVQGenmodelProvider genmodelProvider;
    @Inject
    private PatternAnnotationProvider annotationProvider;
    @Inject
    private ITypeSystem typeSystem;
    @Inject
    private ITypeInferrer typeInferrer;

    public String computeDocumentation(EObject object) {
        if (object instanceof Annotation) {
            String description = this.annotationProvider.getDescription((Annotation)object);
            if (this.annotationProvider.isDeprecated((Annotation)object)) {
                return "<b>@deprecated</b></p></p>" + description;
            }
            return description;
        }
        if (object instanceof AnnotationParameter) {
            String description = this.annotationProvider.getDescription((AnnotationParameter)object);
            if (this.annotationProvider.isDeprecated((AnnotationParameter)object)) {
                return "<b>@deprecated</b></p></p>" + description;
            }
            return description;
        }
        if (object instanceof PackageImport) {
            PackageImport packageImport = (PackageImport)object;
            GenPackage genPackage = this.genmodelProvider.findGenPackage((EObject)packageImport, packageImport.getEPackage());
            if (genPackage != null) {
                return String.format("<b>Genmodel found</b>: %s<br/><b>Package uri</b>: %s", genPackage.eResource().getURI().toString(), genPackage.getEcorePackage().eResource().getURI().toString());
            }
        } else {
            if (object instanceof Variable) {
                Variable variable = (Variable)object;
                return this.calculateVariableHover(variable);
            }
            if (object instanceof VariableReference) {
                VariableReference reference = (VariableReference)object;
                return this.calculateVariableHover(reference.getVariable());
            }
            if (object instanceof Pattern) {
                Pattern pattern = (Pattern)object;
                StringBuilder sb = new StringBuilder();
                sb.append(super.computeDocumentation((EObject)pattern));
                sb.append("<p><strong>Parameters:</strong></p>");
                sb.append("<ul>");
                for (Variable variable : pattern.getParameters()) {
                    sb.append("<li>");
                    sb.append("<strong>Parameter</strong> ");
                    sb.append(variable.getName());
                    IInputKey type = this.typeInferrer.getType((Expression)variable);
                    if (type != null) {
                        sb.append(": ");
                        sb.append("<i>");
                        sb.append(this.typeSystem.typeString(type));
                        sb.append("</i>");
                    }
                    sb.append("</li>");
                }
                sb.append("</ul>");
                return sb.toString();
            }
        }
        return super.computeDocumentation(object);
    }

    private String calculateVariableHover(Variable variable) {
        JvmTypeReference type = this.typeInferrer.getJvmType((Expression)variable, (EObject)variable);
        IInputKey emfType = this.typeInferrer.getType((Expression)variable);
        String javaTypeString = type.getQualifiedName();
        String emfTypeString = emfType instanceof EClassTransitiveInstancesKey ? this.getTypeString((EClassifier)((EClassTransitiveInstancesKey)emfType).getEmfKey()) : (emfType instanceof EDataTypeInSlotsKey ? this.getTypeString((EClassifier)((EDataTypeInSlotsKey)emfType).getEmfKey()) : "Not applicable");
        return String.format("<b>EMF Type</b>: %s<br /><b>Java Type</b>: %s", emfTypeString, javaTypeString);
    }

    private String getTypeString(EClassifier emfType) {
        String packageUri = emfType.getEPackage() != null ? "(<i>" + emfType.getEPackage().getNsURI() + "</i>)" : "";
        String emfTypeString = String.format("%s %s", emfType.getName(), packageUri);
        return emfTypeString;
    }
}

