/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.MatchingFrameValueProvider;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.psystem.IExpressionEvaluator;
import org.eclipse.viatra.query.runtime.matchers.psystem.IValueProvider;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ExpressionEval
extends ExtendOperation {
    IExpressionEvaluator evaluator;
    Map<String, Integer> nameMap;

    public ExpressionEval(IExpressionEvaluator evaluator, Map<String, Integer> nameMap, int position) {
        super(position);
        this.evaluator = evaluator;
        this.nameMap = nameMap;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        try {
            Object result = this.evaluator.evaluateExpression((IValueProvider)new MatchingFrameValueProvider(frame, this.nameMap));
            this.it = result != null ? Collections.singletonList(result).iterator() : Collections.emptyIterator();
        }
        catch (Exception e) {
            Logger logger = ViatraQueryLoggingUtil.getLogger(this.getClass());
            logger.warn((Object)"Error while evaluating expression", (Throwable)e);
            this.it = Collections.emptyIterator();
        }
    }

    public String toString() {
        return "extend    -" + this.position + " = expression " + this.evaluator.getShortDescription();
    }

    @Override
    public List<Integer> getVariablePositions() {
        ArrayList<Integer> variables = new ArrayList<Integer>();
        variables.addAll(this.nameMap.values());
        return variables;
    }
}

