/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public class IterateOverChildren
extends ExtendOperation {
    private int sourcePosition;
    private boolean transitive;

    public IterateOverChildren(int position, int sourcePosition, boolean transitive) {
        super(position);
        this.sourcePosition = sourcePosition;
        this.transitive = transitive;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) {
        Preconditions.checkState((boolean)(frame.get(this.sourcePosition) instanceof EObject), (String)"Only children of EObject elements are supported.");
        EObject source = (EObject)frame.get(this.sourcePosition);
        this.it = this.transitive ? source.eAllContents() : source.eContents().iterator();
    }

    public String toString() {
        return "extend    containment +" + this.sourcePosition + " <>--> -" + this.position + (this.transitive ? " transitively" : " directly");
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position, this.sourcePosition);
    }
}

