/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtend2.lib.StringConcatenation;

class QueryResultTreeLabelProvider
extends ColumnLabelProvider {
    private final ImageRegistry imageRegistry = ViatraQueryGUIPlugin.getDefault().getImageRegistry();
    private AdapterFactoryLabelProvider adapterFactoryLabelProvider;
    private static final String QUERY_EXPLORER_ANNOTATION = "QueryExplorer";

    public QueryResultTreeLabelProvider() {
        AdapterFactoryLabelProvider _adapterFactoryLabelProvider;
        AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
        this.adapterFactoryLabelProvider = _adapterFactoryLabelProvider = new AdapterFactoryLabelProvider(adapterFactory);
    }

    public Image getImage(Object element) {
        return this.getImageInternal(element);
    }

    protected Image _getImageInternal(QueryResultTreeInput element) {
        return this.imageRegistry.get("navigator_root");
    }

    protected Image _getImageInternal(QueryResultTreeMatcher<?> element) {
        Image _xifexpression = null;
        Exception _exception = element.getException();
        boolean _tripleNotEquals = _exception != null;
        _xifexpression = _tripleNotEquals ? this.imageRegistry.get("error") : this.imageRegistry.get("matcher");
        return _xifexpression;
    }

    protected Image _getImageInternal(IPatternMatch element) {
        return this.imageRegistry.get("match");
    }

    protected Image _getImageInternal(Object element) {
        return this.adapterFactoryLabelProvider.getImage(element);
    }

    public String getText(Object element) {
        return this.getTextInternal(element);
    }

    protected String _getTextInternal(QueryResultTreeInput element) {
        return element.getEngine().toString();
    }

    protected String _getTextInternal(QueryResultTreeMatcher<?> element) {
        boolean _tripleNotEquals;
        Exception _exception = element.getException();
        boolean bl = _tripleNotEquals = _exception != null;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            IQuerySpecificationRegistryEntry _entry = element.getEntry();
            String _fullyQualifiedName = null;
            if (_entry != null) {
                _fullyQualifiedName = _entry.getFullyQualifiedName();
            }
            _builder.append(_fullyQualifiedName);
            _builder.append(" - ");
            String _message = element.getException().getMessage();
            _builder.append(_message);
            return _builder.toString();
        }
        ViatraQueryMatcher<?> matcher = element.getMatcher();
        int count = element.getMatchCount();
        String _switchResult = null;
        switch (count) {
            case 0: {
                _switchResult = "No matches";
                break;
            }
            case 1: {
                _switchResult = "1 match";
                break;
            }
            default: {
                StringConcatenation _builder_1 = new StringConcatenation();
                _builder_1.append((Object)count);
                _builder_1.append(" matches");
                _switchResult = _builder_1.toString();
            }
        }
        String countMsg = _switchResult;
        String _xifexpression = null;
        boolean _isFiltered = element.isFiltered();
        _xifexpression = _isFiltered ? " (Filtered)" : "";
        String filterMsg = _xifexpression;
        StringConcatenation _builder_1 = new StringConcatenation();
        String _fullyQualifiedName_1 = matcher.getSpecification().getFullyQualifiedName();
        _builder_1.append(_fullyQualifiedName_1);
        _builder_1.append(" - ");
        _builder_1.append(countMsg);
        _builder_1.append(filterMsg);
        return _builder_1.toString();
    }

    protected String _getTextInternal(IPatternMatch element) {
        String message = this.getMessage(element);
        if (message != null) {
            Function<Object, String> _function = it -> this.adapterFactoryLabelProvider.getText(it);
            return ViatraQueryRuntimeHelper.getMessage((IPatternMatch)element, (String)message, _function);
        }
        return element.prettyPrint();
    }

    protected String _getTextInternal(Object element) {
        return this.adapterFactoryLabelProvider.getText(element);
    }

    public String getMessage(IPatternMatch match) {
        Function<PAnnotation, Optional> _function = it -> it.getFirstValue("message", String.class);
        Optional _flatMap = match.specification().getFirstAnnotationByName(QUERY_EXPLORER_ANNOTATION).flatMap(_function);
        String _xifexpression = null;
        boolean _isEmpty = match.parameterNames().isEmpty();
        if (_isEmpty) {
            _xifexpression = "(Match)";
        } else {
            StringConcatenation _builder = new StringConcatenation();
            List _parameterNames = match.parameterNames();
            boolean _hasElements = false;
            for (String param : _parameterNames) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                _builder.append(param);
                _builder.append("=$");
                _builder.append(param);
                _builder.append("$");
            }
            _xifexpression = _builder.toString();
        }
        return _flatMap.orElse(_xifexpression);
    }

    public Image getImageInternal(Object element) {
        if (element instanceof IPatternMatch) {
            return this._getImageInternal((IPatternMatch)element);
        }
        if (element instanceof QueryResultTreeInput) {
            return this._getImageInternal((QueryResultTreeInput)element);
        }
        if (element instanceof QueryResultTreeMatcher) {
            return this._getImageInternal((QueryResultTreeMatcher)element);
        }
        if (element != null) {
            return this._getImageInternal(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }

    public String getTextInternal(Object element) {
        if (element instanceof IPatternMatch) {
            return this._getTextInternal((IPatternMatch)element);
        }
        if (element instanceof QueryResultTreeInput) {
            return this._getTextInternal((QueryResultTreeInput)element);
        }
        if (element instanceof QueryResultTreeMatcher) {
            return this._getTextInternal((QueryResultTreeMatcher)element);
        }
        if (element != null) {
            return this._getTextInternal(element);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(element).toString());
    }
}

