/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.transactions.specific.job;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.CompositeJob;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.transactions.specific.job.EventAtomEditingDomainProvider;

public class RecordingJob<EventAtom>
extends CompositeJob<EventAtom> {
    public static final String TRANSACTIONAL_EDITING_DOMAIN = "org.eclipse.viatra.transformation.evm.CommandExecutingJob.EditingDomain";
    public static final String RECORDING_JOB = "org.eclipse.viatra.transformation.evm.specifc.RecordingJobExecution";
    public static final String RECORDING_JOB_SESSION_DATA_KEY = "org.eclipse.viatra.transformation.evm.specific.RecordingJob.SessionData";
    private final EventAtomEditingDomainProvider<EventAtom> provider;
    private final ICommandRecorder<EventAtom> commandRecorder;

    public RecordingJob(Job<EventAtom> recordedJob) {
        super(recordedJob);
        this.provider = null;
        this.commandRecorder = null;
    }

    public RecordingJob(Job<EventAtom> recordedJob, EventAtomEditingDomainProvider<EventAtom> provider) {
        super(recordedJob);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"Provider cannot be null!");
        this.provider = provider;
        this.commandRecorder = null;
    }

    public RecordingJob(Job<EventAtom> recordedJob, ICommandRecorder<EventAtom> commandRecorder) {
        super(recordedJob);
        this.provider = null;
        this.commandRecorder = commandRecorder;
    }

    public RecordingJob(Job<EventAtom> recordedJob, EventAtomEditingDomainProvider<EventAtom> provider, ICommandRecorder<EventAtom> commandRecorder) {
        super(recordedJob);
        Preconditions.checkArgument((provider != null ? 1 : 0) != 0, (String)"Provider cannot be null!");
        this.provider = provider;
        this.commandRecorder = commandRecorder;
    }

    protected void execute(final Activation<? extends EventAtom> activation, final Context context) {
        Object target = this.findDomainTarget(activation, context);
        TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)target);
        if (domain == null) {
            super.execute(activation, context);
        } else {
            RecordingCommand command = new RecordingCommand(domain){

                protected void doExecute() {
                    RecordingJob.super.execute(activation, context);
                }
            };
            command.setLabel(RECORDING_JOB);
            domain.getCommandStack().execute((Command)command);
            if (this.commandRecorder != null) {
                this.commandRecorder.recordCommandExecution(activation, context, (Command)command);
            }
        }
    }

    protected Object findDomainTarget(Activation<? extends EventAtom> activation, Context context) {
        Object domainTarget = context.get(TRANSACTIONAL_EDITING_DOMAIN);
        if (domainTarget == null && this.provider != null) {
            domainTarget = this.provider.findEditingDomain(activation, context);
        }
        return domainTarget;
    }

    public static interface ICommandRecorder<EventAtom> {
        public void recordCommandExecution(Activation<? extends EventAtom> var1, Context var2, Command var3);
    }
}

