/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations;

import java.util.Objects;
import org.eclipse.viatra.query.runtime.base.itc.alg.incscc.IncSCCAlg;
import org.eclipse.viatra.query.runtime.base.itc.graphimpl.Graph;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CallOperationHelper;
import org.eclipse.viatra.query.runtime.matchers.backend.IUpdateable;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.IProvider;

public class TransitiveClosureGraph
implements IUpdateable {
    private Graph<Object> graph = new Graph();
    private IncSCCAlg<Object> tcAlg = new IncSCCAlg(this.graph);
    private CallOperationHelper.PatternCall call;

    public static TransitiveClosureGraph accessClosureGraph(final ISearchContext context, final CallOperationHelper helper) {
        return context.accessBackendLevelCache(new TransitiveClosureGraphKey(helper.getCalledQuery()), TransitiveClosureGraph.class, new IProvider<TransitiveClosureGraph>(){

            public TransitiveClosureGraph get() {
                try {
                    return new TransitiveClosureGraph(helper, context, null);
                }
                catch (LocalSearchException e) {
                    throw new RuntimeException((Throwable)((Object)e));
                }
            }
        });
    }

    private TransitiveClosureGraph(CallOperationHelper helper, ISearchContext context) throws LocalSearchException {
        this.call = helper.createCall(context);
        this.call.registerChangeListener(this);
    }

    public void update(Tuple updateElement, boolean isInsertion) {
        Object sourceNode = updateElement.get(0);
        Object targetNode = updateElement.get(1);
        if (isInsertion) {
            this.graph.insertNode(sourceNode);
            this.graph.insertNode(targetNode);
            this.graph.insertEdge(sourceNode, targetNode);
        } else {
            this.graph.deleteEdge(sourceNode, targetNode);
            if (this.tcAlg.isIsolated(sourceNode)) {
                this.graph.deleteNode(sourceNode);
            }
            if (!Objects.equals(sourceNode, targetNode) && this.tcAlg.isIsolated(targetNode)) {
                this.graph.deleteNode(targetNode);
            }
        }
    }

    public Iterable<Object> getAllSources(Object target) {
        return this.tcAlg.getAllReachableSources(target);
    }

    public Iterable<Object> getAllTargets(Object source) {
        return this.tcAlg.getAllReachableTargets(source);
    }

    public void dispose() {
        this.call.removeChangeListener(this);
        this.tcAlg.dispose();
    }

    /* synthetic */ TransitiveClosureGraph(CallOperationHelper callOperationHelper, ISearchContext iSearchContext, TransitiveClosureGraph transitiveClosureGraph) throws LocalSearchException {
        this(callOperationHelper, iSearchContext);
    }

    private static final class TransitiveClosureGraphKey {
        private final PQuery query;

        private TransitiveClosureGraphKey(PQuery query) {
            this.query = query;
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TransitiveClosureGraphKey other = (TransitiveClosureGraphKey)obj;
            return Objects.equals(this.query, other.query);
        }
    }
}

