/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.planner;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintCategory;
import org.eclipse.viatra.query.runtime.localsearch.planner.PConstraintInfo;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.OperationCostComparator;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;

public class PlanState {
    private PBody pBody;
    private List<PConstraintInfo> operationsList;
    private Set<PVariable> boundVariables;
    private double cost;
    private List<PConstraintInfo> futureChecks;
    private List<PConstraintInfo> futureExtends;
    private List<PConstraintInfo> presentExtends;

    public PlanState(PBody pBody, List<PConstraintInfo> operationsList, Set<PVariable> boundVariables) {
        this.pBody = pBody;
        this.operationsList = operationsList;
        this.boundVariables = boundVariables;
        this.cost = 0.0;
        double cummulativeProduct = 1.0;
        for (PConstraintInfo constraintInfo : operationsList) {
            double constraintCost = constraintInfo.getCost();
            if (!(constraintCost > 0.0)) continue;
            this.cost += (cummulativeProduct *= constraintCost);
        }
    }

    public void updateOperations(List<PConstraintInfo> allPotentialExtendInfos, List<PConstraintInfo> allPotentialChecks) {
        this.futureChecks = Lists.newArrayList();
        this.futureExtends = Lists.newArrayList();
        this.presentExtends = Lists.newArrayList();
        HashSet allUsedAppliedConstraints = Sets.newHashSet();
        for (PConstraintInfo pConstraintPlanInfo : this.operationsList) {
            allUsedAppliedConstraints.addAll(pConstraintPlanInfo.getSameWithDifferentBindings());
        }
        final HashSet allUsedAppliedConstraintsArg = allUsedAppliedConstraints;
        Collection allRelevantExtendInfos = Collections2.filter(allPotentialExtendInfos, (Predicate)new Predicate<PConstraintInfo>(){

            public boolean apply(PConstraintInfo input) {
                return !allUsedAppliedConstraintsArg.contains(input) && PlanState.this.isPossibleExtend(input);
            }
        });
        this.categorizeExtends(allRelevantExtendInfos);
        Collection allRelevantCheckInfos = Collections2.filter(allPotentialChecks, (Predicate)new Predicate<PConstraintInfo>(){

            public boolean apply(PConstraintInfo input) {
                return !allUsedAppliedConstraintsArg.contains(input) && PlanState.this.isPossibleCheck(input);
            }
        });
        this.categorizeChecks(allRelevantCheckInfos);
        OperationCostComparator infoComparator = new OperationCostComparator();
        Collections.sort(this.futureChecks, infoComparator);
        Collections.sort(this.futureExtends, infoComparator);
        Collections.sort(this.presentExtends, infoComparator);
    }

    private void categorizeChecks(Collection<PConstraintInfo> allRelevantCheckInfos) {
        for (PConstraintInfo checkInfo : allRelevantCheckInfos) {
            PConstraintCategory category = checkInfo.getCategory(this.pBody, this.boundVariables);
            if (category == PConstraintCategory.PRESENT) {
                this.operationsList.add(checkInfo);
                continue;
            }
            if (category != PConstraintCategory.FUTURE) continue;
            this.futureChecks.add(checkInfo);
        }
    }

    private void categorizeExtends(Collection<PConstraintInfo> allRelevantExtendInfos) {
        for (PConstraintInfo constraintInfo : allRelevantExtendInfos) {
            PConstraintCategory category = constraintInfo.getCategory(this.pBody, this.boundVariables);
            if (category == PConstraintCategory.FUTURE) {
                this.futureExtends.add(constraintInfo);
                continue;
            }
            if (category != PConstraintCategory.PRESENT) continue;
            this.presentExtends.add(constraintInfo);
        }
    }

    private boolean isPossibleExtend(PConstraintInfo constraintInfo) {
        PConstraintCategory category = constraintInfo.getCategory(this.getAssociatedPBody(), this.boundVariables);
        if (category == PConstraintCategory.PAST) {
            return false;
        }
        return !constraintInfo.getFreeVariables().isEmpty();
    }

    private boolean isPossibleCheck(PConstraintInfo constraintInfo) {
        PConstraintCategory category = constraintInfo.getCategory(this.getAssociatedPBody(), this.boundVariables);
        if (category == PConstraintCategory.PAST) {
            return false;
        }
        return constraintInfo.getFreeVariables().isEmpty();
    }

    public PBody getAssociatedPBody() {
        return this.pBody;
    }

    public List<PConstraintInfo> getOperations() {
        return this.operationsList;
    }

    public Set<PVariable> getBoundVariables() {
        return this.boundVariables;
    }

    public double getCost() {
        return this.cost;
    }

    public List<PConstraintInfo> getFutureChecks() {
        return this.futureChecks;
    }

    public List<PConstraintInfo> getFutureExtends() {
        return this.futureExtends;
    }

    public List<PConstraintInfo> getPresentExtends() {
        return this.presentExtends;
    }
}

