/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.build.BinSection;
import org.eclipse.pde.internal.ui.editor.build.BuildClasspathSection;
import org.eclipse.pde.internal.ui.editor.build.BuildContentsSection;
import org.eclipse.pde.internal.ui.editor.build.RuntimeInfoSection;
import org.eclipse.pde.internal.ui.editor.build.SrcSection;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class BuildPage
extends PDEFormPage {
    public static final String PAGE_ID = "build";
    private BuildClasspathSection fClasspathSection;
    private BuildContentsSection fSrcSection;
    private BuildContentsSection fBinSection;
    private RuntimeInfoSection fRuntimeSection;
    private Button fCustomButton;

    public BuildPage(FormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.BuildPage_name);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.build_page";
    }

    @Override
    protected void createFormContent(IManagedForm mform) {
        super.createFormContent(mform);
        FormToolkit toolkit = mform.getToolkit();
        ScrolledForm form = mform.getForm();
        form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUILD_EXEC));
        form.setText(PDEUIMessages.BuildEditor_BuildPage_title);
        form.getBody().setLayout((Layout)FormLayoutFactory.createFormGridLayout(true, 2));
        this.fCustomButton = toolkit.createButton(form.getBody(), this.getCustomText(), 32);
        this.fCustomButton.setAlignment(16384);
        Label label = toolkit.createLabel(form.getBody(), null);
        label.setLayoutData((Object)new GridData(768));
        this.fCustomButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            boolean isCustom = this.fCustomButton.getSelection();
            IBuildEntry customEntry = this.getCustomBuildEntry();
            this.setCustomEntryValue(customEntry, isCustom);
            this.handleCustomCheckState(isCustom);
        }));
        this.fRuntimeSection = new RuntimeInfoSection(this, form.getBody());
        this.fBinSection = new BinSection(this, form.getBody());
        this.fBinSection.getSection().setLayoutData((Object)new GridData(1808));
        this.fSrcSection = new SrcSection(this, form.getBody());
        this.fSrcSection.getSection().setLayoutData((Object)new GridData(1808));
        this.fClasspathSection = new BuildClasspathSection(this, form.getBody());
        mform.addPart((IFormPart)this.fRuntimeSection);
        mform.addPart((IFormPart)this.fSrcSection);
        mform.addPart((IFormPart)this.fBinSection);
        mform.addPart((IFormPart)this.fClasspathSection);
        this.handleCustomCheckState(this.getCustomSelection());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.build_page");
    }

    private IBuildModel getBuildModel() {
        InputContext context = this.getPDEEditor().getContextManager().findContext("build-context");
        return (IBuildModel)context.getModel();
    }

    private IBuildEntry getCustomBuildEntry() {
        IBuildModel buildModel = this.getBuildModel();
        IBuildEntry customEntry = buildModel.getBuild().getEntry("custom");
        if (customEntry != null) {
            return customEntry;
        }
        try {
            customEntry = buildModel.getFactory().createEntry("custom");
            buildModel.getBuild().add(customEntry);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return customEntry;
    }

    private boolean getCustomSelection() {
        IBuildModel model = this.getBuildModel();
        IBuild build = model.getBuild();
        IBuildEntry customEntry = build.getEntry("custom");
        if (customEntry == null || customEntry.getTokens().length == 0) {
            return false;
        }
        return customEntry.getTokens()[0].equals("true");
    }

    private void handleCustomCheckState(boolean isCustom) {
        this.fCustomButton.setSelection(isCustom);
        this.enableAllSections(!isCustom);
    }

    public void enableAllSections(boolean enable) {
        this.fRuntimeSection.enableSection(enable);
        this.fBinSection.enableSection(enable);
        this.fSrcSection.enableSection(enable);
        this.fClasspathSection.enableSection(enable);
    }

    private void setCustomEntryValue(IBuildEntry customEntry, boolean isCustom) {
        String[] tokens = customEntry.getTokens();
        try {
            if (tokens.length != 0) {
                String[] stringArray = tokens;
                int n = tokens.length;
                int n2 = 0;
                while (n2 < n) {
                    String token = stringArray[n2];
                    customEntry.removeToken(token);
                    ++n2;
                }
            }
            if (isCustom) {
                customEntry.addToken("true");
            } else {
                this.getBuildModel().getBuild().remove(customEntry);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private String getCustomText() {
        return PDEUIMessages.BuildPage_custom;
    }
}

