/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.outline;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.outline.IOutlineContentCreator;
import org.eclipse.pde.internal.ui.editor.outline.IOutlineSelectionHandler;
import org.eclipse.pde.internal.ui.editor.outline.QuickOutlineMouseMoveListener;
import org.eclipse.pde.internal.ui.editor.outline.QuickOutlineNamePatternFilter;
import org.eclipse.pde.internal.ui.util.StringMatcher;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QuickOutlinePopupDialog
extends PopupDialog
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension2,
DisposeListener {
    private TreeViewer fTreeViewer;
    private IOutlineContentCreator fOutlineContentCreator;
    private IOutlineSelectionHandler fOutlineSelectionHandler;
    private Text fFilterText;
    private StringMatcher fStringMatcher;
    private QuickOutlineNamePatternFilter fNamePatternFilter;
    private SortAction fSortAction;
    private ITreeContentProvider fTreeContentProvider;
    private ILabelProvider fTreeLabelProvider;
    private ViewerComparator fTreeViewerComparator;
    private ViewerComparator fTreeViewerDefaultComparator;

    public QuickOutlinePopupDialog(Shell parent, int shellStyle, IOutlineContentCreator creator, IOutlineSelectionHandler handler) {
        super(parent, shellStyle, true, true, true, true, null, null);
        this.fOutlineContentCreator = creator;
        this.fOutlineSelectionHandler = handler;
        this.initialize();
        this.create();
    }

    private void initialize() {
        this.setInfoText(PDEUIMessages.QuickOutlinePopupDialog_infoTextPressEscToExit);
        this.fFilterText = null;
        this.fTreeViewer = null;
        this.fStringMatcher = null;
        this.fNamePatternFilter = null;
        this.fSortAction = null;
        this.fTreeContentProvider = null;
        this.fTreeLabelProvider = null;
        this.fTreeViewerComparator = null;
        this.fTreeViewerDefaultComparator = null;
    }

    protected Control createDialogArea(Composite parent) {
        if (this.fOutlineContentCreator == null || this.fOutlineSelectionHandler == null) {
            return super.createDialogArea(parent);
        }
        this.createUIWidgetTreeViewer(parent);
        this.createUIListenersTreeViewer();
        this.createUIActions();
        this.addDisposeListener(this);
        return this.fTreeViewer.getControl();
    }

    private void createUIActions() {
        this.fSortAction = new SortAction((StructuredViewer)this.fTreeViewer, PDEUIMessages.PDEMultiPageContentOutline_SortingAction_tooltip, this.fTreeViewerComparator, this.fTreeViewerDefaultComparator, null);
    }

    protected void fillDialogMenu(IMenuManager dialogMenu) {
        dialogMenu.add((IAction)this.fSortAction);
        dialogMenu.add((IContributionItem)new Separator());
        super.fillDialogMenu(dialogMenu);
    }

    private void createUIWidgetTreeViewer(Composite parent) {
        int style = 768;
        Tree widget = new Tree(parent, style);
        GridData data = new GridData(1808);
        data.heightHint = widget.getItemHeight() * 12;
        widget.setLayoutData((Object)data);
        this.fTreeViewer = new TreeViewer(widget);
        this.fNamePatternFilter = new QuickOutlineNamePatternFilter();
        this.fTreeViewer.addFilter((ViewerFilter)this.fNamePatternFilter);
        this.fTreeContentProvider = this.fOutlineContentCreator.createOutlineContentProvider();
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeLabelProvider = this.fOutlineContentCreator.createOutlineLabelProvider();
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewerComparator = this.fOutlineContentCreator.createOutlineComparator();
        this.fTreeViewerDefaultComparator = this.fOutlineContentCreator.createDefaultOutlineComparator();
        this.fTreeViewer.setComparator(this.fTreeViewerDefaultComparator);
        this.fTreeViewer.setAutoExpandLevel(-1);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setInput(this.fOutlineContentCreator.getOutlineInput());
    }

    private void createUIListenersTreeViewer() {
        final Tree tree = this.fTreeViewer.getTree();
        tree.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent e) {
                QuickOutlinePopupDialog.this.handleTreeViewerMouseUp(tree, e);
            }
        });
        tree.addMouseMoveListener((MouseMoveListener)new QuickOutlineMouseMoveListener(this.fTreeViewer));
        tree.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                QuickOutlinePopupDialog.this.gotoSelectedElement();
            }
        });
    }

    private void handleTreeViewerMouseUp(Tree tree, MouseEvent e) {
        if (tree.getSelectionCount() < 1 || e.button != 1 || !tree.equals(e.getSource())) {
            return;
        }
        TreeItem object = tree.getItem(new Point(e.x, e.y));
        TreeItem selection = tree.getSelection()[0];
        if (selection.equals(object)) {
            this.gotoSelectedElement();
        }
    }

    private Object getSelectedElement() {
        if (this.fTreeViewer == null) {
            return null;
        }
        return ((IStructuredSelection)this.fTreeViewer.getSelection()).getFirstElement();
    }

    public void addDisposeListener(DisposeListener listener) {
        this.getShell().addDisposeListener(listener);
    }

    public void addFocusListener(FocusListener listener) {
        this.getShell().addFocusListener(listener);
    }

    public Point computeSizeHint() {
        return this.getShell().getSize();
    }

    public void dispose() {
        this.close();
    }

    public boolean isFocusControl() {
        return this.fTreeViewer.getControl().isFocusControl() || this.fFilterText.isFocusControl();
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.getShell().removeDisposeListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.getShell().removeFocusListener(listener);
    }

    public void setBackgroundColor(Color background) {
        this.applyBackgroundColor(background, this.getContents());
    }

    public void setFocus() {
        this.getShell().forceFocus();
        this.fFilterText.setFocus();
    }

    public void setForegroundColor(Color foreground) {
        this.applyForegroundColor(foreground, this.getContents());
    }

    public void setInformation(String information) {
    }

    public void setLocation(Point location) {
        if (!this.getPersistBounds() || this.getDialogSettings() == null) {
            this.getShell().setLocation(location);
        }
    }

    public void setSize(int width, int height) {
        this.getShell().setSize(width, height);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.open();
        } else {
            this.saveDialogBounds(this.getShell());
            this.getShell().setVisible(false);
        }
    }

    public boolean hasContents() {
        return this.fTreeViewer != null && this.fTreeViewer.getInput() != null;
    }

    public void setInput(Object input) {
        if (input != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(input));
        }
    }

    public void widgetDisposed(DisposeEvent e) {
        this.fTreeViewer = null;
        this.fFilterText = null;
    }

    protected Control createTitleControl(Composite parent) {
        this.createUIWidgetFilterText(parent);
        this.createUIListenersFilterText();
        return this.fFilterText;
    }

    private void createUIWidgetFilterText(Composite parent) {
        this.fFilterText = new Text(parent, 0);
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        GridData data = new GridData(768);
        data.heightHint = Dialog.convertHeightInCharsToPixels((FontMetrics)fontMetrics, (int)1);
        data.horizontalAlignment = 4;
        data.verticalAlignment = 2;
        this.fFilterText.setLayoutData((Object)data);
    }

    private void gotoSelectedElement() {
        Object selectedElement = this.getSelectedElement();
        if (selectedElement == null) {
            return;
        }
        this.dispose();
        if (this.fOutlineSelectionHandler.getContentOutline().getControl() == null || this.fOutlineSelectionHandler.getContentOutline().getControl().isDisposed()) {
            this.fOutlineSelectionHandler.updateSelection(selectedElement);
        } else {
            this.fOutlineSelectionHandler.getContentOutline().setSelection((ISelection)new StructuredSelection(selectedElement));
        }
    }

    private void createUIListenersFilterText() {
        this.fFilterText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    QuickOutlinePopupDialog.this.gotoSelectedElement();
                } else if (e.keyCode == 0x1000002) {
                    QuickOutlinePopupDialog.this.fTreeViewer.getTree().setFocus();
                } else if (e.keyCode == 0x1000001) {
                    QuickOutlinePopupDialog.this.fTreeViewer.getTree().setFocus();
                } else if (e.character == '\u001b') {
                    QuickOutlinePopupDialog.this.dispose();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.fFilterText.addModifyListener(e -> {
            String text = ((Text)e.widget).getText();
            int length = text.length();
            if (length > 0) {
                if (text.charAt(length - 1) != '*') {
                    text = String.valueOf(text) + '*';
                }
                if (text.charAt(0) != '*') {
                    text = String.valueOf('*') + text;
                }
            }
            this.setMatcherString(text, true);
        });
    }

    private void setMatcherString(String pattern, boolean update) {
        this.fStringMatcher = pattern.length() == 0 ? null : new StringMatcher(pattern, true, false);
        this.fNamePatternFilter.setStringMatcher(this.fStringMatcher);
        if (update) {
            this.stringMatcherUpdated();
        }
    }

    private void stringMatcherUpdated() {
        this.fTreeViewer.getControl().setRedraw(false);
        this.fTreeViewer.refresh();
        this.fTreeViewer.expandAll();
        this.selectFirstMatch();
        this.fTreeViewer.getControl().setRedraw(true);
    }

    private void selectFirstMatch() {
        Tree tree = this.fTreeViewer.getTree();
        Object element = this.findFirstMatchToPattern(tree.getItems());
        if (element != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(element), true);
        } else {
            this.fTreeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    private Object findFirstMatchToPattern(TreeItem[] items) {
        ILabelProvider labelProvider = (ILabelProvider)this.fTreeViewer.getLabelProvider();
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            String label;
            TreeItem item = treeItemArray[n2];
            Object element = item.getData();
            if (this.fStringMatcher == null) {
                return element;
            }
            if (element != null && this.fStringMatcher.match(label = labelProvider.getText(element))) {
                return element;
            }
            element = this.findFirstMatchToPattern(item.getItems());
            if (element != null) {
                return element;
            }
            ++n2;
        }
        return null;
    }
}

