/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.validation.runtime;

import org.apache.log4j.Logger;
import org.eclipse.viatra.addon.validation.core.ValidationEngine;
import org.eclipse.viatra.addon.validation.core.api.IConstraintSpecification;
import org.eclipse.viatra.addon.validation.core.api.IValidationEngine;
import org.eclipse.viatra.addon.validation.runtime.ConstraintExtensionRegistry;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public final class ValidationInitializerUtil {
    private ValidationInitializerUtil() {
    }

    public static IValidationEngine initializeValidationWithRegisteredConstraintsOnScope(QueryScope scope, String editorId) throws ViatraQueryException {
        ViatraQueryEngine engine = ViatraQueryEngine.on((QueryScope)scope);
        Logger logger = ViatraQueryLoggingUtil.getLogger(ValidationEngine.class);
        IValidationEngine validationEngine = ValidationEngine.builder().setEngine(engine).setLogger(logger).build();
        for (IConstraintSpecification constraintSpecification : ConstraintExtensionRegistry.getConstraintSpecificationsForEditorId(editorId)) {
            validationEngine.addConstraintSpecification(constraintSpecification);
        }
        validationEngine.initialize();
        return validationEngine;
    }
}

