/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.notification;

import com.google.common.base.Objects;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.compiler.util.SimpleLookupTable;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.builder.State;
import org.eclipse.jdt.internal.core.builder.StringSet;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.ui.notification.TypeNames;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class JavaBuilderState {
    private static final Logger LOG = Logger.getLogger(JavaBuilderState.class);
    private final State state;
    private final IProject project;
    private Integer buildNumber;
    private SimpleLookupTable references;
    private Long lastStructuralBuildTime;
    private Set<QualifiedName> structurallyChangedTypes;

    private JavaBuilderState(IProject project, State state) {
        this.project = project;
        this.state = state;
    }

    public IProject getProject() {
        return this.project;
    }

    public static JavaBuilderState getLastBuiltState(IJavaElement it) {
        JavaBuilderState _xblockexpression = null;
        IJavaProject javaProject = it.getJavaProject();
        boolean _equals = Objects.equal((Object)javaProject, null);
        if (_equals) {
            return null;
        }
        IProject _project = javaProject.getProject();
        _xblockexpression = JavaBuilderState.getLastBuiltState(_project);
        return _xblockexpression;
    }

    public static JavaBuilderState getLastBuiltState(IProject it) {
        Object _lastBuiltState;
        State _switchResult = null;
        JavaModelManager _javaModelManager = JavaModelManager.getJavaModelManager();
        Object state = _lastBuiltState = _javaModelManager.getLastBuiltState(it, null);
        boolean _matched = false;
        if (state instanceof State) {
            _matched = true;
            _switchResult = (State)state;
        }
        if (!_matched) {
            _switchResult = null;
        }
        return new JavaBuilderState(it, _switchResult);
    }

    public Long getLastStructuralBuildTime() {
        boolean _notEquals;
        Long _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)this.lastStructuralBuildTime, null);
        if (_notEquals) {
            return this.lastStructuralBuildTime;
        }
        boolean _equals = Objects.equal((Object)this.state, null);
        if (_equals) {
            this.lastStructuralBuildTime = -1L;
            return this.lastStructuralBuildTime;
        }
        Object _readField = this.readField(this.state, "lastStructuralBuildTime", -1L);
        _xblockexpression = this.lastStructuralBuildTime = (Long)_readField;
        return _xblockexpression;
    }

    public Integer getBuildNumber() {
        boolean _notEquals;
        Integer _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)this.buildNumber, null);
        if (_notEquals) {
            return this.buildNumber;
        }
        boolean _equals = Objects.equal((Object)this.state, null);
        if (_equals) {
            this.buildNumber = -1;
            return this.buildNumber;
        }
        Object _readField = this.readField(this.state, "buildNumber", -1);
        _xblockexpression = this.buildNumber = (Integer)_readField;
        return _xblockexpression;
    }

    public Set<QualifiedName> getStructurallyChangedTypes() {
        HashSet _newHashSet;
        boolean _notEquals;
        Set<QualifiedName> _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal(this.structurallyChangedTypes, null);
        if (_notEquals) {
            return this.structurallyChangedTypes;
        }
        this.structurallyChangedTypes = _newHashSet = CollectionLiterals.newHashSet((Object[])new QualifiedName[0]);
        Object _readField = null;
        if (this.state != null) {
            _readField = this.readField(this.state, "structurallyChangedTypes", null);
        }
        Object types = _readField;
        boolean _matched = false;
        if (types instanceof StringSet) {
            _matched = true;
            String[] stringArray = ((StringSet)types).values;
            int n = ((StringSet)types).values.length;
            int n2 = 0;
            while (n2 < n) {
                boolean _notEquals_1;
                String name = stringArray[n2];
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)name, null);
                if (_notEquals_1) {
                    String[] _split = name.split("/");
                    QualifiedName _create = QualifiedName.create((String[])_split);
                    this.structurallyChangedTypes.add(_create);
                }
                ++n2;
            }
        }
        _xblockexpression = this.structurallyChangedTypes;
        return _xblockexpression;
    }

    protected TypeNames _getQualifiedTypeNames(IPackageFragment it) {
        TypeNames _xblockexpression = null;
        IJavaProject _javaProject = it.getJavaProject();
        TypeNames qualifiedTypeNames = new TypeNames(_javaProject);
        SimpleLookupTable references = this.getReferences();
        boolean _equals = Objects.equal((Object)references, null);
        if (_equals) {
            return qualifiedTypeNames;
        }
        String packageName = it.getElementName();
        IResource resource = it.getResource();
        boolean _equals_1 = Objects.equal((Object)resource, null);
        if (_equals_1) {
            return qualifiedTypeNames;
        }
        IPath packagePath = resource.getProjectRelativePath();
        IPackageFragmentRoot _packageFragmentRoot = this.getPackageFragmentRoot((IJavaElement)it);
        IResource _resource = _packageFragmentRoot.getResource();
        IPath _projectRelativePath = _resource.getProjectRelativePath();
        int srcPathSegmentCount = _projectRelativePath.segmentCount();
        Object[] objectArray = references.keyTable;
        int n = references.keyTable.length;
        int n2 = 0;
        while (n2 < n) {
            Object key;
            Object typeLocator = key = objectArray[n2];
            boolean _matched = false;
            if (typeLocator instanceof String) {
                IPath _removeFirstSegments;
                IPath qualifiedPath;
                IPath _removeLastSegments;
                String _string;
                String typePackageName;
                boolean _equals_2;
                _matched = true;
                IJavaProject _javaProject_1 = it.getJavaProject();
                IProject _project = _javaProject_1.getProject();
                IFile _file = _project.getFile((String)typeLocator);
                IPath typeLocatorPath = _file.getProjectRelativePath();
                boolean _isPrefixOf = packagePath.isPrefixOf(typeLocatorPath);
                if (_isPrefixOf && (_equals_2 = packageName.equals(typePackageName = (_string = (_removeLastSegments = (qualifiedPath = (_removeFirstSegments = typeLocatorPath.removeFirstSegments(srcPathSegmentCount)).removeFileExtension()).removeLastSegments(1)).toString()).replace("/", ".")))) {
                    String _lastSegment = qualifiedPath.lastSegment();
                    String simpleTypeName = _lastSegment.toString();
                    IJavaProject _javaProject_2 = it.getJavaProject();
                    TypeNames _qualifiedTypeNames = this.getQualifiedTypeNames((String)typeLocator, packageName, simpleTypeName, _javaProject_2);
                    qualifiedTypeNames.addAll(_qualifiedTypeNames);
                }
            }
            ++n2;
        }
        _xblockexpression = qualifiedTypeNames;
        return _xblockexpression;
    }

    protected TypeNames _getQualifiedTypeNames(ICompilationUnit it) {
        String _typeLocator = this.getTypeLocator(it);
        String _packageName = this.getPackageName(it);
        String _simplePrimaryTypeName = this.getSimplePrimaryTypeName(it);
        IJavaProject _javaProject = it.getJavaProject();
        return this.getQualifiedTypeNames(_typeLocator, _packageName, _simplePrimaryTypeName, _javaProject);
    }

    private IPackageFragmentRoot getPackageFragmentRoot(IJavaElement it) {
        IJavaElement _parent;
        IPackageFragmentRoot _switchResult = null;
        IJavaElement parent = _parent = it.getParent();
        boolean _matched = false;
        if (parent instanceof IPackageFragmentRoot) {
            _matched = true;
            _switchResult = (IPackageFragmentRoot)parent;
        }
        if (!_matched) {
            _switchResult = this.getPackageFragmentRoot(parent);
        }
        return _switchResult;
    }

    private TypeNames getQualifiedTypeNames(String typeLocator, final String packageName, String simpleName, IJavaProject project) {
        char[][] typeNames;
        boolean _equals;
        TypeNames _xblockexpression = null;
        final TypeNames qualifiedTypeNames = new TypeNames(project);
        final String primaryTypeFqn = this.getQualifedTypeName(packageName, simpleName);
        char[][] _definedTypeNamesFor = null;
        if (this.state != null) {
            _definedTypeNamesFor = this.state.getDefinedTypeNamesFor(typeLocator);
        }
        if (_equals = Objects.equal((Object)(typeNames = _definedTypeNamesFor), null)) {
            TypeNames _typeNames = new TypeNames(project);
            Procedures.Procedure1<TypeNames> _function = new Procedures.Procedure1<TypeNames>(){

                public void apply(TypeNames it) {
                    it.addTypeName(primaryTypeFqn, primaryTypeFqn);
                }
            };
            return (TypeNames)ObjectExtensions.operator_doubleArrow((Object)_typeNames, (Procedures.Procedure1)_function);
        }
        Procedures.Procedure1<char[]> _function_1 = new Procedures.Procedure1<char[]>(){

            public void apply(char[] it) {
                String _string = new String(it);
                String typeName = JavaBuilderState.this.getQualifedTypeName(packageName, _string);
                qualifiedTypeNames.addTypeName(typeName, primaryTypeFqn);
            }
        };
        IterableExtensions.forEach((Iterable)((Iterable)Conversions.doWrapArray((Object)typeNames)), (Procedures.Procedure1)_function_1);
        _xblockexpression = qualifiedTypeNames;
        return _xblockexpression;
    }

    private String getQualifedTypeName(String packageName, String simpleTypeName) {
        String _xblockexpression = null;
        boolean _equals = Objects.equal((Object)packageName, null);
        if (_equals) {
            return simpleTypeName;
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)packageName, "");
        _builder.append((Object)".");
        _builder.append((Object)simpleTypeName, "");
        _xblockexpression = _builder.toString();
        return _xblockexpression;
    }

    private String getTypeLocator(ICompilationUnit it) {
        IResource _resource = it.getResource();
        IPath _projectRelativePath = null;
        if (_resource != null) {
            _projectRelativePath = _resource.getProjectRelativePath();
        }
        String _string = null;
        if (_projectRelativePath != null) {
            _string = _projectRelativePath.toString();
        }
        return _string;
    }

    private String getPackageName(ICompilationUnit it) {
        IJavaElement _parent;
        String _switchResult = null;
        IJavaElement parent = _parent = it.getParent();
        boolean _matched = false;
        if (parent instanceof IPackageFragment) {
            boolean _not;
            boolean _isDefaultPackage = ((IPackageFragment)parent).isDefaultPackage();
            boolean bl = _not = !_isDefaultPackage;
            if (_not) {
                _matched = true;
                _switchResult = ((IPackageFragment)parent).getElementName();
            }
        }
        if (!_matched) {
            _switchResult = null;
        }
        return _switchResult;
    }

    private String getSimplePrimaryTypeName(ICompilationUnit it) {
        String _xblockexpression = null;
        String elementName = it.getElementName();
        int _lastIndexOf = elementName.lastIndexOf(".");
        _xblockexpression = elementName.substring(0, _lastIndexOf);
        return _xblockexpression;
    }

    private SimpleLookupTable getReferences() {
        Object _readField;
        boolean _notEquals;
        SimpleLookupTable _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)this.references, null);
        if (_notEquals) {
            return this.references;
        }
        boolean _equals = Objects.equal((Object)this.state, null);
        if (_equals) {
            return null;
        }
        SimpleLookupTable _switchResult = null;
        Object references = _readField = this.readField(this.state, "references", null);
        boolean _matched = false;
        if (references instanceof SimpleLookupTable) {
            _matched = true;
            _switchResult = (SimpleLookupTable)references;
        }
        if (!_matched) {
            _switchResult = null;
        }
        _xblockexpression = this.references = _switchResult;
        return _xblockexpression;
    }

    private Object readField(Object instance, String fieldName, Object defaultValue) {
        try {
            boolean _notEquals;
            Class<?> _class = instance.getClass();
            Field field = _class.getDeclaredField(fieldName);
            field.setAccessible(true);
            Object value = field.get(instance);
            boolean bl = _notEquals = !Objects.equal((Object)value, null);
            if (_notEquals) {
                return value;
            }
            return defaultValue;
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                boolean _isEnabledFor = LOG.isEnabledFor((Priority)Level.ERROR);
                if (_isEnabledFor) {
                    String _message = e.getMessage();
                    LOG.error((Object)_message, (Throwable)e);
                }
                return defaultValue;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public TypeNames getQualifiedTypeNames(Object it) {
        if (it instanceof ICompilationUnit) {
            return this._getQualifiedTypeNames((ICompilationUnit)it);
        }
        if (it instanceof IPackageFragment) {
            return this._getQualifiedTypeNames((IPackageFragment)it);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(it).toString());
    }
}

