/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.quickfix;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.List;
import org.eclipse.swt.graphics.Image;
import org.eclipse.xtext.ui.IImageHelper;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolution;
import org.eclipse.xtext.ui.editor.quickfix.IssueResolutionProvider;
import org.eclipse.xtext.ui.internal.XtextPluginImages;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Issue;

public abstract class AbstractIssueResolutionProviderAdapter {
    public static final String DEFAULT_IMAGE = "org.eclipse.xtext.ui.editor.quickfix.AbstractIssueResolutionProviderAdapter.DEFAULT_IMAGE";
    @Named(value="org.eclipse.xtext.ui.editor.quickfix.AbstractIssueResolutionProviderAdapter.DEFAULT_IMAGE")
    @Inject(optional=true)
    private String defaultImage = "org.eclipse.xtext.ui.CORRECTION_CHANGE";
    @Inject
    private IssueResolutionProvider resolutionProvider;
    @Inject
    private IImageHelper imageHelper;

    protected IssueResolutionProvider getResolutionProvider() {
        return this.resolutionProvider;
    }

    public Iterable<IssueResolution> getResolutions(Issue issue, IXtextDocument document) {
        List<IssueResolution> result = this.resolutionProvider.getResolutions(issue);
        return result;
    }

    public Image getImage(IssueResolution resolution) {
        if (Strings.isEmpty((String)resolution.getImage())) {
            return XtextPluginImages.get(this.defaultImage);
        }
        return this.imageHelper.getImage(resolution.getImage());
    }
}

