/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.databinding.observable.value.ValueChangeEvent;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.notification.AttributeMonitor;

public class DefaultAttributeMonitor<MatchType extends IPatternMatch>
extends AttributeMonitor<MatchType> {
    private ChangeListener changeListener = new ChangeListener();
    private Map<IObservableValue, MatchType> observableMap = new HashMap<IObservableValue, MatchType>();
    private Map<MatchType, List<IObservableValue>> observableMapReversed = new HashMap<MatchType, List<IObservableValue>>();

    public void registerFor(MatchType atom) {
        ArrayList<IObservableValue> values = new ArrayList<IObservableValue>();
        for (String param : atom.parameterNames()) {
            Object location = atom.get(param);
            List<IObservableValue> observableValues = this.observeAllAttributes(this.changeListener, location);
            values.addAll(observableValues);
        }
        for (IObservableValue val : values) {
            this.observableMap.put(val, atom);
        }
        this.observableMapReversed.put(atom, values);
    }

    private List<IObservableValue> observeAllAttributes(IValueChangeListener changeListener, Object object) {
        ArrayList<IObservableValue> affectedValues = new ArrayList<IObservableValue>();
        if (object instanceof EObject) {
            for (EStructuralFeature feature : ((EObject)object).eClass().getEAllStructuralFeatures()) {
                IObservableValue val = EMFProperties.value((EStructuralFeature)feature).observe(object);
                affectedValues.add(val);
                val.addValueChangeListener(changeListener);
            }
        }
        return affectedValues;
    }

    public void unregisterForAll() {
        for (IPatternMatch atom : this.observableMapReversed.keySet()) {
            this.unregisterFor((MatchType)atom);
        }
    }

    public void unregisterFor(MatchType atom) {
        List<IObservableValue> observables = this.observableMapReversed.get(atom);
        if (observables != null) {
            for (IObservableValue val : observables) {
                val.removeValueChangeListener((IValueChangeListener)this.changeListener);
            }
        }
    }

    private class ChangeListener
    implements IValueChangeListener {
        private ChangeListener() {
        }

        public void handleValueChange(ValueChangeEvent event) {
            IObservableValue val = event.getObservableValue();
            if (val != null) {
                DefaultAttributeMonitor.this.notifyListeners((IPatternMatch)DefaultAttributeMonitor.this.observableMap.get(val));
            }
        }
    }
}

