/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.integration.zest.viewer;

import com.google.inject.Module;
import java.util.Map;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.graph.Node;
import org.eclipse.gef.zest.fx.jface.ZestFxJFaceModule;
import org.eclipse.viatra.integration.zest.viewer.IGraphEdgeContentProvider;
import org.eclipse.viatra.integration.zest.viewer.ViatraZestModule;
import org.eclipse.viatra.integration.zest.viewer.ZestContentViewer;

public class ModifiableZestContentViewer
extends ZestContentViewer {
    public ModifiableZestContentViewer() {
        this(new ViatraZestModule());
    }

    public ModifiableZestContentViewer(Module module) {
        super(module);
    }

    public ModifiableZestContentViewer(ZestFxJFaceModule module) {
        super((Module)module);
    }

    public void addNode(Object contentNode) {
        Node node = this.createNode(contentNode, (IGraphEdgeContentProvider)this.getContentProvider(), this.getLabelProvider());
        Graph rootGraph = this.getRootGraph();
        rootGraph.getNodes().add((Object)node);
    }

    public void removeNode(Object contentNode) {
        Map nodeMap = this.contentNodeMap;
        if (nodeMap.containsKey(contentNode)) {
            Node node = (Node)nodeMap.get(contentNode);
            node.getGraph().getNodes().remove((Object)node);
        }
    }

    public void addEdge(Object contentEdge) {
        Map edgeMap = this.contentEdgeMap;
        IGraphEdgeContentProvider contentProvider = (IGraphEdgeContentProvider)this.getContentProvider();
        Object contentSourceNode = contentProvider.getSource(contentEdge);
        Object contentTargetNode = contentProvider.getTarget(contentEdge);
        Map<Object, Node> nodeMap = this.getContentNodeMap();
        Node sourceNode = nodeMap.get(contentSourceNode);
        Node targetNode = nodeMap.get(contentTargetNode);
        Edge edge = this.createEdge(this.getLabelProvider(), contentSourceNode, sourceNode, contentTargetNode, targetNode);
        edgeMap.put(contentEdge, edge);
        Graph graph = sourceNode.getGraph();
        graph.getEdges().add((Object)edge);
    }

    public void removeEdge(Object contentEdge) {
        Map edgeMap = this.contentEdgeMap;
        if (edgeMap.containsKey(contentEdge)) {
            Edge edge = (Edge)edgeMap.get(contentEdge);
            edgeMap.remove(contentEdge, edge);
            Graph graph = edge.getGraph();
            graph.getEdges().remove((Object)edge);
        }
    }
}

