/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.xtext.builder.nature.NatureAddingEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class EMFPatternLanguageEditorCallback
extends NatureAddingEditorCallback {
    @Inject
    Logger logger;

    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        try {
            IResource resource = editor.getResource();
            if (resource != null && resource.getProject().isAccessible() && !resource.getProject().isHidden() && !resource.getProject().hasNature("org.eclipse.viatra.query.projectnature")) {
                String title = "Invalid VIATRA Query Project";
                String message = "The project " + resource.getProject().getName() + " is not a valid VIATRA Query project.";
                MessageDialog.openError((Shell)editor.getShell(), (String)title, (String)message);
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error checking project nature", (Throwable)e);
        }
    }
}

