/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.base.itc.graphimpl;

import com.google.common.base.Function;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCC;
import org.eclipse.viatra.query.runtime.base.itc.alg.misc.scc.SCCResult;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IBiDirectionalGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphDataSource;
import org.eclipse.viatra.query.runtime.base.itc.igraph.IGraphObserver;

public class Graph<V>
implements IGraphDataSource<V>,
IBiDirectionalGraphDataSource<V> {
    private static final long serialVersionUID = 1L;
    private Map<V, Map<V, Integer>> outgoingEdges = new HashMap<V, Map<V, Integer>>();
    private Map<V, Map<V, Integer>> incomingEdges = new HashMap<V, Map<V, Integer>>();
    private List<IGraphObserver<V>> observers = new LinkedList<IGraphObserver<V>>();
    private static final String[] colors = new String[]{"yellow", "blue", "red", "green", "gray", "cyan"};

    public void insertEdge(V source, V target) {
        Integer count;
        Map<Integer, Integer> outgoing = this.outgoingEdges.get(source);
        if (outgoing == null) {
            outgoing = new HashMap<V, Integer>();
            this.outgoingEdges.put((Map<Integer, Integer>)source, (Map<Map<Integer, Integer>, Integer>)outgoing);
        }
        if ((count = outgoing.get(target)) == null) {
            count = 0;
        }
        count = count + 1;
        outgoing.put((Integer)target, count);
        Map<Integer, Integer> incoming = this.incomingEdges.get(target);
        if (incoming == null) {
            incoming = new HashMap<V, Integer>();
            this.incomingEdges.put((Map<Integer, Integer>)target, (Map<Map<Integer, Integer>, Integer>)incoming);
        }
        if ((count = incoming.get(source)) == null) {
            count = 0;
        }
        count = count + 1;
        incoming.put((Integer)source, count);
        for (IGraphObserver<V> go : this.observers) {
            go.edgeInserted(source, target);
        }
    }

    public void deleteEdge(V source, V target) {
        Map<Integer, Integer> incoming;
        boolean containedEdge = false;
        Integer count = null;
        Map<Integer, Integer> outgoing = this.outgoingEdges.get(source);
        if (outgoing != null && (count = outgoing.get(target)) != null) {
            containedEdge = true;
            if ((count = Integer.valueOf(count - 1)) == 0) {
                outgoing.remove(target);
            } else {
                outgoing.put((Integer)target, count);
            }
        }
        if ((incoming = this.incomingEdges.get(target)) != null && (count = incoming.get(source)) != null) {
            if ((count = Integer.valueOf(count - 1)) == 0) {
                incoming.remove(source);
            } else {
                incoming.put((Integer)source, count);
            }
        }
        if (containedEdge) {
            for (IGraphObserver<V> go : this.observers) {
                go.edgeDeleted(source, target);
            }
        }
    }

    public void insertNode(V node) {
        if (!this.outgoingEdges.containsKey(node)) {
            this.outgoingEdges.put(node, null);
        }
        if (!this.incomingEdges.containsKey(node)) {
            this.incomingEdges.put(node, null);
        }
        for (IGraphObserver<V> go : this.observers) {
            go.nodeInserted(node);
        }
    }

    public void deleteNode(V node) {
        int i;
        boolean containedNode = this.outgoingEdges.containsKey(node);
        Map<V, Integer> incoming = this.incomingEdges.get(node);
        Map<V, Integer> outgoing = this.outgoingEdges.get(node);
        if (incoming != null) {
            HashMap<V, Integer> _incoming = new HashMap<V, Integer>(incoming);
            for (Map.Entry entry : _incoming.entrySet()) {
                i = 0;
                while (i < (Integer)entry.getValue()) {
                    this.deleteEdge(entry.getKey(), node);
                    ++i;
                }
            }
        }
        if (outgoing != null) {
            HashMap<V, Integer> _outgoing = new HashMap<V, Integer>(outgoing);
            for (Map.Entry entry : _outgoing.entrySet()) {
                i = 0;
                while (i < (Integer)entry.getValue()) {
                    this.deleteEdge(node, entry.getKey());
                    ++i;
                }
            }
        }
        if (containedNode) {
            for (IGraphObserver<V> go : this.observers) {
                go.nodeDeleted(node);
            }
        }
    }

    @Override
    public void attachObserver(IGraphObserver<V> go) {
        this.observers.add(go);
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        this.observers.add(0, observer);
    }

    @Override
    public void detachObserver(IGraphObserver<V> go) {
        this.observers.remove(go);
    }

    @Override
    public Set<V> getAllNodes() {
        return this.outgoingEdges.keySet();
    }

    @Override
    public Map<V, Integer> getTargetNodes(V source) {
        Map<V, Integer> result = this.outgoingEdges.get(source);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    @Override
    public Map<V, Integer> getSourceNodes(V target) {
        Map<V, Integer> result = this.incomingEdges.get(target);
        if (result == null) {
            return Collections.emptyMap();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("nodes = ");
        for (V v : this.outgoingEdges.keySet()) {
            sb.append(v.toString());
            sb.append(" ");
        }
        sb.append(" edges = ");
        for (Map.Entry entry : this.outgoingEdges.entrySet()) {
            Object source = entry.getKey();
            Map targets = (Map)entry.getValue();
            if (targets == null) continue;
            for (Map.Entry targetEntry : targets.entrySet()) {
                int i = 0;
                while (i < (Integer)targetEntry.getValue()) {
                    sb.append("(" + source + "," + targetEntry.getKey() + ") ");
                    ++i;
                }
            }
        }
        return sb.toString();
    }

    public String generateDot(boolean colorSCCs, Function<V, String> nameMapper, Function<V, String> colorMapper) {
        HashMap<Object, String> colorMap = new HashMap<Object, String>();
        if (colorSCCs) {
            SCCResult result = SCC.computeSCC(this);
            Set set = result.getSccs();
            int i = 0;
            for (Set scc : set) {
                if (scc.size() <= 1) continue;
                for (Object v : scc) {
                    String color = (String)colorMap.get(v);
                    if (color == null) {
                        colorMap.put(v, colors[i % colors.length]);
                        continue;
                    }
                    colorMap.put(v, String.valueOf((String)colorMap.get(v)) + ":" + colors[i % colors.length]);
                }
                ++i;
            }
            for (Object node : this.outgoingEdges.keySet()) {
                if (colorMap.containsKey(node)) continue;
                colorMap.put(node, "white");
            }
        } else {
            for (V node : this.outgoingEdges.keySet()) {
                colorMap.put(node, "white");
            }
        }
        if (colorMapper != null) {
            for (V node : this.outgoingEdges.keySet()) {
                colorMap.put(node, (String)colorMapper.apply(node));
            }
        }
        StringBuilder builder = new StringBuilder();
        builder.append("digraph g {\n");
        for (V v : this.outgoingEdges.keySet()) {
            String nodePresentation = nameMapper == null ? v.toString() : (String)nameMapper.apply(v);
            builder.append("\"" + nodePresentation + "\"");
            builder.append("[style=filled,fillcolor=" + (String)colorMap.get(v) + "]");
            builder.append(";\n");
        }
        for (Map.Entry entry : this.outgoingEdges.entrySet()) {
            Object source = entry.getKey();
            Map targets = (Map)entry.getValue();
            if (targets == null) continue;
            for (Map.Entry entry2 : targets.entrySet()) {
                int i = 0;
                while (i < (Integer)entry2.getValue()) {
                    String sourcePresentation = nameMapper == null ? source.toString() : (String)nameMapper.apply(source);
                    String targetPresentation = nameMapper == null ? entry2.getKey().toString() : (String)nameMapper.apply(entry2.getKey());
                    builder.append("\"" + sourcePresentation + "\" -> \"" + targetPresentation + "\";\n");
                    ++i;
                }
            }
        }
        builder.append("}");
        return builder.toString();
    }

    public String generateDot() {
        return this.generateDot(false, null, null);
    }

    public Integer[] deleteRandomEdge() {
        return null;
    }

    public Integer[] insertRandomEdge() {
        return null;
    }
}

